/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.api.FetchRequestBuilder;
import kafka.api.ProducerFailureHandlingTest$;
import kafka.common.Topic$;
import kafka.consumer.SimpleConsumer;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.TestZKUtils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001\u001d\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t%A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"BA\u0006K+:LGoM*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005]!\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%IaH\u0001\u0013aJ|G-^2fe\n+hMZ3s'&TX-F\u0001!!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\rIe\u000e\u001e\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002'A\u0014x\u000eZ;dKJ\u0014UO\u001a4feNK'0\u001a\u0011\t\u000f%\u0002!\u0019!C\u0005?\u0005)2/\u001a:wKJlUm]:bO\u0016l\u0015\r\u001f\"zi\u0016\u001c\bBB\u0016\u0001A\u0003%\u0001%\u0001\ftKJ4XM]'fgN\fw-Z'bq\nKH/Z:!\u0011\u001di\u0003A1A\u0005\u0002}\t!B\\;n'\u0016\u0014h/\u001a:t\u0011\u0019y\u0003\u0001)A\u0005A\u0005Ya.^7TKJ4XM]:!\u0011\u001d\t\u0004A1A\u0005\u0002I\nqaY8oM&<7/F\u00014!\r!\u0014hO\u0007\u0002k)\u0011agN\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u000f\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002;k\t!A*[:u!\tat(D\u0001>\u0015\tqD!\u0001\u0004tKJ4XM]\u0005\u0003\u0001v\u00121bS1gW\u0006\u001cuN\u001c4jO\"1!\t\u0001Q\u0001\nM\n\u0001bY8oM&<7\u000f\t\u0005\b\t\u0002\u0001\r\u0011\"\u0003F\u0003%\u0019wN\\:v[\u0016\u0014\u0018'F\u0001G!\t9%*D\u0001I\u0015\tIE!\u0001\u0005d_:\u001cX/\\3s\u0013\tY\u0005J\u0001\bTS6\u0004H.Z\"p]N,X.\u001a:\t\u000f5\u0003\u0001\u0019!C\u0005\u001d\u0006i1m\u001c8tk6,'/M0%KF$\"a\u0014*\u0011\u0005\u0005\u0002\u0016BA)#\u0005\u0011)f.\u001b;\t\u000fMc\u0015\u0011!a\u0001\r\u0006\u0019\u0001\u0010J\u0019\t\rU\u0003\u0001\u0015)\u0003G\u0003)\u0019wN\\:v[\u0016\u0014\u0018\u0007\t\u0005\b/\u0002\u0001\r\u0011\"\u0003F\u0003%\u0019wN\\:v[\u0016\u0014(\u0007C\u0004Z\u0001\u0001\u0007I\u0011\u0002.\u0002\u001b\r|gn];nKJ\u0014t\fJ3r)\ty5\fC\u0004T1\u0006\u0005\t\u0019\u0001$\t\ru\u0003\u0001\u0015)\u0003G\u0003)\u0019wN\\:v[\u0016\u0014(\u0007\t\u0005\b?\u0002\u0001\r\u0011\"\u0003a\u0003%\u0001(o\u001c3vG\u0016\u0014\u0018'F\u0001b!\u0011\u0011'\u000e\u001c7\u000e\u0003\rT!\u0001Z3\u0002\u0011A\u0014x\u000eZ;dKJT!AZ4\u0002\u000f\rd\u0017.\u001a8ug*\u0011Q\u0001\u001b\u0006\u0003S:\ta!\u00199bG\",\u0017BA6d\u00055Y\u0015MZ6b!J|G-^2feB\u0019\u0011%\\8\n\u00059\u0014#!B!se\u0006L\bCA\u0011q\u0013\t\t(E\u0001\u0003CsR,\u0007bB:\u0001\u0001\u0004%I\u0001^\u0001\u000eaJ|G-^2feFzF%Z9\u0015\u0005=+\bbB*s\u0003\u0003\u0005\r!\u0019\u0005\u0007o\u0002\u0001\u000b\u0015B1\u0002\u0015A\u0014x\u000eZ;dKJ\f\u0004\u0005C\u0004z\u0001\u0001\u0007I\u0011\u00021\u0002\u0013A\u0014x\u000eZ;dKJ\u0014\u0004bB>\u0001\u0001\u0004%I\u0001`\u0001\u000eaJ|G-^2feJzF%Z9\u0015\u0005=k\bbB*{\u0003\u0003\u0005\r!\u0019\u0005\u0007\u007f\u0002\u0001\u000b\u0015B1\u0002\u0015A\u0014x\u000eZ;dKJ\u0014\u0004\u0005\u0003\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003a\u0003%\u0001(o\u001c3vG\u0016\u00148\u0007C\u0005\u0002\b\u0001\u0001\r\u0011\"\u0003\u0002\n\u0005i\u0001O]8ek\u000e,'oM0%KF$2aTA\u0006\u0011!\u0019\u0016QAA\u0001\u0002\u0004\t\u0007bBA\b\u0001\u0001\u0006K!Y\u0001\u000baJ|G-^2feN\u0002\u0003\u0002CA\n\u0001\u0001\u0007I\u0011\u00021\u0002\u0013A\u0014x\u000eZ;dKJ$\u0004\"CA\f\u0001\u0001\u0007I\u0011BA\r\u00035\u0001(o\u001c3vG\u0016\u0014Hg\u0018\u0013fcR\u0019q*a\u0007\t\u0011M\u000b)\"!AA\u0002\u0005Dq!a\b\u0001A\u0003&\u0011-\u0001\u0006qe>$WoY3si\u0001B\u0011\"a\t\u0001\u0005\u0004%I!!\n\u0002\rQ|\u0007/[22+\t\t9\u0003\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\t1\fgn\u001a\u0006\u0003\u0003c\tAA[1wC&!\u0011QGA\u0016\u0005\u0019\u0019FO]5oO\"A\u0011\u0011\b\u0001!\u0002\u0013\t9#A\u0004u_BL7-\r\u0011\t\u0013\u0005u\u0002A1A\u0005\n\u0005\u0015\u0012A\u0002;pa&\u001c'\u0007\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u0014\u0003\u001d!x\u000e]5de\u0001Bq!!\u0012\u0001\t\u0003\n9%A\u0003tKR,\u0006\u000fF\u0001P\u0011\u001d\tY\u0005\u0001C!\u0003\u000f\n\u0001\u0002^3be\u0012{wO\u001c\u0005\b\u0003\u001f\u0002A\u0011AA$\u0003u!Xm\u001d;U_>d\u0015M]4f%\u0016\u001cwN\u001d3XSRD\u0017iY6[KJ|\u0007\u0006BA'\u0003'\u0002B!!\u0016\u0002Z5\u0011\u0011q\u000b\u0006\u0003\u00179IA!a\u0017\u0002X\t!A+Z:u\u0011\u001d\ty\u0006\u0001C\u0001\u0003\u000f\nA\u0004^3tiR{w\u000eT1sO\u0016\u0014VmY8sI^KG\u000f[!dW>sW\r\u000b\u0003\u0002^\u0005M\u0003bBA3\u0001\u0011\u0005\u0011qI\u0001\u0015i\u0016\u001cHOT8o\u000bbL7\u000f^3oiR{\u0007/[2)\t\u0005\r\u00141\u000b\u0005\b\u0003W\u0002A\u0011AA$\u0003M!Xm\u001d;Xe>twM\u0011:pW\u0016\u0014H*[:uQ\u0011\tI'a\u0015\t\u000f\u0005E\u0004\u0001\"\u0001\u0002H\u0005qA/Z:u\u001d>\u0014Vm\u001d9p]N,\u0007\u0006BA8\u0003'Bq!a\u001e\u0001\t\u0003\t9%\u0001\u000buKN$\u0018J\u001c<bY&$\u0007+\u0019:uSRLwN\u001c\u0015\u0005\u0003k\n\u0019\u0006C\u0004\u0002~\u0001!\t!a\u0012\u0002'Q,7\u000f^*f]\u0012\fe\r^3s\u00072|7/\u001a3)\t\u0005m\u00141\u000b\u0005\b\u0003\u0007\u0003A\u0011AA$\u0003E!Xm\u001d;Ce>\\WM\u001d$bS2,(/\u001a\u0015\u0005\u0003\u0003\u000b\u0019\u0006C\u0004\u0002\n\u0002!\t!a\u0012\u0002;Q,7\u000f^\"b]:|GoU3oIR{\u0017J\u001c;fe:\fG\u000eV8qS\u000eD\u0003\"a\"\u0002T\u00055\u0015qR\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0019)'O]8sg*\u0019\u00111T4\u0002\r\r|W.\\8o\u0013\u0011\ty*!&\u0003+%sg/\u00197jIR{\u0007/[2Fq\u000e,\u0007\u000f^5p]\"9\u00111\u0015\u0001\u0005\u0002\u0005\u001d\u0013!\u0006;fgRtu\u000e^#o_V<\u0007NU3qY&\u001c\u0017m\u001d\u0015\u0005\u0003C\u000b\u0019\u0006C\u0004\u0002*\u0002!\t!a\u0012\u0002QQ,7\u000f\u001e(pi\u0016sw.^4i%\u0016\u0004H.[2bg\u00063G/\u001a:Ce>\\WM]*ikR$wn\u001e8)\t\u0005\u001d\u00161\u000b\u0004\u0007\u0003_\u0003A!!-\u0003#A\u0013x\u000eZ;dKJ\u001c6\r[3ek2,'o\u0005\u0003\u0002.\u0006M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005eF!A\u0003vi&d7/\u0003\u0003\u0002>\u0006]&AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012Dq!GAW\t\u0003\t\t\r\u0006\u0002\u0002DB!\u0011QYAW\u001b\u0005\u0001\u0001\"CAe\u0003[\u0013\r\u0011\"\u0001 \u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\t\u0003\u001b\fi\u000b)A\u0005A\u0005Ya.^7SK\u000e|'\u000fZ:!\u0011%\t\t.!,A\u0002\u0013\u0005q$\u0001\u0003tK:$\bBCAk\u0003[\u0003\r\u0011\"\u0001\u0002X\u0006A1/\u001a8u?\u0012*\u0017\u000fF\u0002P\u00033D\u0001bUAj\u0003\u0003\u0005\r\u0001\t\u0005\t\u0003;\fi\u000b)Q\u0005A\u0005)1/\u001a8uA!Q\u0011\u0011]AW\u0001\u0004%\t!a9\u0002\r\u0019\f\u0017\u000e\\3e+\t\t)\u000fE\u0002\"\u0003OL1!!;#\u0005\u001d\u0011un\u001c7fC:D!\"!<\u0002.\u0002\u0007I\u0011AAx\u0003)1\u0017-\u001b7fI~#S-\u001d\u000b\u0004\u001f\u0006E\b\"C*\u0002l\u0006\u0005\t\u0019AAs\u0011%\t)0!,!B\u0013\t)/A\u0004gC&dW\r\u001a\u0011\t\u0011\u0011\fiK1A\u0005\u0002\u0001D\u0001\"a?\u0002.\u0002\u0006I!Y\u0001\naJ|G-^2fe\u0002B\u0001\"a@\u0002.\u0012\u0005\u0013qI\u0001\u0007I><vN]6\t\u0011\t\r\u0011Q\u0016C!\u0003\u000f\n\u0001b\u001d5vi\u0012|wO\u001c")
public class ProducerFailureHandlingTest
extends JUnit3Suite
implements KafkaServerTestHarness {
    private final int kafka$api$ProducerFailureHandlingTest$$producerBufferSize;
    private final int kafka$api$ProducerFailureHandlingTest$$serverMessageMaxBytes;
    private final int numServers;
    private final List<KafkaConfig> configs;
    private SimpleConsumer consumer1;
    private SimpleConsumer consumer2;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3;
    private KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4;
    private final String kafka$api$ProducerFailureHandlingTest$$topic1;
    private final String topic2;
    private List<KafkaServer> servers;
    private String brokerList;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public int kafka$api$ProducerFailureHandlingTest$$producerBufferSize() {
        return this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize;
    }

    public int kafka$api$ProducerFailureHandlingTest$$serverMessageMaxBytes() {
        return this.kafka$api$ProducerFailureHandlingTest$$serverMessageMaxBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    private SimpleConsumer consumer1() {
        return this.consumer1;
    }

    private void consumer1_$eq(SimpleConsumer x$1) {
        this.consumer1 = x$1;
    }

    private SimpleConsumer consumer2() {
        return this.consumer2;
    }

    private void consumer2_$eq(SimpleConsumer x$1) {
        this.consumer2 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer1() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer1;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer2() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer2;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer3() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer3;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$api$ProducerFailureHandlingTest$$producer4() {
        return this.kafka$api$ProducerFailureHandlingTest$$producer4;
    }

    private void kafka$api$ProducerFailureHandlingTest$$producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = x$1;
    }

    public String kafka$api$ProducerFailureHandlingTest$$topic1() {
        return this.kafka$api$ProducerFailureHandlingTest$$topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        this.consumer1_$eq(new SimpleConsumer("localhost", ((KafkaConfig)this.configs().apply(0)).port(), 100, 0x100000, ""));
        this.consumer2_$eq(new SimpleConsumer("localhost", ((KafkaConfig)this.configs().apply(1)).port(), 100, 0x100000, ""));
        String x$3 = this.brokerList();
        int x$4 = 0;
        boolean x$5 = false;
        long x$6 = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
        long x$7 = TestUtils$.MODULE$.createNewProducer$default$3();
        int x$8 = TestUtils$.MODULE$.createNewProducer$default$6();
        this.kafka$api$ProducerFailureHandlingTest$$producer1_$eq(TestUtils$.MODULE$.createNewProducer(x$3, x$4, x$7, x$5, x$6, x$8));
        String x$9 = this.brokerList();
        int x$10 = 1;
        boolean x$11 = false;
        long x$12 = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
        long x$13 = TestUtils$.MODULE$.createNewProducer$default$3();
        int x$14 = TestUtils$.MODULE$.createNewProducer$default$6();
        this.kafka$api$ProducerFailureHandlingTest$$producer2_$eq(TestUtils$.MODULE$.createNewProducer(x$9, x$10, x$13, x$11, x$12, x$14));
        String x$15 = this.brokerList();
        int x$16 = -1;
        boolean x$17 = false;
        long x$18 = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
        long x$19 = TestUtils$.MODULE$.createNewProducer$default$3();
        int x$20 = TestUtils$.MODULE$.createNewProducer$default$6();
        this.kafka$api$ProducerFailureHandlingTest$$producer3_$eq(TestUtils$.MODULE$.createNewProducer(x$15, x$16, x$19, x$17, x$18, x$20));
    }

    @Override
    public void tearDown() {
        this.consumer1().close();
        this.consumer2().close();
        if (this.kafka$api$ProducerFailureHandlingTest$$producer1() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer1().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer2() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer2().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer3() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().close();
        }
        if (this.kafka$api$ProducerFailureHandlingTest$$producer4() != null) {
            this.kafka$api$ProducerFailureHandlingTest$$producer4().close();
        }
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.kafka$api$ProducerFailureHandlingTest$$serverMessageMaxBytes() + 1]);
        Assert.assertEquals((String)"Returned metadata should have offset -1", (Object)BoxesRunTime.boxToLong((long)((RecordMetadata)this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get()).offset()), (Object)BoxesRunTime.boxToLong((long)-1L));
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.kafka$api$ProducerFailureHandlingTest$$serverMessageMaxBytes() + 1]);
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$1).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$1 = record$1;
            }
        }, ManifestFactory$.MODULE$.classType(ExecutionException.class));
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$2;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$2).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = record$2;
            }
        }, ManifestFactory$.MODULE$.classType(ExecutionException.class));
    }

    @Test
    public void testWrongBrokerList() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        String x$21 = "localhost:8686,localhost:4242";
        int x$22 = 1;
        boolean x$23 = false;
        long x$24 = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
        long x$25 = TestUtils$.MODULE$.createNewProducer$default$3();
        int x$26 = TestUtils$.MODULE$.createNewProducer$default$6();
        this.kafka$api$ProducerFailureHandlingTest$$producer4_$eq(TestUtils$.MODULE$.createNewProducer(x$21, x$22, x$25, x$23, x$24, x$26));
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$3;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer4().send(this.record$3).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$3 = record$3;
            }
        }, ManifestFactory$.MODULE$.classType(ExecutionException.class));
    }

    @Test
    public void testNoResponse() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record1 = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record1).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer2().send(record1).get();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                server.requestHandlerPool().shutdown();
            }
        });
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record1).get(5000L, TimeUnit.MILLISECONDS);
        this.intercept((Function0)new Serializable(this, record1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record1$1;

            public final RecordMetadata apply() {
                return (RecordMetadata)this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record1$1).get(5000L, TimeUnit.MILLISECONDS);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record1$1 = record1$1;
            }
        }, ManifestFactory$.MODULE$.classType(TimeoutException.class));
        int tooManyRecords = 10;
        int msgSize = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize() / tooManyRecords;
        byte[] value = new byte[msgSize];
        new Random().nextBytes(value);
        ProducerRecord record2 = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)value);
        this.intercept((Function0)new Serializable(this, tooManyRecords, record2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final int tooManyRecords$1;
            public final ProducerRecord record2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.tooManyRecords$1).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testNoResponse$1 $outer;

                    public final Future<RecordMetadata> apply(int i) {
                        return this.$outer.kafka$api$ProducerFailureHandlingTest$$anonfun$$$outer().kafka$api$ProducerFailureHandlingTest$$producer2().send(this.$outer.record2$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ProducerFailureHandlingTest kafka$api$ProducerFailureHandlingTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tooManyRecords$1 = tooManyRecords$1;
                this.record2$1 = record2$1;
            }
        }, ManifestFactory$.MODULE$.classType(KafkaException.class));
        this.kafka$api$ProducerFailureHandlingTest$$producer2_$eq(null);
    }

    @Test
    public void testInvalidPartition() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), new Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$4;

            public final Future<RecordMetadata> apply() {
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().send(this.record$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$4 = record$4;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
    }

    @Test
    public void testSendAfterClosed() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.kafka$api$ProducerFailureHandlingTest$$topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer2().send(record).get();
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$5;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer1().send(this.record$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$5 = record$5;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalStateException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$5;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer2().send(this.record$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$5 = record$5;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalStateException.class));
        this.intercept((Function0)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final ProducerRecord record$5;

            public final Future<RecordMetadata> apply() {
                this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().close();
                return this.$outer.kafka$api$ProducerFailureHandlingTest$$producer3().send(this.record$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$5 = record$5;
            }
        }, ManifestFactory$.MODULE$.classType(IllegalStateException.class));
    }

    @Test
    public void testBrokerFailure() {
        Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkClient(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int partition = 0;
        Assert.assertTrue((String)"Leader of partition 0 of the topic should exist", (boolean)((Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)partition))).isDefined());
        ProducerScheduler scheduler = new ProducerScheduler();
        scheduler.start();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach((Function1)new Serializable(this, partition, scheduler){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;
            private final int partition$1;
            private final ProducerScheduler scheduler$1;

            public final Option<Object> apply(int i) {
                this.$outer.servers().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(KafkaServer server) {
                        server.shutdown();
                        server.awaitShutdown();
                        server.startup();
                        Thread.sleep(2000L);
                    }
                });
                Assert.assertTrue((!this.scheduler$1.failed() ? 1 : 0) != 0);
                return TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.$outer.zkClient(), this.$outer.kafka$api$ProducerFailureHandlingTest$$topic1(), this.partition$1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
                this.scheduler$1 = scheduler$1;
            }
        });
        scheduler.shutdown();
        Assert.assertTrue((!scheduler.failed() ? 1 : 0) != 0);
        int leader = TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.kafka$api$ProducerFailureHandlingTest$$topic1(), partition, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ByteBufferMessageSet fetchResponse = leader == ((KafkaConfig)this.configs().apply(0)).brokerId() ? this.consumer1().fetch(new FetchRequestBuilder().addFetch(this.kafka$api$ProducerFailureHandlingTest$$topic1(), partition, 0L, Integer.MAX_VALUE).build()).messageSet(this.kafka$api$ProducerFailureHandlingTest$$topic1(), partition) : this.consumer2().fetch(new FetchRequestBuilder().addFetch(this.kafka$api$ProducerFailureHandlingTest$$topic1(), partition, 0L, Integer.MAX_VALUE).build()).messageSet(this.kafka$api$ProducerFailureHandlingTest$$topic1(), partition);
        List messages2 = (List)fetchResponse.iterator().toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(MessageAndOffset x$1) {
                return x$1.message();
            }
        }, List$.MODULE$.canBuildFrom());
        Set uniqueMessages = messages2.toSet();
        int uniqueMessageSize = uniqueMessages.size();
        Assert.assertEquals((String)new StringBuilder().append((Object)"Should have fetched ").append((Object)BoxesRunTime.boxToInteger((int)scheduler.sent())).append((Object)" unique messages").toString(), (Object)BoxesRunTime.boxToInteger((int)scheduler.sent()), (Object)BoxesRunTime.boxToInteger((int)uniqueMessageSize));
    }

    @Test(expected=InvalidTopicException.class)
    public void testCannotSendToInternalTopic() {
        this.kafka$api$ProducerFailureHandlingTest$$producer1().send(new ProducerRecord((String)Topic$.MODULE$.InternalTopics().head(), (Object)"test".getBytes(), (Object)"test".getBytes())).get();
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", "3");
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicName, 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        try {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas");
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NotEnoughReplicasException) {
                return;
            }
            throw this.fail("Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas");
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", "2");
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicName, 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        try {
            this.kafka$api$ProducerFailureHandlingTest$$producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas");
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof NotEnoughReplicasException) {
                ((KafkaServer)this.servers().head()).startup();
                return;
            }
            throw this.fail("Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas");
        }
    }

    public ProducerFailureHandlingTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize = 30000;
        this.kafka$api$ProducerFailureHandlingTest$$serverMessageMaxBytes = this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize() / 2;
        this.numServers = 2;
        this.configs = (List)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), false).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerFailureHandlingTest $outer;

            public final KafkaConfig apply(Properties props) {
                return new KafkaConfig(this, props){
                    private final String zkConnect;
                    private final boolean autoCreateTopicsEnable;
                    private final int messageMaxBytes;
                    private final short offsetsTopicReplicationFactor;

                    public String zkConnect() {
                        return this.zkConnect;
                    }

                    public boolean autoCreateTopicsEnable() {
                        return this.autoCreateTopicsEnable;
                    }

                    public int messageMaxBytes() {
                        return this.messageMaxBytes;
                    }

                    public short offsetsTopicReplicationFactor() {
                        return this.offsetsTopicReplicationFactor;
                    }
                    {
                        super(props$1);
                        this.zkConnect = TestZKUtils$.MODULE$.zookeeperConnect();
                        this.autoCreateTopicsEnable = false;
                        this.messageMaxBytes = $outer.kafka$api$ProducerFailureHandlingTest$$anonfun$$$outer().kafka$api$ProducerFailureHandlingTest$$serverMessageMaxBytes();
                        this.offsetsTopicReplicationFactor = (short)1;
                    }
                };
            }

            public /* synthetic */ ProducerFailureHandlingTest kafka$api$ProducerFailureHandlingTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        this.consumer1 = null;
        this.consumer2 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer1 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer2 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer3 = null;
        this.kafka$api$ProducerFailureHandlingTest$$producer4 = null;
        this.kafka$api$ProducerFailureHandlingTest$$topic1 = "topic-1";
        this.topic2 = "topic-2";
    }

    public class ProducerScheduler
    extends ShutdownableThread {
        private final int numRecords;
        private int sent;
        private boolean failed;
        private final KafkaProducer<byte[], byte[]> producer;

        public int numRecords() {
            return this.numRecords;
        }

        public int sent() {
            return this.sent;
        }

        public void sent_$eq(int x$1) {
            this.sent = x$1;
        }

        public boolean failed() {
            return this.failed;
        }

        public void failed_$eq(boolean x$1) {
            this.failed = x$1;
        }

        public KafkaProducer<byte[], byte[]> producer() {
            return this.producer;
        }

        public void doWork() {
            IndexedSeq responses = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(this.sent() + 1), this.sent() + this.numRecords()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerScheduler $outer;

                public final Future<RecordMetadata> apply(int i) {
                    return this.$outer.producer().send(new ProducerRecord(this.$outer.kafka$api$ProducerFailureHandlingTest$ProducerScheduler$$$outer().kafka$api$ProducerFailureHandlingTest$$topic1(), null, null, (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes()));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            List futures = responses.toList();
            try {
                futures.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RecordMetadata apply(Future<RecordMetadata> x$2) {
                        return x$2.get();
                    }
                }, List$.MODULE$.canBuildFrom());
                this.sent_$eq(this.sent() + this.numRecords());
            }
            catch (Exception exception) {
                this.failed_$eq(true);
            }
        }

        public void shutdown() {
            super.shutdown();
            this.producer().close();
        }

        public /* synthetic */ ProducerFailureHandlingTest kafka$api$ProducerFailureHandlingTest$ProducerScheduler$$$outer() {
            return ProducerFailureHandlingTest.this;
        }

        public ProducerScheduler() {
            if (ProducerFailureHandlingTest.this == null) {
                throw null;
            }
            super("daemon-producer", false);
            this.numRecords = 1000;
            this.sent = 0;
            this.failed = false;
            String x$27 = ProducerFailureHandlingTest.this.brokerList();
            long x$28 = ProducerFailureHandlingTest.this.kafka$api$ProducerFailureHandlingTest$$producerBufferSize();
            int x$29 = 10;
            int x$30 = TestUtils$.MODULE$.createNewProducer$default$2();
            long x$31 = TestUtils$.MODULE$.createNewProducer$default$3();
            boolean x$32 = TestUtils$.MODULE$.createNewProducer$default$4();
            this.producer = TestUtils$.MODULE$.createNewProducer(x$27, x$30, x$31, x$32, x$28, x$29);
        }
    }
}

