/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import junit.framework.Assert;
import kafka.consumer.Blacklist;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.WildcardTopicCount;
import kafka.server.OffsetManager$;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000112A!\u0001\u0002\u0001\u000f\tyAk\u001c9jG\u001aKG\u000e^3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u0011!BS+oSR\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$\u0001\buKN$x\u000b[5uK2L7\u000f^:\u0015\u0003i\u0001\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011A!\u00168ji\"\u0012q#\t\t\u0003E\u0011j\u0011a\t\u0006\u0003\u00179I!!J\u0012\u0003\tQ+7\u000f\u001e\u0005\u0006O\u0001!\t!G\u0001\u000fi\u0016\u001cHO\u00117bG.d\u0017n\u001d;tQ\t1\u0013\u0005C\u0003+\u0001\u0011\u0005\u0011$\u0001\u0019uKN$x+\u001b7eG\u0006\u0014H\rV8qS\u000e\u001cu.\u001e8u\u000f\u0016$Hk\u001c9jG\u000e{WO\u001c;NCB,5oY1qK*\u001bxN\u001c\u0015\u0003S\u0005\u0002")
public class TopicFilterTest
extends JUnitSuite {
    @Test
    public void testWhitelists() {
        Whitelist topicFilter1 = new Whitelist("white1,white2");
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("white2", true));
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("white2", false));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("black1", true));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("black1", false));
        Whitelist topicFilter2 = new Whitelist(".+");
        Assert.assertTrue((boolean)topicFilter2.isTopicAllowed("alltopics", true));
        Assert.assertFalse((boolean)topicFilter2.isTopicAllowed(OffsetManager$.MODULE$.OffsetsTopicName(), true));
        Assert.assertTrue((boolean)topicFilter2.isTopicAllowed(OffsetManager$.MODULE$.OffsetsTopicName(), false));
        Whitelist topicFilter3 = new Whitelist("white_listed-topic.+");
        Assert.assertTrue((boolean)topicFilter3.isTopicAllowed("white_listed-topic1", true));
        Assert.assertFalse((boolean)topicFilter3.isTopicAllowed("black1", true));
        Whitelist topicFilter4 = new Whitelist("test-(?!bad\\b)[\\w]+");
        Assert.assertTrue((boolean)topicFilter4.isTopicAllowed("test-good", true));
        Assert.assertFalse((boolean)topicFilter4.isTopicAllowed("test-bad", true));
    }

    @Test
    public void testBlacklists() {
        Blacklist topicFilter1 = new Blacklist("black1");
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("white2", true));
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed("white2", false));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("black1", true));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed("black1", false));
        Assert.assertFalse((boolean)topicFilter1.isTopicAllowed(OffsetManager$.MODULE$.OffsetsTopicName(), true));
        Assert.assertTrue((boolean)topicFilter1.isTopicAllowed(OffsetManager$.MODULE$.OffsetsTopicName(), false));
    }

    @Test
    public void testWildcardTopicCountGetTopicCountMapEscapeJson() {
        Assert.assertEquals((String)"-\\\"-", (String)this.getTopicCountMapKey$1("-\"-"));
        Assert.assertEquals((String)"-\\\\-", (String)this.getTopicCountMapKey$1("-\\-"));
        Assert.assertEquals((String)"-\\/-", (String)this.getTopicCountMapKey$1("-/-"));
        Assert.assertEquals((String)"-\\\\b-", (String)this.getTopicCountMapKey$1("-\\b-"));
        Assert.assertEquals((String)"-\\\\f-", (String)this.getTopicCountMapKey$1("-\\f-"));
        Assert.assertEquals((String)"-\\\\n-", (String)this.getTopicCountMapKey$1("-\\n-"));
        Assert.assertEquals((String)"-\\\\r-", (String)this.getTopicCountMapKey$1("-\\r-"));
        Assert.assertEquals((String)"-\\\\t-", (String)this.getTopicCountMapKey$1("-\\t-"));
        Assert.assertEquals((String)"-\\\\u0000-", (String)this.getTopicCountMapKey$1("-\\u0000-"));
        Assert.assertEquals((String)"-\\\\u001f-", (String)this.getTopicCountMapKey$1("-\\u001f-"));
        Assert.assertEquals((String)"-\\\\u007f-", (String)this.getTopicCountMapKey$1("-\\u007f-"));
        Assert.assertEquals((String)"-\\\\u009f-", (String)this.getTopicCountMapKey$1("-\\u009f-"));
    }

    private final String getTopicCountMapKey$1(String regex) {
        WildcardTopicCount topicCount = new WildcardTopicCount(null, "consumerId", (TopicFilter)new Whitelist(regex), 1, true);
        return (String)((Tuple2)topicCount.getTopicCountMap().head())._1();
    }
}

