/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import kafka.common.MessageSetSizeTooLargeException;
import kafka.common.MessageSizeTooLargeException;
import kafka.common.OffsetOutOfRangeException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.NoCompressionCodec$;
import kafka.server.KafkaConfig;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001\u001d\u0011q\u0001T8h)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001\u0001\u0019!C\u00013\u00051An\\4ESJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\rC\u0004$\u0001\u0001\u0007I\u0011\u0001\u0013\u0002\u00151|w\rR5s?\u0012*\u0017\u000f\u0006\u0002&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t!QK\\5u\u0011\u001da#%!AA\u0002i\t1\u0001\u001f\u00132\u0011\u0019q\u0003\u0001)Q\u00055\u00059An\\4ESJ\u0004\u0003b\u0002\u0019\u0001\u0005\u0004%\t!M\u0001\u0005i&lW-F\u00013!\t\u0019d'D\u00015\u0015\t)D!A\u0003vi&d7/\u0003\u00028i\tAQj\\2l)&lW\r\u0003\u0004:\u0001\u0001\u0006IAM\u0001\u0006i&lW\r\t\u0005\bw\u0001\u0001\r\u0011\"\u0001=\u0003\u0019\u0019wN\u001c4jOV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A\t\u000511/\u001a:wKJL!AQ \u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\t\u0002\u0001\r\u0011\"\u0001F\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003K\u0019Cq\u0001L\"\u0002\u0002\u0003\u0007Q\b\u0003\u0004I\u0001\u0001\u0006K!P\u0001\bG>tg-[4!\u0011\u001dQ\u0005A1A\u0005\u0002-\u000b\u0011\u0002\\8h\u0007>tg-[4\u0016\u00031\u0003\"AF'\n\u00059\u0013!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u0001\u0006\u0001)A\u0005\u0019\u0006QAn\\4D_:4\u0017n\u001a\u0011\t\u000bI\u0003A\u0011A*\u0002\u000bM,G/\u00169\u0015\u0003\u0015B#!U+\u0011\u0005YCV\"A,\u000b\u0005-q\u0011BA-X\u0005\u0019\u0011UMZ8sK\")1\f\u0001C\u0001'\u0006AA/Z1s\t><h\u000e\u000b\u0002[;B\u0011aKX\u0005\u0003?^\u0013Q!\u00114uKJDQ!\u0019\u0001\u0005\u0002\t\fqb\u0019:fCR,W)\u001c9us2{wm\u001d\u000b\u0004K\r,\u0007\"\u00023a\u0001\u0004Q\u0012a\u00013je\")a\r\u0019a\u0001O\u00069qN\u001a4tKR\u001c\bc\u0001\u0014iU&\u0011\u0011n\n\u0002\u000byI,\u0007/Z1uK\u0012t\u0004C\u0001\u0014l\u0013\tawEA\u0002J]RDQA\u001c\u0001\u0005\u0002M\u000bA\u0003^3tiRKW.\u001a\"bg\u0016$Gj\\4S_2d\u0007FA7q!\t1\u0016/\u0003\u0002s/\n!A+Z:u\u0011\u0015!\b\u0001\"\u0001T\u0003i!Xm\u001d;US6,')Y:fI2{wMU8mY*KG\u000f^3sQ\t\u0019\b\u000fC\u0003x\u0001\u0011\u00051+\u0001\u000buKN$8+\u001b>f\u0005\u0006\u001cX\r\u001a'pOJ{G\u000e\u001c\u0015\u0003mBDQA\u001f\u0001\u0005\u0002M\u000b\u0001\u0003^3ti2{\u0017\rZ#naRLHj\\4)\u0005e\u0004\b\"B?\u0001\t\u0003\u0019\u0016A\n;fgR\f\u0005\u000f]3oI\u0006sGMU3bI^KG\u000f[*fcV,g\u000e^5bY>3gm]3ug\"\u0012A\u0010\u001d\u0005\u0007\u0003\u0003\u0001A\u0011A*\u0002SQ,7\u000f^!qa\u0016tG-\u00118e%\u0016\fGmV5uQ:{gnU3rk\u0016tG/[1m\u001f\u001a47/\u001a;tQ\ty\b\u000f\u0003\u0004\u0002\b\u0001!\taU\u0001\u0011i\u0016\u001cHOU3bI\u0006#Hj\\4HCBD3!!\u0002q\u0011\u0019\ti\u0001\u0001C\u0001'\u0006\u0011B/Z:u%\u0016\fGmT;u\u001f\u001a\u0014\u0016M\\4fQ\r\tY\u0001\u001d\u0005\u0007\u0003'\u0001A\u0011A*\u0002\u0019Q,7\u000f\u001e'pOJ{G\u000e\\:)\u0007\u0005E\u0001\u000f\u0003\u0004\u0002\u001a\u0001!\taU\u0001\u0017i\u0016\u001cHoQ8naJ,7o]3e\u001b\u0016\u001c8/Y4fg\"\u001a\u0011q\u00039\t\r\u0005}\u0001\u0001\"\u0001T\u0003M\"Xm\u001d;UQ\u0006$x)\u0019:cC\u001e,7i\u001c7mK\u000e$\u0018N\\4TK\u001elWM\u001c;t\t>,7O\u001c;DQ\u0006tw-Z(gMN,G\u000fK\u0002\u0002\u001eADa!!\n\u0001\t\u0003\u0019\u0016a\u0006;fgRlUm]:bO\u0016\u001cV\r^*ju\u0016\u001c\u0005.Z2lQ\r\t\u0019\u0003\u001d\u0005\u0007\u0003W\u0001A\u0011A*\u0002)Q,7\u000f^'fgN\fw-Z*ju\u0016\u001c\u0005.Z2lQ\r\tI\u0003\u001d\u0005\u0007\u0003c\u0001A\u0011A*\u0002=Q,7\u000f\u001e'pOJ+7m\u001c<feN$vnQ8se\u0016\u001cGo\u00144gg\u0016$\bfAA\u0018a\"1\u0011q\u0007\u0001\u0005\u0002M\u000b\u0001\u0003^3ti&sG-\u001a=SK\n,\u0018\u000e\u001c3)\u0007\u0005U\u0002\u000f\u0003\u0004\u0002>\u0001!\taU\u0001\u000fi\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a+pQ\r\tY\u0004\u001d\u0005\u0007\u0003\u0007\u0002A\u0011A*\u0002;Q,7\u000f^%oI\u0016D(+Z:ju&tw-\u0011;UeVt7-\u0019;j_:D3!!\u0011q\u0011\u0019\tI\u0005\u0001C\u0001'\u0006\u0001C/Z:u\u0005><Wo]%oI\u0016D8+Z4nK:$8/\u0011:f%\u0016lwN^3eQ\r\t9\u0005\u001d\u0005\u0007\u0003\u001f\u0002A\u0011A*\u0002-Q,7\u000f\u001e*f_B,g\u000e\u00165f]R\u0013XO\\2bi\u0016D3!!\u0014q\u0011\u0019\t)\u0006\u0001C\u0001'\u0006yA/Z:u\u0003NLhn\u0019#fY\u0016$X\rK\u0002\u0002TADa!a\u0017\u0001\t\u0003\u0019\u0016\u0001\b;fgR|\u0005/\u001a8EK2,G/Z:PEN|G.\u001a;f\r&dWm\u001d\u0015\u0004\u00033\u0002\bBBA1\u0001\u0011\u00051+\u0001\u0011uKN$\u0018\t\u001d9f]\u0012lUm]:bO\u0016<\u0016\u000e\u001e5Ok2d\u0007+Y=m_\u0006$\u0007fAA0a\"1\u0011q\r\u0001\u0005\u0002M\u000ba\u0002^3ti\u000e{'O];qi2{w\rK\u0002\u0002fADa!!\u001c\u0001\t\u0003\u0019\u0016!\u0006;fgR\u001cE.Z1o'\",H\u000fZ8x]\u001aKG.\u001a\u0015\u0004\u0003W\u0002\b")
public class LogTest
extends JUnitSuite {
    private File logDir = null;
    private final MockTime time = new MockTime(0L);
    private KafkaConfig config = null;
    private final LogConfig logConfig = new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13(), LogConfig$.MODULE$.apply$default$14(), LogConfig$.MODULE$.apply$default$15(), LogConfig$.MODULE$.apply$default$16());

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public MockTime time() {
        return this.time;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, -1, TestUtils$.MODULE$.createBrokerConfig$default$3());
        this.config_$eq(new KafkaConfig(props));
    }

    @After
    public void tearDown() {
        Utils$.MODULE$.rm(this.logDir());
    }

    public void createEmptyLogs(File dir, Seq<Object> offsets) {
        offsets.foreach((Function1)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final boolean apply(int offset) {
                return this.apply$mcZI$sp(offset);
            }

            public boolean apply$mcZI$sp(int offset) {
                Log$.MODULE$.logFilename(this.dir$1, (long)offset).createNewFile();
                return Log$.MODULE$.indexFilename(this.dir$1, (long)offset).createNewFile();
            }
            {
                this.dir$1 = dir$1;
            }
        });
    }

    @Test
    public void testTimeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        long x$19 = 3600L;
        int x$20 = this.logConfig().copy$default$1();
        long x$21 = this.logConfig().copy$default$3();
        long x$22 = this.logConfig().copy$default$4();
        long x$23 = this.logConfig().copy$default$5();
        long x$24 = this.logConfig().copy$default$6();
        long x$25 = this.logConfig().copy$default$7();
        int x$26 = this.logConfig().copy$default$8();
        int x$27 = this.logConfig().copy$default$9();
        int x$28 = this.logConfig().copy$default$10();
        long x$29 = this.logConfig().copy$default$11();
        long x$30 = this.logConfig().copy$default$12();
        double x$31 = this.logConfig().copy$default$13();
        boolean x$32 = this.logConfig().copy$default$14();
        boolean x$33 = this.logConfig().copy$default$15();
        int x$34 = this.logConfig().copy$default$16();
        Log log = new Log(this.logDir(), this.logConfig().copy(x$20, x$19, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Log begins with a single empty segment.", (int)1, (int)log.numberOfSegments());
        this.time().sleep(log.config().segmentMs() + 1L);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log doesn't roll if doing so creates an empty segment.", (int)1, (int)log.numberOfSegments());
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log rolls on this append since time has expired.", (int)2, (int)log.numberOfSegments());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ByteBufferMessageSet set$1;
            private final Log log$1;

            public final void apply(int numSegments) {
                this.apply$mcVI$sp(numSegments);
            }

            public void apply$mcVI$sp(int numSegments) {
                this.$outer.time().sleep(this.log$1.config().segmentMs() + 1L);
                this.log$1.append(this.set$1, this.log$1.append$default$2());
                Assert.assertEquals((String)"Changing time beyond rollMs and appending should create a new segment.", (int)numSegments, (int)this.log$1.numberOfSegments());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.set$1 = set$1;
                this.log$1 = log$1;
            }
        });
        int numSegments = log.numberOfSegments();
        this.time().sleep(log.config().segmentMs() + 1L);
        log.append(new ByteBufferMessageSet((Seq)Nil$.MODULE$), log.append$default$2());
        Assert.assertEquals((String)"Appending an empty message set should not roll log even if succient time has passed.", (int)numSegments, (int)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedLogRollJitter() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        long maxJitter = 1200L;
        long x$35 = 3600L;
        long x$36 = maxJitter;
        int x$37 = this.logConfig().copy$default$1();
        long x$38 = this.logConfig().copy$default$4();
        long x$39 = this.logConfig().copy$default$5();
        long x$40 = this.logConfig().copy$default$6();
        long x$41 = this.logConfig().copy$default$7();
        int x$42 = this.logConfig().copy$default$8();
        int x$43 = this.logConfig().copy$default$9();
        int x$44 = this.logConfig().copy$default$10();
        long x$45 = this.logConfig().copy$default$11();
        long x$46 = this.logConfig().copy$default$12();
        double x$47 = this.logConfig().copy$default$13();
        boolean x$48 = this.logConfig().copy$default$14();
        boolean x$49 = this.logConfig().copy$default$15();
        int x$50 = this.logConfig().copy$default$16();
        Log log = new Log(this.logDir(), this.logConfig().copy(x$37, x$35, x$36, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45, x$46, x$47, x$48, x$49, x$50), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Log begins with a single empty segment.", (int)1, (int)log.numberOfSegments());
        log.append(set, log.append$default$2());
        this.time().sleep(log.config().segmentMs() - maxJitter);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log does not roll on this append because it occurs earlier than max jitter", (int)1, (int)log.numberOfSegments());
        this.time().sleep(maxJitter - log.activeSegment().rollJitterMs() + 1L);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log should roll after segmentMs adjusted by random jitter", (int)2, (int)log.numberOfSegments());
    }

    @Test
    public void testSizeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * (setSize - 1);
        Log log = new Log(this.logDir(), this.logConfig().copy(segmentSize, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg + 1).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$2;
            private final Log log$2;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$2.append(this.set$2, this.log$2.append$default$2());
            }
            {
                this.set$2 = set$2;
                this.log$2 = log$2;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segments.", (int)2, (int)log.numberOfSegments());
    }

    @Test
    public void testLoadEmptyLog() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        Log log = new Log(this.logDir(), this.logConfig(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2());
    }

    @Test
    public void testAppendAndReadWithSequentialOffsets() {
        Log log = new Log(this.logDir(), this.logConfig().copy(71, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messages2 = (Message[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).by(2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Message.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$3.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$1[i]})), this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach$mVc$sp((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageAndOffset read = (MessageAndOffset)this.log$3.read((long)i, 100, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1)))).messageSet().head();
                Assert.assertEquals((String)"Offset read should match order appended.", (long)i, (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$1[i], (Object)read.message());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        Assert.assertEquals((String)"Reading beyond the last message returns nothing.", (int)0, (int)log.read((long)messages2.length, 100, (Option)None$.MODULE$).messageSet().size());
    }

    @Test
    public void testAppendAndReadWithNonSequentialOffsets() {
        Log log = new Log(this.logDir(), this.logConfig().copy(71, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int[] messageIds = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 200).by(7), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        Message[] messages2 = (Message[])Predef$.MODULE$.intArrayOps(messageIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Message.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$4.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new AtomicLong(this.messageIds$1[i]), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$2[i]})), false);
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(messageIds).max((Ordering)Ordering.Int$.MODULE$))).foreach$mVc$sp((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx = Predef$.MODULE$.intArrayOps(this.messageIds$1).indexWhere((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final boolean apply(int x$1) {
                        return this.apply$mcZI$sp(x$1);
                    }

                    public boolean apply$mcZI$sp(int x$1) {
                        return x$1 >= this.i$1;
                    }
                    {
                        this.i$1 = i$1;
                    }
                });
                MessageAndOffset read = (MessageAndOffset)this.log$4.read((long)i, 100, (Option)None$.MODULE$).messageSet().head();
                Assert.assertEquals((String)"Offset read should match message id.", (long)this.messageIds$1[idx], (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$2[idx], (Object)read.message());
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
    }

    @Test
    public void testReadAtLogGap() {
        Log log = new Log(this.logDir(), this.logConfig().copy(300, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        while (log.numberOfSegments() == 1) {
            log.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("42".getBytes())})), log.append$default$2());
        }
        ((LogSegment)log.logSegments().head()).truncateTo(1L);
        Assert.assertEquals((String)"A read should now return the last message in the log", (long)(log.logEndOffset() - 1L), (long)((MessageAndOffset)log.read(1L, 200, (Option)None$.MODULE$).messageSet().head()).offset());
    }

    @Test
    public void testReadOutOfRange() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{1024}));
        Log log = new Log(this.logDir(), this.logConfig().copy(1024, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Reading just beyond end of log should produce 0 byte read.", (int)0, (int)log.read(1024L, 1000, log.read$default$3()).messageSet().sizeInBytes());
        try {
            log.read(0L, 1024, log.read$default$3());
            throw this.fail("Expected exception on invalid read.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            try {
                log.read(1025L, 1000, log.read$default$3());
                throw this.fail("Expected exception on invalid read.");
            }
            catch (OffsetOutOfRangeException offsetOutOfRangeException2) {
                return;
            }
        }
    }

    @Test
    public void testLogRolls() {
        Log log = new Log(this.logDir(), this.logConfig().copy(100, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int numMessages = 100;
        IndexedSeq messageSets = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBufferMessageSet apply(int i) {
                return TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        messageSets.foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$5;

            public final Log.LogAppendInfo apply(ByteBufferMessageSet x$2) {
                return this.log$5.append(x$2, this.log$5.append$default$2());
            }
            {
                this.log$5 = log$5;
            }
        });
        log.flush();
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log, messageSets, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$5;
            private final IndexedSeq messageSets$1;
            private final LongRef offset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageSet messages2 = this.log$5.read(this.offset$1.elem, 0x100000, this.log$5.read$default$3()).messageSet();
                Assert.assertEquals((String)"Offsets not equal", (long)this.offset$1.elem, (long)((MessageAndOffset)messages2.head()).offset());
                Assert.assertEquals((String)new StringBuilder().append((Object)"Messages not equal at offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString(), (Object)((MessageAndOffset)((IterableLike)this.messageSets$1.apply(i)).head()).message(), (Object)((MessageAndOffset)messages2.head()).message());
                this.offset$1.elem = ((MessageAndOffset)messages2.head()).offset() + 1L;
            }
            {
                this.log$5 = log$5;
                this.messageSets$1 = messageSets$1;
                this.offset$1 = offset$1;
            }
        });
        MessageSet lastRead = log.read((long)numMessages, 0x100000, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(numMessages + 1)))).messageSet();
        Assert.assertEquals((String)"Should be no more messages", (int)0, (int)lastRead.size());
        TestUtils$.MODULE$.retry(1000L, (Function0<BoxedUnit>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertTrue((String)"Log role should have forced flush", (this.log$5.recoveryPoint() >= this.log$5.activeSegment().baseOffset() ? 1 : 0) != 0);
            }
            {
                this.log$5 = log$5;
            }
        });
    }

    @Test
    public void testCompressedMessages() {
        Log log = new Log(this.logDir(), this.logConfig().copy(100, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())})), log.append$default$2());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("alpha".getBytes()), new Message("beta".getBytes())})), log.append$default$2());
        Assert.assertEquals((String)"Read at offset 0 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(0, log).head()).offset());
        Assert.assertEquals((String)"Read at offset 1 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(1, log).head()).offset());
        Assert.assertEquals((String)"Read at offset 2 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(2, log).head()).offset());
        Assert.assertEquals((String)"Read at offset 3 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(3, log).head()).offset());
    }

    @Test
    public void testThatGarbageCollectingSegmentsDoesntChangeOffset() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 25})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final void apply(int messagesToAppend) {
                this.apply$mcVI$sp(messagesToAppend);
            }

            public void apply$mcVI$sp(int messagesToAppend) {
                this.$outer.logDir().mkdirs();
                Log log = new Log(this.$outer.logDir(), this.$outer.logConfig().copy(100, this.$outer.logConfig().copy$default$2(), this.$outer.logConfig().copy$default$3(), this.$outer.logConfig().copy$default$4(), this.$outer.logConfig().copy$default$5(), this.$outer.logConfig().copy$default$6(), this.$outer.logConfig().copy$default$7(), this.$outer.logConfig().copy$default$8(), this.$outer.logConfig().copy$default$9(), this.$outer.logConfig().copy$default$10(), this.$outer.logConfig().copy$default$11(), this.$outer.logConfig().copy$default$12(), this.$outer.logConfig().copy$default$13(), this.$outer.logConfig().copy$default$14(), this.$outer.logConfig().copy$default$15(), this.$outer.logConfig().copy$default$16()), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesToAppend).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final Log log$7;

                    public final Log.LogAppendInfo apply(int i) {
                        return this.log$7.append(TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), this.log$7.append$default$2());
                    }
                    {
                        this.log$7 = log$7;
                    }
                });
                long currOffset = log.logEndOffset();
                Assert.assertEquals((long)currOffset, (long)messagesToAppend);
                log.deleteOldSegments((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogSegment x$3) {
                        return true;
                    }
                });
                Assert.assertEquals((String)"Deleting segments shouldn't have changed the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"We should still have one segment left", (int)1, (int)log.numberOfSegments());
                Assert.assertEquals((String)"Further collection shouldn't delete anything", (int)0, (int)log.deleteOldSegments((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogSegment x$4) {
                        return true;
                    }
                }));
                Assert.assertEquals((String)"Still no change in the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"Should still be able to append and should get the logEndOffset assigned to the new append", (long)currOffset, (long)log.append(TestUtils$.MODULE$.singleMessageSet("hello".toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3()), log.append$default$2()).firstOffset());
                log.delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testMessageSetSizeCheck() {
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("You".getBytes()), new Message("bethe".getBytes())}));
        int configSegmentSize = messageSet.sizeInBytes() - 1;
        Log log = new Log(this.logDir(), this.logConfig().copy(configSegmentSize, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        try {
            log.append(messageSet, log.append$default$2());
            throw this.fail("message set should throw MessageSetSizeTooLargeException.");
        }
        catch (MessageSetSizeTooLargeException messageSetSizeTooLargeException) {
            return;
        }
    }

    @Test
    public void testMessageSizeCheck() {
        int maxMessageSize;
        ByteBufferMessageSet first = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("You".getBytes()), new Message("bethe".getBytes())}));
        ByteBufferMessageSet second = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("change".getBytes())}));
        int x$51 = maxMessageSize = second.sizeInBytes() - 1;
        int x$52 = this.logConfig().copy$default$1();
        long x$53 = this.logConfig().copy$default$2();
        long x$54 = this.logConfig().copy$default$3();
        long x$55 = this.logConfig().copy$default$4();
        long x$56 = this.logConfig().copy$default$5();
        long x$57 = this.logConfig().copy$default$6();
        long x$58 = this.logConfig().copy$default$7();
        int x$59 = this.logConfig().copy$default$9();
        int x$60 = this.logConfig().copy$default$10();
        long x$61 = this.logConfig().copy$default$11();
        long x$62 = this.logConfig().copy$default$12();
        double x$63 = this.logConfig().copy$default$13();
        boolean x$64 = this.logConfig().copy$default$14();
        boolean x$65 = this.logConfig().copy$default$15();
        int x$66 = this.logConfig().copy$default$16();
        Log log = new Log(this.logDir(), this.logConfig().copy(x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$51, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(first, log.append$default$2());
        try {
            log.append(second, log.append$default$2());
            throw this.fail("Second message set should throw MessageSizeTooLargeException.");
        }
        catch (MessageSizeTooLargeException messageSizeTooLargeException) {
            return;
        }
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        int x$67 = segmentSize;
        int x$68 = indexInterval;
        int x$69 = 4096;
        long x$70 = this.logConfig().copy$default$2();
        long x$71 = this.logConfig().copy$default$3();
        long x$72 = this.logConfig().copy$default$4();
        long x$73 = this.logConfig().copy$default$5();
        long x$74 = this.logConfig().copy$default$6();
        long x$75 = this.logConfig().copy$default$7();
        int x$76 = this.logConfig().copy$default$8();
        long x$77 = this.logConfig().copy$default$11();
        long x$78 = this.logConfig().copy$default$12();
        double x$79 = this.logConfig().copy$default$13();
        boolean x$80 = this.logConfig().copy$default$14();
        boolean x$81 = this.logConfig().copy$default$15();
        int x$82 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$67, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$69, x$68, x$77, x$78, x$79, x$80, x$81, x$82);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, messageSize, log){
            public static final long serialVersionUID = 0L;
            private final int messageSize$1;
            private final ObjectRef log$8;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$1 = (Log)this.log$8.elem;
                ByteBufferMessageSet x$83 = TestUtils$.MODULE$.singleMessageSet(TestUtils$.MODULE$.randomBytes(this.messageSize$1), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                boolean x$84 = qual$1.append$default$2();
                return qual$1.append(x$83, x$84);
            }
            {
                this.messageSize$1 = messageSize$1;
                this.log$8 = log$8;
            }
        });
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        long lastIndexOffset = ((Log)log.elem).activeSegment().index().lastOffset();
        int numIndexEntries = ((Log)log.elem).activeSegment().index().entries();
        long lastOffset = ((Log)log.elem).logEndOffset();
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, lastOffset, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened w/o recovery")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        Assert.assertEquals((String)"Should have same last index offset as before.", (long)lastIndexOffset, (long)((Log)log.elem).activeSegment().index().lastOffset());
        Assert.assertEquals((String)"Should have same number of index entries as before.", (int)numIndexEntries, (int)((Log)log.elem).activeSegment().index().entries());
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened with recovery")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        Assert.assertEquals((String)"Should have same last index offset as before.", (long)lastIndexOffset, (long)((Log)log.elem).activeSegment().index().lastOffset());
        Assert.assertEquals((String)"Should have same number of index entries as before.", (int)numIndexEntries, (int)((Log)log.elem).activeSegment().index().entries());
        ((Log)log.elem).close();
    }

    @Test
    public void testIndexRebuild() {
        int numMessages = 200;
        int x$85 = 200;
        int x$86 = 1;
        long x$87 = this.logConfig().copy$default$2();
        long x$88 = this.logConfig().copy$default$3();
        long x$89 = this.logConfig().copy$default$4();
        long x$90 = this.logConfig().copy$default$5();
        long x$91 = this.logConfig().copy$default$6();
        long x$92 = this.logConfig().copy$default$7();
        int x$93 = this.logConfig().copy$default$8();
        int x$94 = this.logConfig().copy$default$9();
        long x$95 = this.logConfig().copy$default$11();
        long x$96 = this.logConfig().copy$default$12();
        double x$97 = this.logConfig().copy$default$13();
        boolean x$98 = this.logConfig().copy$default$14();
        boolean x$99 = this.logConfig().copy$default$15();
        int x$100 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$85, x$87, x$88, x$89, x$90, x$91, x$92, x$93, x$94, x$86, x$95, x$96, x$97, x$98, x$99, x$100);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$9;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$2 = (Log)this.log$9.elem;
                ByteBufferMessageSet x$101 = TestUtils$.MODULE$.singleMessageSet(TestUtils$.MODULE$.randomBytes(10), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
                boolean x$102 = qual$2.append$default$2();
                return qual$2.append(x$101, x$102);
            }
            {
                this.log$9 = log$9;
            }
        });
        Iterable indexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$5) {
                return x$5.index().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ((Log)log.elem).close();
        indexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$6) {
                return x$6.delete();
            }
        });
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final ObjectRef log$9;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((long)i, (long)((MessageAndOffset)((Log)this.log$9.elem).read((long)i, 100, (Option)None$.MODULE$).messageSet().head()).offset());
            }
            {
                this.log$9 = log$9;
            }
        });
        ((Log)log.elem).close();
    }

    @Test
    public void testTruncateTo() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * setSize;
        Log log = new Log(this.logDir(), this.logConfig().copy(segmentSize, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$10;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$10.append(this.set$3, this.log$10.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$10 = log$10;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segments.", (int)1, (int)log.numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be equal to number of messages", (long)msgPerSeg, (long)log.logEndOffset());
        long lastOffset = log.logEndOffset();
        long size = log.size();
        log.truncateTo(log.logEndOffset());
        Assert.assertEquals((String)"Should not change offset", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size, (long)log.size());
        log.truncateTo(log.logEndOffset() + 1L);
        Assert.assertEquals((String)"Should not change offset but should log error", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size, (long)log.size());
        log.truncateTo((long)(msgPerSeg / 2));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(msgPerSeg / 2));
        Assert.assertTrue((String)"Should change log size", (log.size() < size ? 1 : 0) != 0);
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)0L, (long)log.size());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$10;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$10.append(this.set$3, this.log$10.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$10 = log$10;
            }
        });
        Assert.assertEquals((String)"Should be back to original offset", (long)log.logEndOffset(), (long)lastOffset);
        Assert.assertEquals((String)"Should be back to original size", (long)log.size(), (long)size);
        log.truncateFullyAndStartAt(log.logEndOffset() - (long)(msgPerSeg - 1));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(lastOffset - (long)(msgPerSeg - 1)));
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$10;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$10.append(this.set$3, this.log$10.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$10 = log$10;
            }
        });
        Assert.assertTrue((String)"Should be ahead of to original offset", (log.logEndOffset() > (long)msgPerSeg ? 1 : 0) != 0);
        Assert.assertEquals((String)"log size should be same as before", (long)size, (long)log.size());
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
    }

    @Test
    public void testIndexResizingAtTruncation() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * setSize;
        LogConfig config = this.logConfig().copy(segmentSize, this.logConfig().copy$default$2(), this.logConfig().copy$default$3(), this.logConfig().copy$default$4(), this.logConfig().copy$default$5(), this.logConfig().copy$default$6(), this.logConfig().copy$default$7(), this.logConfig().copy$default$8(), this.logConfig().copy$default$9(), this.logConfig().copy$default$10(), this.logConfig().copy$default$11(), this.logConfig().copy$default$12(), this.logConfig().copy$default$13(), this.logConfig().copy$default$14(), this.logConfig().copy$default$15(), this.logConfig().copy$default$16());
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$11;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$4, this.log$11.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$11;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$4, this.log$11.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segment.", (int)2, (int)log.numberOfSegments());
        Assert.assertEquals((String)"The index of the first segment should be trimmed to empty", (int)0, (int)((LogSegment)log.logSegments().toList().apply(0)).index().maxEntries());
        log.truncateTo(0L);
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
        Assert.assertEquals((String)"The index of segment 1 should be resized to maxIndexSize", (int)(log.config().maxIndexSize() / 8), (int)((LogSegment)log.logSegments().toList().apply(0)).index().maxEntries());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$11;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$11.append(this.set$4, this.log$11.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$11 = log$11;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (int)1, (int)log.numberOfSegments());
    }

    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        File bogusIndex1 = Log$.MODULE$.indexFilename(this.logDir(), 0L);
        File bogusIndex2 = Log$.MODULE$.indexFilename(this.logDir(), 5L);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int x$103 = set.sizeInBytes() * 5;
        int x$104 = 1000;
        int x$105 = 1;
        long x$106 = this.logConfig().copy$default$2();
        long x$107 = this.logConfig().copy$default$3();
        long x$108 = this.logConfig().copy$default$4();
        long x$109 = this.logConfig().copy$default$5();
        long x$110 = this.logConfig().copy$default$6();
        long x$111 = this.logConfig().copy$default$7();
        int x$112 = this.logConfig().copy$default$8();
        long x$113 = this.logConfig().copy$default$11();
        long x$114 = this.logConfig().copy$default$12();
        double x$115 = this.logConfig().copy$default$13();
        boolean x$116 = this.logConfig().copy$default$14();
        boolean x$117 = this.logConfig().copy$default$15();
        int x$118 = this.logConfig().copy$default$16();
        Log log = new Log(this.logDir(), this.logConfig().copy(x$103, x$106, x$107, x$108, x$109, x$110, x$111, x$112, x$104, x$105, x$113, x$114, x$115, x$116, x$117, x$118), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertTrue((String)"The first index file should have been replaced with a larger file", (bogusIndex1.length() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((String)"The second index file should have been deleted.", (boolean)bogusIndex2.exists());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$5;
            private final Log log$12;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$12.append(this.set$5, this.log$12.append$default$2());
            }
            {
                this.set$5 = set$5;
                this.log$12 = log$12;
            }
        });
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int x$119 = set.sizeInBytes() * 5;
        int x$120 = 1000;
        int x$121 = 10000;
        long x$122 = this.logConfig().copy$default$2();
        long x$123 = this.logConfig().copy$default$3();
        long x$124 = this.logConfig().copy$default$4();
        long x$125 = this.logConfig().copy$default$5();
        long x$126 = this.logConfig().copy$default$6();
        long x$127 = this.logConfig().copy$default$7();
        int x$128 = this.logConfig().copy$default$8();
        long x$129 = this.logConfig().copy$default$11();
        long x$130 = this.logConfig().copy$default$12();
        double x$131 = this.logConfig().copy$default$13();
        boolean x$132 = this.logConfig().copy$default$14();
        boolean x$133 = this.logConfig().copy$default$15();
        int x$134 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$119, x$122, x$123, x$124, x$125, x$126, x$127, x$128, x$120, x$121, x$129, x$130, x$131, x$132, x$133, x$134);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$6;
            private final ObjectRef log$13;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$3 = (Log)this.log$13.elem;
                ByteBufferMessageSet x$135 = this.set$6;
                boolean x$136 = qual$3.append$default$2();
                return qual$3.append(x$135, x$136);
            }
            {
                this.set$6 = set$6;
                this.log$13 = log$13;
            }
        });
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        ((Log)log.elem).truncateTo(3L);
        Assert.assertEquals((String)"All but one segment should be deleted.", (int)1, (int)((Log)log.elem).numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be 3.", (long)3L, (long)((Log)log.elem).logEndOffset());
    }

    @Test
    public void testAsyncDelete() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int asyncDeleteMs = 1000;
        int x$137 = set.sizeInBytes() * 5;
        long x$138 = asyncDeleteMs;
        int x$139 = 1000;
        int x$140 = 10000;
        long x$141 = this.logConfig().copy$default$2();
        long x$142 = this.logConfig().copy$default$3();
        long x$143 = this.logConfig().copy$default$4();
        long x$144 = this.logConfig().copy$default$5();
        long x$145 = this.logConfig().copy$default$6();
        long x$146 = this.logConfig().copy$default$7();
        int x$147 = this.logConfig().copy$default$8();
        long x$148 = this.logConfig().copy$default$12();
        double x$149 = this.logConfig().copy$default$13();
        boolean x$150 = this.logConfig().copy$default$14();
        boolean x$151 = this.logConfig().copy$default$15();
        int x$152 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$137, x$141, x$142, x$143, x$144, x$145, x$146, x$147, x$139, x$140, x$138, x$148, x$149, x$150, x$151, x$152);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$7;
            private final Log log$14;

            public final Log.LogAppendInfo apply(int i) {
                return this.log$14.append(this.set$7, this.log$14.append$default$2());
            }
            {
                this.set$7 = set$7;
                this.log$14 = log$14;
            }
        });
        LogSegment[] segments = (LogSegment[])log.logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        File[] oldFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$7) {
                return x$7.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$8) {
                return x$8.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        log.deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment s) {
                return true;
            }
        });
        Assert.assertEquals((String)"Only one segment should remain.", (int)1, (int)log.numberOfSegments());
        Assert.assertTrue((String)"All log and index files should end in .deleted", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$9) {
                return x$9.log().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$10) {
                return x$10.index().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The .deleted files should still be there.", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$11) {
                return x$11.log().file().exists();
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$12) {
                return x$12.index().file().exists();
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The original file should be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])oldFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$13) {
                return !x$13.exists();
            }
        }));
        File[] deletedFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$14) {
                return x$14.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$15) {
                return x$15.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        this.time().sleep(asyncDeleteMs + 1);
        Assert.assertTrue((String)"Files should all be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])deletedFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$16) {
                return !x$16.exists();
            }
        }));
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        int x$153 = set.sizeInBytes() * 5;
        int x$154 = 1000;
        long x$155 = this.logConfig().copy$default$2();
        long x$156 = this.logConfig().copy$default$3();
        long x$157 = this.logConfig().copy$default$4();
        long x$158 = this.logConfig().copy$default$5();
        long x$159 = this.logConfig().copy$default$6();
        long x$160 = this.logConfig().copy$default$7();
        int x$161 = this.logConfig().copy$default$8();
        int x$162 = this.logConfig().copy$default$10();
        long x$163 = this.logConfig().copy$default$11();
        long x$164 = this.logConfig().copy$default$12();
        double x$165 = this.logConfig().copy$default$13();
        boolean x$166 = this.logConfig().copy$default$14();
        boolean x$167 = this.logConfig().copy$default$15();
        int x$168 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$153, x$155, x$156, x$157, x$158, x$159, x$160, x$161, x$154, x$162, x$163, x$164, x$165, x$166, x$167, x$168);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$8;
            private final ObjectRef log$15;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$4 = (Log)this.log$15.elem;
                ByteBufferMessageSet x$169 = this.set$8;
                boolean x$170 = qual$4.append$default$2();
                return qual$4.append(x$169, x$170);
            }
            {
                this.set$8 = set$8;
                this.log$15 = log$15;
            }
        });
        ((Log)log.elem).deleteOldSegments((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment s) {
                return true;
            }
        });
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"The deleted segments should be gone.", (int)1, (int)((Log)log.elem).numberOfSegments());
    }

    @Test
    public void testAppendMessageWithNullPayload() {
        Log log = new Log(this.logDir(), new LogConfig(LogConfig$.MODULE$.apply$default$1(), LogConfig$.MODULE$.apply$default$2(), LogConfig$.MODULE$.apply$default$3(), LogConfig$.MODULE$.apply$default$4(), LogConfig$.MODULE$.apply$default$5(), LogConfig$.MODULE$.apply$default$6(), LogConfig$.MODULE$.apply$default$7(), LogConfig$.MODULE$.apply$default$8(), LogConfig$.MODULE$.apply$default$9(), LogConfig$.MODULE$.apply$default$10(), LogConfig$.MODULE$.apply$default$11(), LogConfig$.MODULE$.apply$default$12(), LogConfig$.MODULE$.apply$default$13(), LogConfig$.MODULE$.apply$default$14(), LogConfig$.MODULE$.apply$default$15(), LogConfig$.MODULE$.apply$default$16()), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(null)})), log.append$default$2());
        MessageSet messageSet = log.read(0L, 4096, (Option)None$.MODULE$).messageSet();
        Assert.assertEquals((long)0L, (long)((MessageAndOffset)messageSet.head()).offset());
        Assert.assertTrue((String)"Message payload should be null.", (boolean)((MessageAndOffset)messageSet.head()).message().isNull());
    }

    @Test
    public void testCorruptLog() {
        int x$171 = 1;
        int x$172 = 65536;
        int x$173 = 1000;
        long x$174 = this.logConfig().copy$default$2();
        long x$175 = this.logConfig().copy$default$3();
        long x$176 = this.logConfig().copy$default$4();
        long x$177 = this.logConfig().copy$default$5();
        long x$178 = this.logConfig().copy$default$6();
        long x$179 = this.logConfig().copy$default$7();
        int x$180 = this.logConfig().copy$default$9();
        long x$181 = this.logConfig().copy$default$11();
        long x$182 = this.logConfig().copy$default$12();
        double x$183 = this.logConfig().copy$default$13();
        boolean x$184 = this.logConfig().copy$default$14();
        boolean x$185 = this.logConfig().copy$default$15();
        int x$186 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$173, x$174, x$175, x$176, x$177, x$178, x$179, x$172, x$180, x$171, x$181, x$182, x$183, x$184, x$185, x$186);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, config, set, recoveryPoint){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final LogConfig config$1;
            public final ByteBufferMessageSet set$9;
            private final long recoveryPoint$1;

            public final void apply(int iteration) {
                this.apply$mcVI$sp(iteration);
            }

            public void apply$mcVI$sp(int iteration) {
                this.$outer.logDir().mkdirs();
                ObjectRef log = ObjectRef.create((Object)new Log(this.$outer.logDir(), this.config$1, 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time()));
                int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCorruptLog$1 $outer;
                    private final ObjectRef log$16;

                    public final Log.LogAppendInfo apply(int i) {
                        Log qual$5 = (Log)this.log$16.elem;
                        ByteBufferMessageSet x$187 = this.$outer.set$9;
                        boolean x$188 = qual$5.append$default$2();
                        return qual$5.append(x$187, x$188);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.log$16 = log$16;
                    }
                });
                Iterable messages2 = (Iterable)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$17) {
                        return x$17.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                ((Log)log.elem).close();
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().index().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                log.elem = new Log(this.$outer.logDir(), this.config$1, this.recoveryPoint$1, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                Assert.assertEquals((long)numMessages, (long)((Log)log.elem).logEndOffset());
                Assert.assertEquals((String)"Messages in the log after recovery should be the same.", (Object)messages2, (Object)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$18) {
                        return x$18.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
                Utils$.MODULE$.rm(this.$outer.logDir());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.set$9 = set$9;
                this.recoveryPoint$1 = recoveryPoint$1;
            }
        });
    }

    @Test
    public void testCleanShutdownFile() {
        int x$189 = 1;
        int x$190 = 65536;
        int x$191 = 1000;
        long x$192 = this.logConfig().copy$default$2();
        long x$193 = this.logConfig().copy$default$3();
        long x$194 = this.logConfig().copy$default$4();
        long x$195 = this.logConfig().copy$default$5();
        long x$196 = this.logConfig().copy$default$6();
        long x$197 = this.logConfig().copy$default$7();
        int x$198 = this.logConfig().copy$default$9();
        long x$199 = this.logConfig().copy$default$11();
        long x$200 = this.logConfig().copy$default$12();
        double x$201 = this.logConfig().copy$default$13();
        boolean x$202 = this.logConfig().copy$default$14();
        boolean x$203 = this.logConfig().copy$default$15();
        int x$204 = this.logConfig().copy$default$16();
        LogConfig config = this.logConfig().copy(x$191, x$192, x$193, x$194, x$195, x$196, x$197, x$190, x$198, x$189, x$199, x$200, x$201, x$202, x$203, x$204);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3());
        File parentLogDir = this.logDir().getParentFile();
        Assert.assertTrue((String)"Data directory %s must exist", (boolean)parentLogDir.isDirectory());
        File cleanShutdownFile = new File(parentLogDir, Log$.MODULE$.CleanShutdownFile());
        cleanShutdownFile.createNewFile();
        Assert.assertTrue((String)".kafka_cleanshutdown must exist", (boolean)cleanShutdownFile.exists());
        long recoveryPoint = 0L;
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$10;
            private final ObjectRef log$17;

            public final Log.LogAppendInfo apply(int i) {
                Log qual$6 = (Log)this.log$17.elem;
                ByteBufferMessageSet x$205 = this.set$10;
                boolean x$206 = qual$6.append$default$2();
                return qual$6.append(x$205, x$206);
            }
            {
                this.set$10 = set$10;
                this.log$17 = log$17;
            }
        });
        ((Log)log.elem).close();
        recoveryPoint = ((Log)log.elem).logEndOffset();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((long)recoveryPoint, (long)((Log)log.elem).logEndOffset());
        cleanShutdownFile.delete();
    }

    private final ByteBufferMessageSet read$1(int offset, Log log$6) {
        return ByteBufferMessageSet$.MODULE$.decompress(((MessageAndOffset)log$6.read((long)offset, 4096, log$6.read$default$3()).messageSet().head()).message());
    }
}

