/*
 * Decompiled with CFR 0.152.
 */
package kafka.log4j;

import java.io.File;
import java.util.Properties;
import junit.framework.Assert;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import kafka.producer.async.MissingConfigException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u0001\u001d\u0011acS1gW\u0006dun\u001a\u001bk\u0003B\u0004XM\u001c3feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ\u0001\\8hi)T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0005\r\u0011\u0005%\u0001R\"\u0001\u0006\u000b\u0005-a\u0011!\u00026v]&$(BA\u0007\u000f\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0010\u0003\ry'oZ\u0005\u0003#)\u00111BS+oSR\u001c4+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\tIB$D\u0001\u001b\u0015\tYB!A\u0003vi&d7/\u0003\u0002\u001e5\t9Aj\\4hS:<\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0003\u0011\u001d!\u0003\u00011A\u0005\u0002\u0015\n\u0001\u0002\\8h\t&\u0014(l[\u000b\u0002MA\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0003S>T\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\t!a)\u001b7f\u0011\u001dy\u0003\u00011A\u0005\u0002A\nA\u0002\\8h\t&\u0014(l[0%KF$\"!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\tUs\u0017\u000e\u001e\u0005\bq9\n\t\u00111\u0001'\u0003\rAH%\r\u0005\u0007u\u0001\u0001\u000b\u0015\u0002\u0014\u0002\u00131|w\rR5s5.\u0004\u0003b\u0002\u001f\u0001\u0001\u0004%\t!P\u0001\u0007G>tg-[4\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0003\u0002\rM,'O^3s\u0013\t\u0019\u0005IA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bB#\u0001\u0001\u0004%\tAR\u0001\u000bG>tg-[4`I\u0015\fHCA\u0019H\u0011\u001dAD)!AA\u0002yBa!\u0013\u0001!B\u0013q\u0014aB2p]\u001aLw\r\t\u0005\b\u0003\u0002\u0001\r\u0011\"\u0001L+\u0005a\u0005CA N\u0013\tq\u0005IA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bb\u0002)\u0001\u0001\u0004%\t!U\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHCA\u0019S\u0011\u001dAt*!AA\u00021Ca\u0001\u0016\u0001!B\u0013a\u0015aB:feZ,'\u000f\t\u0005\b-\u0002\u0001\r\u0011\"\u0001X\u0003A\u0019\u0018.\u001c9mK\u000e{gn];nKJT6.F\u0001Y!\tIF,D\u0001[\u0015\tYF!\u0001\u0005d_:\u001cX/\\3s\u0013\ti&L\u0001\bTS6\u0004H.Z\"p]N,X.\u001a:\t\u000f}\u0003\u0001\u0019!C\u0001A\u0006!2/[7qY\u0016\u001cuN\\:v[\u0016\u0014(l[0%KF$\"!M1\t\u000far\u0016\u0011!a\u00011\"11\r\u0001Q!\na\u000b\u0011c]5na2,7i\u001c8tk6,'OW6!\u0011\u001d)\u0007A1A\u0005\u0002\u0019\fq\u0001\u001e'pO\u001e,'/F\u0001h!\tAG.D\u0001j\u0015\t\u0019!N\u0003\u0002l\u001d\u00051\u0011\r]1dQ\u0016L!!\\5\u0003\r1{wmZ3s\u0011\u0019y\u0007\u0001)A\u0005O\u0006AA\u000fT8hO\u0016\u0014\b\u0005C\u0004r\u0001\t\u0007I\u0011\u0002:\u0002\u0011\t\u0014xn[3s5.,\u0012a\u001d\t\u0003eQL!!^\u001a\u0003\u0007%sG\u000f\u0003\u0004x\u0001\u0001\u0006Ia]\u0001\nEJ|7.\u001a:[W\u0002Bq!\u001f\u0001C\u0002\u0013%!0A\u0003q_J$8/F\u0001|!\u0011a\u0018\u0011B:\u000f\u0007u\f)AD\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u00031\u0011A\u0002\u001fs_>$h(C\u00015\u0013\r\t9aM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY!!\u0004\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u000f\u0019\u0004bBA\t\u0001\u0001\u0006Ia_\u0001\u0007a>\u0014Ho\u001d\u0011\t\u0011\u0005U\u0001A1A\u0005\nI\fa\u0001]8sij[\u0007bBA\r\u0001\u0001\u0006Ia]\u0001\ba>\u0014HOW6!\u0011\u001d\ti\u0002\u0001C!\u0003?\tQa]3u+B$\u0012!\r\u0015\u0005\u00037\t\u0019\u0003\u0005\u0003\u0002&\u0005%RBAA\u0014\u0015\tYa\"\u0003\u0003\u0002,\u0005\u001d\"A\u0002\"fM>\u0014X\rC\u0004\u00020\u0001!\t%a\b\u0002\u0011Q,\u0017M\u001d#po:DC!!\f\u00024A!\u0011QEA\u001b\u0013\u0011\t9$a\n\u0003\u000b\u00053G/\u001a:\t\u000f\u0005m\u0002\u0001\"\u0001\u0002 \u0005)B/Z:u\u0017\u000647.\u0019'pORR7i\u001c8gS\u001e\u001c\b\u0006BA\u001d\u0003\u007f\u0001B!!\n\u0002B%!\u00111IA\u0014\u0005\u0011!Vm\u001d;\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002 \u0005\u0001B/Z:u\u0019><GG[!qa\u0016tGm\u001d\u0015\u0005\u0003\u000b\ny\u0004C\u0004\u0002N\u0001!I!a\u0014\u0002\u001d\u001d,G\u000fT8hi)\u001cuN\u001c4jOV\u0011\u0011\u0011\u000b\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b\u0016\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\n)F\u0001\u0006Qe>\u0004XM\u001d;jKN\u0004")
public class KafkaLog4jAppenderTest
extends JUnit3Suite
implements ZooKeeperTestHarness,
Logging {
    private File logDirZk;
    private KafkaConfig config;
    private KafkaServer server;
    private SimpleConsumer simpleConsumerZk;
    private final Logger tLogger;
    private final int brokerZk;
    private final List<Object> ports;
    private final int portZk;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaLog4jAppenderTest kafkaLog4jAppenderTest = this;
        synchronized (kafkaLog4jAppenderTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public /* synthetic */ void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public File logDirZk() {
        return this.logDirZk;
    }

    public void logDirZk_$eq(File x$1) {
        this.logDirZk = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public KafkaServer server() {
        return this.server;
    }

    public void server_$eq(KafkaServer x$1) {
        this.server = x$1;
    }

    public SimpleConsumer simpleConsumerZk() {
        return this.simpleConsumerZk;
    }

    public void simpleConsumerZk_$eq(SimpleConsumer x$1) {
        this.simpleConsumerZk = x$1;
    }

    public Logger tLogger() {
        return this.tLogger;
    }

    private int brokerZk() {
        return this.brokerZk;
    }

    private List<Object> ports() {
        return this.ports;
    }

    private int portZk() {
        return this.portZk;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        Properties propsZk = TestUtils$.MODULE$.createBrokerConfig(this.brokerZk(), this.portZk(), TestUtils$.MODULE$.createBrokerConfig$default$3());
        String logDirZkPath = propsZk.getProperty("log.dir");
        this.logDirZk_$eq(new File(logDirZkPath));
        this.config_$eq(new KafkaConfig(propsZk));
        this.server_$eq(TestUtils$.MODULE$.createServer(this.config(), TestUtils$.MODULE$.createServer$default$2()));
        this.simpleConsumerZk_$eq(new SimpleConsumer("localhost", this.portZk(), 1000000, 65536, ""));
    }

    @Override
    @After
    public void tearDown() {
        this.simpleConsumerZk().close();
        this.server().shutdown();
        Utils$.MODULE$.rm(this.logDirZk());
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testKafkaLog4jConfigs() {
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO");
        props.put("log4j.appender.KAFKA", "kafka.producer.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        try {
            PropertyConfigurator.configure((Properties)props);
            throw this.fail("Missing properties exception was expected !");
        }
        catch (MissingConfigException missingConfigException) {
            props = new Properties();
            props.put("log4j.rootLogger", "INFO");
            props.put("log4j.appender.KAFKA", "kafka.producer.KafkaLog4jAppender");
            props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
            props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
            props.put("log4j.appender.KAFKA.brokerList", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config()})))));
            props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
            try {
                PropertyConfigurator.configure((Properties)props);
                throw this.fail("Missing properties exception was expected !");
            }
            catch (MissingConfigException missingConfigException2) {
                return;
            }
        }
    }

    @Test
    public void testLog4jAppends() {
        PropertyConfigurator.configure((Properties)this.getLog4jConfig());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaLog4jAppenderTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "test";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        FetchResponse response = this.simpleConsumerZk().fetch(new FetchRequestBuilder().addFetch("test-topic", 0, 0L, 0x100000).build());
        ByteBufferMessageSet fetchMessage = response.messageSet("test-topic", 0);
        IntRef count = IntRef.create((int)0);
        fetchMessage.foreach((Function1)new Serializable(this, count){
            public static final long serialVersionUID = 0L;
            private final IntRef count$1;

            public final void apply(MessageAndOffset message) {
                ++this.count$1.elem;
            }
            {
                this.count$1 = count$1;
            }
        });
        Assert.assertEquals((int)5, (int)count.elem);
    }

    /*
     * WARNING - void declaration
     */
    private Properties getLog4jConfig() {
        void var1_1;
        Properties props = new Properties();
        props.put("log4j.rootLogger", "INFO");
        props.put("log4j.appender.KAFKA", "kafka.producer.KafkaLog4jAppender");
        props.put("log4j.appender.KAFKA.layout", "org.apache.log4j.PatternLayout");
        props.put("log4j.appender.KAFKA.layout.ConversionPattern", "%-5p: %c - %m%n");
        props.put("log4j.appender.KAFKA.BrokerList", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{this.config()})))));
        props.put("log4j.appender.KAFKA.Topic", "test-topic");
        props.put("log4j.appender.KAFKA.RequiredNumAcks", "1");
        props.put("log4j.appender.KAFKA.SyncSend", "true");
        props.put("log4j.logger.kafka.log4j", "INFO, KAFKA");
        return var1_1;
    }

    public KafkaLog4jAppenderTest() {
        ZooKeeperTestHarness$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.logDirZk = null;
        this.config = null;
        this.server = null;
        this.simpleConsumerZk = null;
        this.tLogger = Logger.getLogger(this.getClass());
        this.brokerZk = 0;
        this.ports = TestUtils$.MODULE$.choosePorts(2);
        this.portZk = BoxesRunTime.unboxToInt((Object)this.ports().apply(0));
    }
}

