/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.util.HashMap;
import junit.framework.Assert;
import kafka.message.CompressionCodec;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.LZ4CompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageTest$;
import kafka.message.MessageTest$$anonfun$setUp$1$;
import kafka.message.MessageTestVal;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0001\u0002\u0001\u000f\tYQ*Z:tC\u001e,G+Z:u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001\u0001\u0019!C\u00013\u0005AQ.Z:tC\u001e,7/F\u0001\u001b!\rY\"\u0005J\u0007\u00029)\u0011QDH\u0001\b[V$\u0018M\u00197f\u0015\ty\u0002%\u0001\u0006d_2dWm\u0019;j_:T\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003Gq\u00111\"\u0011:sCf\u0014UO\u001a4feB\u0011a#J\u0005\u0003M\t\u0011a\"T3tg\u0006<W\rV3tiZ\u000bG\u000eC\u0004)\u0001\u0001\u0007I\u0011A\u0015\u0002\u00195,7o]1hKN|F%Z9\u0015\u0005)r\u0003CA\u0016-\u001b\u0005\u0001\u0013BA\u0017!\u0005\u0011)f.\u001b;\t\u000f=:\u0013\u0011!a\u00015\u0005\u0019\u0001\u0010J\u0019\t\rE\u0002\u0001\u0015)\u0003\u001b\u0003%iWm]:bO\u0016\u001c\b\u0005C\u00034\u0001\u0011\u0005A'A\u0003tKR,\u0006\u000fF\u0001+Q\t\u0011d\u0007\u0005\u00028s5\t\u0001H\u0003\u0002\f\u001d%\u0011!\b\u000f\u0002\u0007\u0005\u00164wN]3\t\u000bq\u0002A\u0011A\u001f\u0002\u001fQ,7\u000f\u001e$jK2$g+\u00197vKN,\u0012A\u000b\u0015\u0003w}\u0002\"a\u000e!\n\u0005\u0005C$\u0001\u0002+fgRDQa\u0011\u0001\u0005\u0002Q\nA\u0002^3ti\u000eCWmY6tk6D#AQ \t\u000b\u0019\u0003A\u0011\u0001\u001b\u0002\u0019Q,7\u000f^#rk\u0006d\u0017\u000e^=)\u0005\u0015{\u0004\"B%\u0001\t\u0003!\u0014A\u0004;fgRL5\u000fS1tQ\u0006\u0014G.\u001a\u0015\u0003\u0011~\u0002")
public class MessageTest
extends JUnitSuite {
    private ArrayBuffer<MessageTestVal> messages = new ArrayBuffer();

    public ArrayBuffer<MessageTestVal> messages() {
        return this.messages;
    }

    public void messages_$eq(ArrayBuffer<MessageTestVal> x$1) {
        this.messages = x$1;
    }

    @Before
    public void setUp() {
        byte[][] keys = (byte[][])((Object[])new byte[][]{null, "key".getBytes(), "".getBytes()});
        byte[][] vals = (byte[][])((Object[])new byte[][]{"value".getBytes(), "".getBytes(), null});
        Product[] codecs = (Product[])((Object[])new Product[]{NoCompressionCodec$.MODULE$, GZIPCompressionCodec$.MODULE$, SnappyCompressionCodec$.MODULE$, LZ4CompressionCodec$.MODULE$});
        Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new Serializable(this, vals, codecs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageTest $outer;
            private final byte[][] vals$1;
            public final Product[] codecs$1;

            public final void apply(byte[] k) {
                Predef$.MODULE$.refArrayOps((Object[])this.vals$1).foreach((Function1)new Serializable(this, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$setUp$1 $outer;
                    public final byte[] k$1;

                    public final void apply(byte[] v) {
                        Predef$.MODULE$.refArrayOps((Object[])this.$outer.codecs$1).foreach((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$setUp$1$$anonfun$apply$1 $outer;
                            private final byte[] v$1;

                            public final ArrayBuffer<MessageTestVal> apply(Product codec) {
                                return this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$$outer().messages().$plus$eq((Object)new MessageTestVal(this.$outer.k$1, this.v$1, (CompressionCodec)codec, new Message(this.v$1, this.$outer.k$1, (CompressionCodec)codec)));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.v$1 = v$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$setUp$1 kafka$message$MessageTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.k$1 = k$1;
                    }
                });
            }

            public /* synthetic */ MessageTest kafka$message$MessageTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.vals$1 = vals$1;
                this.codecs$1 = codecs$1;
            }
        });
    }

    @Test
    public void testFieldValues() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                if (v.payload() == null) {
                    Assert.assertTrue((boolean)v.message().isNull());
                    Assert.assertEquals((String)"Payload should be null", null, (Object)v.message().payload());
                } else {
                    TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.payload()), v.message().payload());
                }
                Assert.assertEquals((byte)Message$.MODULE$.CurrentMagicValue(), (byte)v.message().magic());
                if (v.message().hasKey()) {
                    TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.key()), v.message().key());
                } else {
                    Assert.assertEquals(null, (Object)v.message().key());
                }
                Assert.assertEquals((Object)v.codec(), (Object)v.message().compressionCodec());
            }
        });
    }

    @Test
    public void testChecksum() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                Assert.assertTrue((String)"Auto-computed checksum should be valid", (boolean)v.message().isValid());
                int badChecksum = (int)(v.message().checksum() + 1L);
                Utils$.MODULE$.writeUnsignedInt(v.message().buffer(), Message$.MODULE$.CrcOffset(), (long)badChecksum);
                Assert.assertFalse((String)"Message with invalid checksum should be invalid", (boolean)v.message().isValid());
            }
        });
    }

    @Test
    public void testEquality() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                Assert.assertFalse((String)"Should not equal null", (boolean)v.message().equals(null));
                Assert.assertFalse((String)"Should not equal a random string", (boolean)v.message().equals((Object)"asdf"));
                Assert.assertTrue((String)"Should equal itself", (boolean)v.message().equals((Object)v.message()));
                Message copy = new Message(v.payload(), v.key(), v.codec());
                Assert.assertTrue((String)"Should equal another message with the same content.", (boolean)v.message().equals((Object)copy));
            }
        });
    }

    @Test
    public void testIsHashable() {
        HashMap m = new HashMap();
        this.messages().foreach((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final HashMap m$1;

            public final Message apply(MessageTestVal v) {
                return this.m$1.put(v.message(), v.message());
            }
            {
                this.m$1 = m$1;
            }
        });
        this.messages().foreach((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final HashMap m$1;

            public final void apply(MessageTestVal v) {
                Assert.assertEquals((Object)v.message(), this.m$1.get(v.message()));
            }
            {
                this.m$1 = m$1;
            }
        });
    }
}

