/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.KafkaException;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u000f\tIQ\u000b^5mgR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u001e;jYNT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001C\u0002\u0013%\u0011$\u0001\u0004m_\u001e<WM]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006Y><GG\u001b\u0006\u0003?9\ta!\u00199bG\",\u0017BA\u0011\u001d\u0005\u0019aunZ4fe\"11\u0005\u0001Q\u0001\ni\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0003&\u0001\u0011\u0005a%A\u0006uKN$8k^1mY><H#A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\tUs\u0017\u000e\u001e\u0015\u0003I9\u0002\"aL\u0019\u000e\u0003AR!a\u0003\b\n\u0005I\u0002$\u0001\u0002+fgRDQ\u0001\u000e\u0001\u0005\u0002\u0019\nA\u0003^3ti\u000eK'oY;mCJLE/\u001a:bi>\u0014\bFA\u001a/\u0011\u00159\u0004\u0001\"\u0001'\u00035!Xm\u001d;SK\u0006$')\u001f;fg\"\u0012aG\f\u0005\u0006u\u0001!\tAJ\u0001\bi\u0016\u001cH/\u00112tQ\tId\u0006C\u0003>\u0001\u0011\u0005a%A\tuKN$(+\u001a9mC\u000e,7+\u001e4gSbD#\u0001\u0010\u0018\t\u000b\u0001\u0003A\u0011\u0001\u0014\u0002\u0017Q,7\u000f\u001e*fC\u0012Le\u000e\u001e\u0015\u0003\u007f9BQa\u0011\u0001\u0005\u0002\u0019\n1\u0002^3ti\u000e\u001bh\u000fT5ti\"\u0012!I\f\u0005\u0006\r\u0002!\tAJ\u0001\u000bi\u0016\u001cH/\u00138M_\u000e\\\u0007FA#/\u0001")
public class UtilsTest
extends JUnitSuite {
    private final Logger kafka$utils$UtilsTest$$logger = Logger.getLogger(UtilsTest.class);

    public Logger kafka$utils$UtilsTest$$logger() {
        return this.kafka$utils$UtilsTest$$logger;
    }

    @Test
    public void testSwallow() {
        Utils$.MODULE$.swallow((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UtilsTest $outer;

            public final void apply(Object x$1, Throwable x$2) {
                this.$outer.kafka$utils$UtilsTest$$logger().info(x$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new KafkaException("test");
            }
        });
    }

    @Test
    public void testCircularIterator() {
        List l = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = Utils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)itl.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)itl.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)itl.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)itl.next());
        Assert.assertFalse((boolean)itl.hasDefiniteSize());
        Set s = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator its = Utils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)its.next());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)its.next());
    }

    @Test
    public void testReadBytes() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "a", "abcd"})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String testCase) {
                byte[] bytes = testCase.getBytes();
                Assert.assertTrue((boolean)Arrays.equals(bytes, Utils$.MODULE$.readBytes(ByteBuffer.wrap(bytes))));
            }
        });
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.abs(Integer.MIN_VALUE)));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.abs(-1)));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.abs(0)));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.abs(1)));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), (Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.abs(Integer.MAX_VALUE)));
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)Utils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)Utils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)Utils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)Utils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * Predef$.MODULE$.intArrayOps(values).size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)new Serializable(this, values, buffer){
            public static final long serialVersionUID = 0L;
            private final int[] values$1;
            private final ByteBuffer buffer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.buffer$1.putInt(i * 4, this.values$1[i]);
                Assert.assertEquals((String)"Written value should match read value.", (Object)BoxesRunTime.boxToInteger((int)this.values$1[i]), (Object)BoxesRunTime.boxToInteger((int)Utils$.MODULE$.readInt(this.buffer$1.array(), i * 4)));
            }
            {
                this.values$1 = values$1;
                this.buffer$1 = buffer$1;
            }
        });
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        String nullString = null;
        Seq emptyList = Utils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = Utils$.MODULE$.parseCsvList(nullString);
        Seq emptyStringList = (Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)Utils$.MODULE$.inLock((Lock)lock, (Function0)new Serializable(this, lock){
            public static final long serialVersionUID = 0L;
            private final ReentrantLock lock$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                Assert.assertTrue((String)"Should be in lock", (boolean)this.lock$1.isHeldByCurrentThread());
                return 2;
            }
            {
                this.lock$1 = lock$1;
            }
        }));
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)result));
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }
}

