/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminClient;
import kafka.admin.AdminClient$;
import kafka.admin.DeleteRecordsCommand;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeleteRecordsCommand$ {
    public static DeleteRecordsCommand$ MODULE$;

    static {
        new DeleteRecordsCommand$();
    }

    public void main(String[] args) {
        this.execute(args, System.out);
    }

    public Seq<Tuple2<TopicPartition, Object>> parseOffsetJsonStringWithoutDedup(String jsonData) {
        Seq seq;
        Option<Object> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            Seq seq2;
            Some some = (Some)option;
            Object m = some.value();
            Option option2 = ((Map)m).get((Object)"partitions");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Object partitionsSeq = some2.value();
                seq2 = (Seq)((Seq)partitionsSeq).map((Function1 & Serializable & scala.Serializable)p -> {
                    String topic = (String)p.get((Object)"topic").get();
                    int partition = BoxesRunTime.unboxToInt((Object)p.get((Object)"partition").get());
                    long offset = BoxesRunTime.unboxToInt((Object)p.get((Object)"offset").get());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToLong((long)offset));
                }, Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option2)) {
                seq2 = (Seq)Seq$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option2);
            }
            seq = seq2;
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public void execute(String[] args, PrintStream out) {
        DeleteRecordsCommand.DeleteRecordsCommandOptions opts = new DeleteRecordsCommand.DeleteRecordsCommandOptions(args);
        AdminClient adminClient = this.createAdminClient(opts);
        String offsetJsonFile = (String)opts.options().valueOf(opts.offsetJsonFileOpt());
        String offsetJsonString = Utils.readFileAsString((String)offsetJsonFile);
        Seq<Tuple2<TopicPartition, Object>> offsetSeq = this.parseOffsetJsonStringWithoutDedup(offsetJsonString);
        Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates((Traversable)offsetSeq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicatePartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Offset json file contains duplicate topic partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
        }
        out.println("Executing records delete operation");
        Map<TopicPartition, AdminClient.DeleteRecordsResult> deleteRecordsResult = adminClient.deleteRecordsBefore((Map<TopicPartition, Object>)offsetSeq.toMap(Predef$.MODULE$.$conforms())).get();
        out.println("Records delete operation completed:");
        deleteRecordsResult.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DeleteRecordsCommand$.$anonfun$execute$2(out, x0$2);
            return BoxedUnit.UNIT;
        });
        adminClient.close();
    }

    private AdminClient createAdminClient(DeleteRecordsCommand.DeleteRecordsCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient$.MODULE$.create(props);
    }

    public static final /* synthetic */ void $anonfun$execute$2(PrintStream out$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            AdminClient.DeleteRecordsResult partitionResult = (AdminClient.DeleteRecordsResult)tuple2._2();
            if (partitionResult.error() == null) {
                out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\tlow_watermark: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, BoxesRunTime.boxToLong((long)partitionResult.lowWatermark())})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                out$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition: ", "\\terror: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, partitionResult.error().toString()})));
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private DeleteRecordsCommand$() {
        MODULE$ = this;
    }
}

