/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tuu!B\u0001\u0003\u0011\u0003I\u0011A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005\r!\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0002\u0004\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u0014\u0005-q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0003\u0016\u0017\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013!)\u0001d\u0003C\u00013\u0005)\u0011\r\u001d9msRy!Da\u0013\u0003\\\t\u0015$q\rB9\u0005\u007f\u0012I\t\u0005\u0002\u000b7\u0019!AB\u0001\u0001\u001d'\rYb\"\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\"AAe\u0007B\u0001B\u0003%Q%\u0001\u0005ce>\\WM]%e!\tya%\u0003\u0002(!\t\u0019\u0011J\u001c;\t\u0011%Z\"\u0011!Q\u0001\n)\n\u0011b]2iK\u0012,H.\u001a:\u0011\u0005yY\u0013B\u0001\u0017 \u0005%\u00196\r[3ek2,'\u000f\u0003\u0005/7\t\u0005\t\u0015!\u00030\u0003E\u0001(o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d\t\u0003\u0015AJ!!\r\u0002\u0003#A\u0013x\u000eZ;dKJLE-T1oC\u001e,'\u000f\u0003\u000547\t\u0005\t\u0015!\u00035\u0003)!\bP\\'b]\u0006<WM\u001d\t\u0003\u0015UJ!A\u000e\u0002\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\b\u0002\u0003\u001d\u001c\u0005\u0003\u0005\u000b\u0011B\u001d\u0002/QDh.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\bC\u0001\u0006;\u0013\tY$AA\u0010Ue\u0006t7/Y2uS>tW*\u0019:lKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJD\u0001\"P\u000e\u0003\u0002\u0003\u0006IAP\u0001\u0005i&lW\r\u0005\u0002@\u00116\t\u0001I\u0003\u0002!\u0003*\u0011!iQ\u0001\u0007G>lWn\u001c8\u000b\u0005\u001d!%BA#G\u0003\u0019\t\u0007/Y2iK*\tq)A\u0002pe\u001eL!!\u0013!\u0003\tQKW.\u001a\u0005\u0006+m!\ta\u0013\u000b\b51kej\u0014)R\u0011\u0015!#\n1\u0001&\u0011\u0015I#\n1\u0001+\u0011\u0015q#\n1\u00010\u0011\u0015\u0019$\n1\u00015\u0011\u0015A$\n1\u0001:\u0011\u0015i$\n1\u0001?\u000b\u0011\u00196\u0004\u0001+\u0003-%s\u0017\u000e\u001e)s_\u0012,8-\u001a:JI\u000e\u000bG\u000e\u001c2bG.\u0004BaD+X5&\u0011a\u000b\u0005\u0002\n\rVt7\r^5p]F\u0002\"A\u0003-\n\u0005e\u0013!\u0001F%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*fgVdG\u000f\u0005\u0002\u00107&\u0011A\f\u0005\u0002\u0005+:LG/\u0002\u0003_7\u0001y&!F!eIB\u000b'\u000f^5uS>t7oQ1mY\n\f7m\u001b\t\u0005\u001fU\u0003'\f\u0005\u0002bI6\t!M\u0003\u0002d\u0003\u0006A\u0001O]8u_\u000e|G.\u0003\u0002fE\n1QI\u001d:peN,AaZ\u000e\u0001?\nqQI\u001c3Uq:\u001c\u0015\r\u001c7cC\u000e\\W\u0001B5\u001c\u0001)\u0014\u0011\"\u00119j%\u0016\u001cX\u000f\u001c;\u0016\u0005-L\b\u0003\u00027uA^t!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005AD\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\t\u0019\b#A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(AB#ji\",'O\u0003\u0002t!A\u0011\u00010\u001f\u0007\u0001\t\u0015Q\bN1\u0001|\u0005\u0005!\u0016C\u0001?\u0000!\tyQ0\u0003\u0002\u007f!\t9aj\u001c;iS:<\u0007cA\b\u0002\u0002%\u0019\u00111\u0001\t\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\bm\u0011\r\u0011\"\u0003\u0002\n\u0005A\u0011n]!di&4X-\u0006\u0002\u0002\fA!\u0011QBA\u0010\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AB1u_6L7M\u0003\u0003\u0002\u0016\u0005]\u0011AC2p]\u000e,(O]3oi*!\u0011\u0011DA\u000e\u0003\u0011)H/\u001b7\u000b\u0005\u0005u\u0011\u0001\u00026bm\u0006LA!!\t\u0002\u0010\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:D\u0001\"!\n\u001cA\u0003%\u00111B\u0001\nSN\f5\r^5wK\u0002Bq!!\u000b\u001c\t\u0003\tY#\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\b5\u00065\u0012\u0011IA#\u0011!\ty#a\nA\u0002\u0005E\u0012a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u0011\t\u0005M\u00121\b\b\u0005\u0003k\t9\u0004\u0005\u0002o!%\u0019\u0011\u0011\b\t\u0002\rA\u0013X\rZ3g\u0013\u0011\ti$a\u0010\u0003\rM#(/\u001b8h\u0015\r\tI\u0004\u0005\u0005\b\u0003\u0007\n9\u00031\u0001&\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\"A\u0011qIA\u0014\u0001\u0004\tI%\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB\u0019\u00111\n*\u000e\u0003mAq!a\u0014\u001c\t\u0013\t\t&A\u000eqe\u0016\u0004\u0018M]3J]&$\bK]8ek\u000e,\u0017\n\u001a+sC:\u001c\u0018\u000e\u001e\u000b\u000b\u0003'\n\t'a\u0019\u0002f\u0005%\u0004#BA&Q\u0006U\u0003CB\b\u0002X\u0015\nY&C\u0002\u0002ZA\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001\u0006\u0002^%\u0019\u0011q\f\u0002\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\u0005\t\u0003_\ti\u00051\u0001\u00022!9\u00111IA'\u0001\u0004)\u0003bBA4\u0003\u001b\u0002\r!J\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"D\u0001\"a\u001b\u0002N\u0001\u0007\u0011QN\u0001\fibtW*\u001a;bI\u0006$\u0018\rE\u0002\u000b\u0003_J1!!\u001d\u0003\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011\u001d\t)h\u0007C\u0001\u0003o\n\u0001\u0005[1oI2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]RY!,!\u001f\u0002|\u0005\u0015\u0015qRAT\u0011!\ty#a\u001dA\u0002\u0005E\u0002\u0002CA?\u0003g\u0002\r!a \u0002\u0015A\u0014x\u000eZ;dKJLE\rE\u0002\u0010\u0003\u0003K1!a!\u0011\u0005\u0011auN\\4\t\u0011\u0005\u001d\u00151\u000fa\u0001\u0003\u0013\u000bQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007cA\b\u0002\f&\u0019\u0011Q\u0012\t\u0003\u000bMCwN\u001d;\t\u0011\u0005E\u00151\u000fa\u0001\u0003'\u000b!\u0002]1si&$\u0018n\u001c8t!\u0019\t)*a'\u0002 6\u0011\u0011q\u0013\u0006\u0004\u00033\u0003\u0012AC2pY2,7\r^5p]&!\u0011QTAL\u0005\r\u0019V\r\u001e\t\u0005\u0003C\u000b\u0019+D\u0001B\u0013\r\t)+\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\t9%a\u001dA\u0002\u0005%\u0006cAA&;\"9\u0011QV\u000e\u0005\u0002\u0005=\u0016\u0001\u00065b]\u0012dW\r\u0016=o\u00136l\u0017n\u001a:bi&|g\u000eF\u0003[\u0003c\u000b)\fC\u0004\u00024\u0006-\u0006\u0019A\u0013\u0002'QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00133\t\u000f\u0005\u001d\u00141\u0016a\u0001K!9\u0011\u0011X\u000e\u0005\u0002\u0005m\u0016a\u00055b]\u0012dW\r\u0016=o\u000b6LwM]1uS>tG#\u0002.\u0002>\u0006}\u0006bBAZ\u0003o\u0003\r!\n\u0005\b\u0003O\n9\f1\u0001&\u0011\u001d\t\u0019m\u0007C\u0005\u0003\u000b\fq\u0005\\8h\u0013:4\u0018\r\\5e'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u0006sGMU3ukJtWI\u001d:peRA\u0011qYAi\u0003'\fi\u000e\u0005\u0004\u0002J\u00065\u0007\r`\u0007\u0003\u0003\u0017T1!!\u0007\u0011\u0013\u0011\ty-a3\u0003\t1+g\r\u001e\u0005\t\u0003_\t\t\r1\u0001\u00022!A\u0011Q[Aa\u0001\u0004\t9.\u0001\tue\u0006t7/Y2uS>t7\u000b^1uKB\u0019!\"!7\n\u0007\u0005m'A\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\"A\u0011q\\Aa\u0001\u0004\t\t/A\tue\u0006t7/Y2uS>t'+Z:vYR\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003O\f\u0015\u0001\u0003:fcV,7\u000f^:\n\t\u0005-\u0018Q\u001d\u0002\u0012)J\fgn]1di&|gNU3tk2$\bbBAx7\u0011\u0005\u0011\u0011_\u0001\u0015Q\u0006tG\r\\3F]\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0017i\u000b\u00190!>\u0002x\u0006e\u0018Q \u0005\t\u0003_\ti\u000f1\u0001\u00022!A\u0011QPAw\u0001\u0004\ty\b\u0003\u0005\u0002\b\u00065\b\u0019AAE\u0011!\tY0!<A\u0002\u0005\u0005\u0018a\u0004;y]6\u000b'o[3s%\u0016\u001cX\u000f\u001c;\t\u0011\u0005\u001d\u0013Q\u001ea\u0001\u0003\u007f\u00042!a\u0013g\u0011\u001d\u0011\u0019a\u0007C\u0001\u0005\u000b\tq\u0003\u001e:b]N\f7\r^5p]R{\u0007/[2D_:4\u0017nZ:\u0016\u0005\t\u001d\u0001\u0003\u0002B\u0005\u0005\u0017i!!a\u0006\n\t\t5\u0011q\u0003\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B\t7\u0011\u0005!1C\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004K\tU\u0001\u0002CA\u0018\u0005\u001f\u0001\r!!\r\t\u000f\te1\u0004\"\u0003\u0003\u001c\u0005I\u0012MY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\u0005Q\u0006b\u0002B\u00107\u0011\u0005!\u0011E\u0001\bgR\f'\u000f^;q)\rQ&1\u0005\u0005\u000b\u0005K\u0011i\u0002%AA\u0002\t\u001d\u0012aH3oC\ndW\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]B\u0019qB!\u000b\n\u0007\t-\u0002CA\u0004C_>dW-\u00198\t\u000f\t=2\u0004\"\u0001\u0003\u001c\u0005A1\u000f[;uI><h\u000eC\u0005\u00034m\t\n\u0011\"\u0001\u00036\u0005\t2\u000f^1siV\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t]\"\u0006\u0002B\u0014\u0005sY#Aa\u000f\u0011\t\tu\"qI\u0007\u0003\u0005\u007fQAA!\u0011\u0003D\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u000b\u0002\u0012AC1o]>$\u0018\r^5p]&!!\u0011\nB \u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b\u0005\u001b:\u0002\u0019\u0001B(\u0003\u0019\u0019wN\u001c4jOB!!\u0011\u000bB,\u001b\t\u0011\u0019FC\u0002\u0003V\u0019\taa]3sm\u0016\u0014\u0018\u0002\u0002B-\u0005'\u00121bS1gW\u0006\u001cuN\u001c4jO\"9!QL\fA\u0002\t}\u0013A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0005#\u0012\t'\u0003\u0003\u0003d\tM#A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\u0006S]\u0001\rA\u000b\u0005\b\u0005S:\u0002\u0019\u0001B6\u0003\u001dQ8.\u0016;jYN\u00042A\bB7\u0013\r\u0011yg\b\u0002\b5.,F/\u001b7t\u0011\u001d\u0011\u0019h\u0006a\u0001\u0005k\nq!\\3ue&\u001c7\u000f\u0005\u0003\u0003x\tmTB\u0001B=\u0015\r\u0011\u0019(Q\u0005\u0005\u0005{\u0012IHA\u0004NKR\u0014\u0018nY:\t\u000f\t\u0005u\u00031\u0001\u0003\u0004\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004BA!\u0015\u0003\u0006&!!q\u0011B*\u00055iU\r^1eCR\f7)Y2iK\")Qh\u0006a\u0001}!9!QR\u0006\u0005\n\t=\u0015\u0001F5oSR$&/\u00198tC\u000e$\u0018n\u001c8FeJ|'\u000fF\u0002X\u0005#CqAa%\u0003\f\u0002\u0007\u0001-A\u0003feJ|'\u000fC\u0004\u0003\u0018.!IA!'\u0002/%t\u0017\u000e\u001e+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fGcA,\u0003\u001c\"A\u00111\u000eBK\u0001\u0004\tY\u0006")
public class TransactionCoordinator
implements Logging {
    private final Scheduler scheduler;
    private final ProducerIdManager producerIdManager;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, ZkUtils zkUtils, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(kafkaConfig, replicaManager, scheduler, zkUtils, metrics, metadataCache, time);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TransactionCoordinator transactionCoordinator = this;
        synchronized (transactionCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        if (transactionalId == null) {
            long producerId = this.producerIdManager.generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
        } else if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
        } else if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
        } else {
            Right right;
            Tuple2 tuple2;
            Either coordinatorEpochAndMetadata = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Either<Errors, CoordinatorEpochAndTxnMetadata> either;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    long producerId = $this.producerIdManager.generateProducerId();
                    String x$6 = transactionalId;
                    long x$7 = producerId;
                    short x$8 = -1;
                    int x$9 = transactionTimeoutMs;
                    Empty$ x$10 = Empty$.MODULE$;
                    scala.collection.mutable.Set x$11 = Set$.MODULE$.empty();
                    long x$12 = $this.time.milliseconds();
                    long x$13 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
                    TransactionMetadata createdMetadata = new TransactionMetadata(x$6, x$7, x$8, x$9, x$10, (scala.collection.mutable.Set<TopicPartition>)x$11, x$13, x$12);
                    either = $this.txnManager.putTransactionStateIfNotExists(transactionalId, createdMetadata);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
                } else {
                    throw new MatchError((Object)option);
                }
                return either;
            });
            Either result = coordinatorEpochAndMetadata.right().flatMap((Function1 & Serializable & scala.Serializable)existingEpochAndMetadata -> {
                Either<Errors, Tuple2<Object, TxnTransitMetadata>> either;
                TransactionMetadata txnMetadata;
                int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
                TransactionMetadata transactionMetadata = txnMetadata = existingEpochAndMetadata.transactionMetadata();
                synchronized (transactionMetadata) {
                    either = this.prepareInitProduceIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata);
                }
                return either;
            });
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors error2 = (Errors)left.value();
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                BoxedUnit boxedUnit;
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                TransactionState transactionState = newMetadata.txnState();
                Ongoing$ ongoing$ = Ongoing$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null)) {
                    this.handleEndTransaction(transactionalId, newMetadata.producerId(), newMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                        TransactionCoordinator.sendRetriableErrorCallback$1(error, responseCallback);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                        this.sendPidResponseCallback$1(error, transactionalId, responseCallback, newMetadata);
                        return BoxedUnit.UNIT;
                    }, this.txnManager.appendTransactionToLog$default$5());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProduceIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            Left left2;
            TransactionState transactionState = txnMetadata.state();
            boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
            if (bl) {
                left2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
                if (bl2) {
                    TxnTransitMetadata txnTransitMetadata;
                    if (txnMetadata.isProducerEpochExhausted()) {
                        long newProducerId = this.producerIdManager.generateProducerId();
                        txnTransitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds());
                    } else {
                        txnTransitMetadata = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, this.time.milliseconds());
                    }
                    TxnTransitMetadata transitMetadata = txnTransitMetadata;
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (Ongoing$.MODULE$.equals(transactionState)) {
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
                } else {
                    if (Dead$.MODULE$.equals(transactionState)) {
                        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                }
            }
            left = left2;
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s AddPartitions request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Errors.INVALID_REQUEST, transactionalId})));
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either result = this.txnManager.getTransactionState(transactionalId).right().flatMap(arg_0 -> TransactionCoordinator.$anonfun$handleAddPartitionsToTransaction$2(this, producerId, producerEpoch, partitions, arg_0));
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s AddPartitions request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{err, transactionalId})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public void handleTxnImmigration(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTxnEmigration(int txnTopicPartitionId, int coordinatorEpoch) {
        this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch);
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId: ", "'s state is ", ", but received transaction "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, transactionState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"marker result to send: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionResult})));
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either preAppendResult = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Left left;
                Option option = x0$3;
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else if (option instanceof Some) {
                    Left<Errors, Nothing$> left2;
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                    int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                    TransactionMetadata transactionMetadata = txnMetadata;
                    synchronized (transactionMetadata) {
                        Left<Errors, Nothing$> left3;
                        if (txnMetadata.producerId() != producerId) {
                            left3 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                        } else if (txnMetadata.producerEpoch() != producerEpoch) {
                            left3 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                        } else if (txnMetadata.pendingTransitionInProgress()) {
                            left3 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        } else {
                            Left<Errors, Nothing$> left4;
                            TransactionState transactionState = txnMetadata.state();
                            if (Ongoing$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                Product nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                                left4 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                            } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult3 = TransactionResult.COMMIT;
                                left4 = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult4 = TransactionResult.ABORT;
                                left4 = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult5 = TransactionResult.COMMIT;
                                left4 = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult;
                                TransactionResult transactionResult6 = TransactionResult.ABORT;
                                left4 = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else if (Empty$.MODULE$.equals(transactionState)) {
                                left4 = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                            } else {
                                if (Dead$.MODULE$.equals(transactionState)) {
                                    String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            left3 = left4;
                        }
                        left2 = left3;
                    }
                    left = left2;
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
            Either either = preAppendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting append of ", " to transaction log with coordinator and returning ", " error to client for ", "'s EndTransaction request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarkerResult, err, transactionalId})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                    this.sendTxnMarkersCallback$1(error, transactionalId, producerId, producerEpoch, txnMarkerResult, responseCallback, coordinatorEpoch, newMetadata);
                    return BoxedUnit.UNIT;
                }, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void abortTimedOutTransactions() {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            this.handleEndTransaction(txnIdAndPidEpoch.transactionalId(), txnIdAndPidEpoch.producerId(), txnIdAndPidEpoch.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                TransactionCoordinator.$anonfun$abortTimedOutTransactions$2($this, txnIdAndPidEpoch, error);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void startup(boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions(), TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs(), TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        if (enableTransactionalIdExpiration) {
            this.txnManager.enableTransactionalIdExpiration();
        }
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$1() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        } else {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
        }
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, Function1 responseCallback$1, TxnTransitMetadata newMetadata$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized transactionalId ", " with producerId ", " and producer "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$1, BoxesRunTime.boxToLong((long)newMetadata$1.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"epoch ", " on partition "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)newMetadata$1.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__transaction_state", BoxesRunTime.boxToInteger((int)$this.txnManager.partitionFor(transactionalId$1))})));
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning ", " error code to client for ", "'s InitProducerId request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, transactionalId$1})));
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Either $anonfun$handleAddPartitionsToTransaction$2(TransactionCoordinator $this, long producerId$2, short producerEpoch$2, Set partitions$1, Option x0$2) {
        block6: {
            block7: {
                block5: {
                    var7_5 = x0$2;
                    if (!None$.MODULE$.equals(var7_5)) break block5;
                    var6_6 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    break block6;
                }
                if (!(var7_5 instanceof Some)) break block7;
                var8_7 = (Some)var7_5;
                epochAndMetadata = (CoordinatorEpochAndTxnMetadata)var8_7.value();
                coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                var12_11 = txnMetadata = epochAndMetadata.transactionMetadata();
                synchronized (var12_11) {
                    block9: {
                        block11: {
                            block10: {
                                block8: {
                                    if (txnMetadata.producerId() == producerId$2) break block8;
                                    v0 /* !! */  = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    break block9;
                                }
                                if (txnMetadata.producerEpoch() == producerEpoch$2) break block10;
                                v0 /* !! */  = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                                break block9;
                            }
                            if (!txnMetadata.pendingTransitionInProgress()) break block11;
                            v0 /* !! */  = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            break block9;
                        }
                        v1 = txnMetadata.state();
                        var14_12 = PrepareCommit$.MODULE$;
                        if (!(v1 == null ? var14_12 != null : v1.equals(var14_12) == false)) ** GOTO lbl-1000
                        v2 = txnMetadata.state();
                        var15_13 = PrepareAbort$.MODULE$;
                        if (!(v2 != null ? v2.equals(var15_13) == false : var15_13 != null)) lbl-1000:
                        // 2 sources

                        {
                            v0 /* !! */  = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        } else {
                            v3 = txnMetadata.state();
                            var16_14 = Ongoing$.MODULE$;
                            v0 /* !! */  = !(v3 != null ? v3.equals(var16_14) == false : var16_14 != null) && partitions$1.subsetOf(txnMetadata.topicPartitions()) != false ? package$.MODULE$.Left().apply((Object)Errors.NONE) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions$1.toSet(), $this.time.milliseconds())));
                        }
                    }
                    var13_15 = v0 /* !! */ ;
                }
                var6_6 = var13_15;
                break block6;
            }
            throw new MatchError((Object)var7_5);
        }
        return var6_6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$2, long producerId$1, short producerEpoch$1, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, int coordinatorEpoch$1, TxnTransitMetadata newMetadata$2) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$2).right().flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Left left;
                Option option = x0$4;
                if (None$.MODULE$.equals(option)) {
                    String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The coordinator still owns the transaction partition for ", ", but there is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no metadata in the cache; this is not expected"})).s((Seq)Nil$.MODULE$);
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$1) {
                        TransactionMetadata txnMetadata;
                        TransactionMetadata transactionMetadata = txnMetadata = epochAndMetadata.transactionMetadata();
                        synchronized (transactionMetadata) {
                            Left<Errors, Nothing$> left2;
                            if (txnMetadata.producerId() != producerId$1) {
                                left2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            } else if (txnMetadata.producerEpoch() != producerEpoch$1) {
                                left2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                            } else if (txnMetadata.pendingTransitionInProgress()) {
                                left2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            } else {
                                Left<Errors, Nothing$> left3;
                                TransactionState transactionState = txnMetadata.state();
                                boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                if (bl) {
                                    left3 = this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1);
                                } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                    left3 = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult3 = TransactionResult.ABORT;
                                    left3 = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$2, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else {
                                    if (Dead$.MODULE$.equals(transactionState)) {
                                        String errorMsg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found transactionalId ", " with state ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2, txnMetadata.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is illegal as we should never have transitioned to this state."})).s((Seq)Nil$.MODULE$);
                                        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                                        throw new IllegalStateException(errorMsg);
                                    }
                                    throw new MatchError((Object)transactionState);
                                }
                                left2 = left3;
                            }
                            Left<Errors, Nothing$> left4 = left2;
                            // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 19] lbl44 : MonitorExitStatement: MONITOREXIT : var16_12
                            left = left4;
                        }
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The transaction coordinator epoch has changed to ", " after ", " was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndMetadata.coordinatorEpoch()), txnMarkerResult$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"successfully appended to the log for ", " with old epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$1)})));
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError((Object)option);
                }
                Left left5 = left;
                return left5;
            });
            Either either = preSendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting sending of transaction markers after appended ", " to transaction log and returning ", " error to client for ", "'s EndTransaction request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarkerResult$1, err, transactionalId$2})));
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            } else {
                Right right;
                Tuple2 tuple2;
                if (!(either instanceof Right) || (tuple2 = (Tuple2)(right = (Right)either).value()) == null) throw new MatchError((Object)either);
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$2, coordinatorEpoch$1, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting sending of transaction markers and returning ", " error to client for ", "'s EndTransaction request of ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error, transactionalId$2, txnMarkerResult$1})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since appending ", " to transaction log with coordinator epoch ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newMetadata$2, BoxesRunTime.boxToInteger((int)coordinatorEpoch$1)})));
            responseCallback$2.apply((Object)error);
        }
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$1, Errors error) {
        Errors errors = error;
        if (Errors.NONE.equals(errors)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completed rollback ongoing transaction of transactionalId: ", " due to timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId()})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(errors) ? true : (Errors.INVALID_PRODUCER_EPOCH.equals(errors) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(errors));
            if (bl) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling back ongoing transaction of transactionalId: ", " has aborted due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId(), error.exceptionName()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolling back ongoing transaction of transactionalId: ", " failed due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnIdAndPidEpoch$1.transactionalId(), error.exceptionName()})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public TransactionCoordinator(int brokerId, Scheduler scheduler, ProducerIdManager producerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time) {
        this.scheduler = scheduler;
        this.producerIdManager = producerIdManager;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[Transaction Coordinator " + brokerId + "]: ");
        this.isActive = new AtomicBoolean(false);
    }
}

