/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0003\n\u00151aQ\"\u0001\u0002\n\u0005-\u0011!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0003M_:<\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0001!\u0011!Q\u0001\ni\tAAZ5mKB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003S>T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t!a)\u001b7f\u0011%\u0019\u0003A!A!\u0002\u0013aA%\u0001\u0006cCN,wJ\u001a4tKRL!a\t\u0006\t\u0013\u0019\u0002!\u0011!Q\u0001\n\u001dR\u0013\u0001D7bq&sG-\u001a=TSj,\u0007CA\u0007)\u0013\tIcBA\u0002J]RL!A\n\u0006\t\u00131\u0002!\u0011!Q\u0001\n5\u0002\u0014\u0001C<sSR\f'\r\\3\u0011\u00055q\u0013BA\u0018\u000f\u0005\u001d\u0011un\u001c7fC:L!\u0001\f\u0006\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0015!TGN\u001c9!\tI\u0001\u0001C\u0003\u001ac\u0001\u0007!\u0004C\u0003$c\u0001\u0007A\u0002C\u0004'cA\u0005\t\u0019A\u0014\t\u000f1\n\u0004\u0013!a\u0001[!)!\b\u0001C!w\u0005IQM\u001c;ssNK'0Z\u000b\u0002O!)Q\b\u0001C!}\u00051\u0011n\u001d$vY2,\u0012!\f\u0005\u0006\u0001\u0002!I!Q\u0001\ni&lWm\u001d;b[B$2\u0001\u0004\"K\u0011\u0015\u0019u\b1\u0001E\u0003\u0019\u0011WO\u001a4feB\u0011Q\tS\u0007\u0002\r*\u0011qIH\u0001\u0004]&|\u0017BA%G\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006\u0017~\u0002\raJ\u0001\u0002]\")Q\n\u0001C\u0005\u001d\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$HcA\u0014P!\")1\t\u0014a\u0001\t\")1\n\u0014a\u0001O!)!\u000b\u0001C\u0001'\u0006IA.Y:u\u000b:$(/_\u000b\u0002)B\u0011\u0011\"V\u0005\u0003-\n\u0011q\u0002V5nKN$\u0018-\u001c9PM\u001a\u001cX\r\u001e\u0005\u00061\u0002!\t!W\u0001\u0006K:$(/\u001f\u000b\u0003)jCQaS,A\u0002\u001dBQ\u0001\u0018\u0001\u0005Bu\u000b!\u0002]1sg\u0016,e\u000e\u001e:z)\rq\u0016M\u0019\t\u0003\u0013}K!\u0001\u0019\u0002\u0003\u0015%sG-\u001a=F]R\u0014\u0018\u0010C\u0003D7\u0002\u0007A\tC\u0003L7\u0002\u0007q\u0005C\u0003e\u0001\u0011\u0005Q-A\u0006nCf\u0014W-\u00119qK:$G\u0003\u00024jU2\u0004\"!D4\n\u0005!t!\u0001B+oSRDQ\u0001Q2A\u00021AQa[2A\u00021\taa\u001c4gg\u0016$\bbB7d!\u0003\u0005\r!L\u0001\u000eg.L\u0007OR;mY\u000eCWmY6\t\u000b=\u0004A\u0011\u00019\u0002\r1|wn[;q)\t!\u0016\u000fC\u0003s]\u0002\u0007A\"A\buCJ<W\r\u001e+j[\u0016\u001cH/Y7q\u0011\u0015!\b\u0001\"\u0011v\u0003!!(/\u001e8dCR,G#\u00014\t\u000b]\u0004A\u0011\t=\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0002gs\")1N\u001ea\u0001\u0019!)1\u0010\u0001C\u0005y\u0006\tBO];oG\u0006$X\rV8F]R\u0014\u0018.Z:\u0015\u0005\u0019l\b\"\u0002@{\u0001\u00049\u0013aB3oiJLWm\u001d\u0005\u0007\u0003\u0003\u0001A\u0011I;\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u0005\n\u0003\u000b\u0001\u0011\u0013!C\u0001\u0003\u000f\tQ#\\1zE\u0016\f\u0005\u000f]3oI\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\n)\u001aQ&a\u0003,\u0005\u00055\u0001\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0006\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\t\tBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DQ\"a\b\u0001!\u0003\r\t\u0011!C\u0005\u0003C!\u0013\u0001E:va\u0016\u0014HEY1tK>3gm]3u+\u0005aq!CA\u0013\u0005\u0005\u0005\t\u0012AA\u0014\u0003%!\u0016.\\3J]\u0012,\u0007\u0010E\u0002\n\u0003S1\u0001\"\u0001\u0002\u0002\u0002#\u0005\u00111F\n\u0005\u0003S\ti\u0003E\u0002\u000e\u0003_I1!!\r\u000f\u0005\u0019\te.\u001f*fM\"9!'!\u000b\u0005\u0002\u0005UBCAA\u0014\u0011)\tI$!\u000b\u0012\u0002\u0013\u0005\u00111H\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u\"fA\u0014\u0002\f!Q\u0011\u0011IA\u0015#\u0003%\t!a\u0002\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    private final File file;

    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            int n = this._entries();
            switch (n) {
                case 0: {
                    timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
                    break;
                }
                default: {
                    timestampOffset = (TimestampOffset)this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return timestampOffset;
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from a time index of size %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this._entries())})));
            }
            ByteBuffer idx = this.mmap().duplicate();
            return new TimestampOffset(this.timestamp(idx, n), this.relativeOffset(idx, n));
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block3: {
                if (!skipFullCheck) {
                    Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> "Attempt to append to a full time index (size = " + this._entries() + ").");
                }
                if (this._entries() != 0 && offset < this.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to slot %d no larger than the last offset appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().offset()), $this.file.getAbsolutePath()})));
                }
                if (this._entries() != 0 && timestamp < this.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append a timestamp (%d) to slot %d no larger than the last timestamp appended (%d) to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToInteger((int)this._entries()), BoxesRunTime.boxToLong((long)this.lastEntry().timestamp()), $this.file.getAbsolutePath()})));
                }
                if (timestamp <= this.lastEntry().timestamp()) break block3;
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)timestamp), BoxesRunTime.boxToLong((long)offset), $this.file.getName()})));
                this.mmap().putLong(timestamp);
                this.mmap().putInt((int)(offset - this.super$baseOffset()));
                this._entries_$eq(this._entries() + 1);
                Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> this._entries() + " entries but file position in index is " + this.mmap().position() + ".");
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$.MODULE$.KEY());
            if (slot == -1) {
                timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
            } else {
                TimestampOffset entry = (TimestampOffset)this.parseEntry(idx, slot);
                timestampOffset = new TimestampOffset(entry.timestamp(), entry.offset());
            }
            return timestampOffset;
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.VALUE());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            return this.mmap().position(this._entries() * this.entrySize());
        });
    }

    @Override
    public void sanityCheck() {
        TimestampOffset entry = this.lastEntry();
        long lastTimestamp = entry.timestamp();
        long lastOffset = entry.offset();
        Predef$.MODULE$.require(this._entries() == 0 || lastTimestamp >= this.timestamp(this.mmap(), 0), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last timestamp "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the first timestamp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastTimestamp), BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0))})));
        Predef$.MODULE$.require(this._entries() == 0 || lastOffset >= super.baseOffset(), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last offset "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.file.getAbsolutePath()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is smaller than the first offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastOffset), BoxesRunTime.boxToLong((long)this.super$baseOffset())})));
        long len = this.file.length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0 & Serializable & scala.Serializable)() -> "Time index file " + $this.file.getAbsolutePath() + " is corrupt, found " + len + " bytes which is not positive or not a multiple of 12.");
    }

    public TimeIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        this.file = file;
        super(file, baseOffset, maxIndexSize, writable);
    }
}

