/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUh!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007y1\u0013F\u0004\u0002 I9\u0011\u0001eI\u0007\u0002C)\u0011!eG\u0001\u0007yI|w\u000e\u001e \n\u0003)I!!J\u0005\u0002\u000fA\f7m[1hK&\u0011q\u0005\u000b\u0002\u0004'\u0016\f(BA\u0013\n!\tQs&D\u0001,\u0015\taS&\u0001\u0002j_*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u00111\u0015\u000e\\3\t\u0011I\u0002!\u0011!Q\u0001\nu\t\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005!An\\4t+\u00051\u0004\u0003\u0002\b8s\u0011K!\u0001O\b\u0003\tA{w\u000e\u001c\t\u0003u\tk\u0011a\u000f\u0006\u0003yu\naaY8n[>t'BA\u0003?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\r[$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003\u000b\u001ak\u0011AA\u0005\u0003\u000f\n\u00111\u0001T8h\u0011!I\u0005A!A!\u0002\u00131\u0014!\u00027pON\u0004\u0003\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!k\u0014\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\t\u0011Q\u0003!\u0011!Q\u0001\n5\u000bQ\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u0002F\u0001!)!$\u0016a\u0001;!)A'\u0016a\u0001m!)1*\u0016a\u0001\u001b\")Q\f\u0001C)=\u0006QAn\\4hKJt\u0015-\\3\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!AY\u0017\u0002\t1\fgnZ\u0005\u0003I\u0006\u0014aa\u0015;sS:<\u0007\u0002\u00034\u0001\u0005\u0004%\tA\u00010\u0002)=4gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f\u0011\u0019A\u0007\u0001)A\u0005?\u0006)rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u0004\u0003b\u00026\u0001\u0001\u0004%Ia[\u0001\fG\",7m\u001b9pS:$8/F\u0001m!\u0011i'/\u000b;\u000e\u00039T!a\u001c9\u0002\u0013%lW.\u001e;bE2,'BA9\n\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003g:\u00141!T1q!\t)x/D\u0001w\u0015\tQw*\u0003\u0002ym\n!rJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016DqA\u001f\u0001A\u0002\u0013%10A\bdQ\u0016\u001c7\u000e]8j]R\u001cx\fJ3r)\tax\u0010\u0005\u0002\t{&\u0011a0\u0003\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0002e\f\t\u00111\u0001m\u0003\rAH%\r\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003m\u00031\u0019\u0007.Z2la>Lg\u000e^:!Q\u0011\t\u0019!!\u0003\u0011\u0007!\tY!C\u0002\u0002\u000e%\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'\t!\"\u001b8Qe><'/Z:t+\t\t)\u0002E\u0004\u0002\u0018\u0005u\u0011(!\t\u000e\u0005\u0005e!bAA\u000ea\u00069Q.\u001e;bE2,\u0017\u0002BA\u0010\u00033\u0011q\u0001S1tQ6\u000b\u0007\u000fE\u0002F\u0003GI1!!\n\u0003\u0005AaunZ\"mK\u0006t\u0017N\\4Ti\u0006$X\r\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u000b\u0003-Ig\u000e\u0015:pOJ,7o\u001d\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012!F;oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003c\u0001\u0002\"a\u0006\u0002\u001e\u0005M\u0012\u0011\t\t\u0005\u0003k\tiD\u0004\u0003\u00028\u0005e\u0002C\u0001\u0011\n\u0013\r\tY$C\u0001\u0007!J,G-\u001a4\n\u0007\u0011\fyDC\u0002\u0002<%\u0001R!a\u0006\u0002DeJA!!\u0012\u0002\u001a\t\u00191+\u001a;\t\u0011\u0005%\u0003\u0001)A\u0005\u0003c\ta#\u001e8dY\u0016\fg.\u00192mKB\u000b'\u000f^5uS>t7\u000f\t\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u001f\nq\"\u001e8dY\u0016\fg.\u00192mK\u0012K'o]\u000b\u0003\u0003#\u0002b!a\u0006\u0002T\u0005M\u0012\u0002BA+\u00033\u0011q\u0001S1tQN+G\u000f\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA)\u0003A)hn\u00197fC:\f'\r\\3ESJ\u001c\b\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`\u0005!An\\2l+\t\t\t\u0007\u0005\u0003\u0002d\u0005ETBAA3\u0015\u0011\t9'!\u001b\u0002\u000b1|7m[:\u000b\t\u0005-\u0014QN\u0001\u000bG>t7-\u001e:sK:$(bAA8[\u0005!Q\u000f^5m\u0013\u0011\t\u0019(!\u001a\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011!\t9\b\u0001Q\u0001\n\u0005\u0005\u0014!\u00027pG.\u0004\u0003\"CA>\u0001\t\u0007I\u0011BA?\u0003I\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3\u0016\u0005\u0005}\u0004\u0003BA2\u0003\u0003KA!a!\u0002f\tI1i\u001c8eSRLwN\u001c\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002\u0000\u0005\u0019\u0002/Y;tK\u0012\u001cE.Z1oS:<7i\u001c8eA!I\u00111\u0012\u0001A\u0002\u0013%\u0011QR\u0001\u001aI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLw.\u0006\u0002\u0002\u0010B\u0019\u0001\"!%\n\u0007\u0005M\u0015B\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0003/\u0003\u0001\u0019!C\u0005\u00033\u000bQ\u0004Z5si&,7\u000f\u001e'pO\u000ecW-\u00198bE2,'+\u0019;j_~#S-\u001d\u000b\u0004y\u0006m\u0005BCA\u0001\u0003+\u000b\t\u00111\u0001\u0002\u0010\"A\u0011q\u0014\u0001!B\u0013\ty)\u0001\u000eeSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|\u0007\u0005\u000b\u0003\u0002\u001e\u0006%\u0001\"CAS\u0001\u0001\u0007I\u0011BAT\u00035!\u0018.\\3PM2\u000b7\u000f\u001e*v]V\u0011\u0011\u0011\u0016\t\u0004\u0011\u0005-\u0016bAAW\u0013\t!Aj\u001c8h\u0011%\t\t\f\u0001a\u0001\n\u0013\t\u0019,A\tuS6,wJ\u001a'bgR\u0014VO\\0%KF$2\u0001`A[\u0011)\t\t!a,\u0002\u0002\u0003\u0007\u0011\u0011\u0016\u0005\t\u0003s\u0003\u0001\u0015)\u0003\u0002*\u0006qA/[7f\u001f\u001ad\u0015m\u001d;Sk:\u0004\u0003\u0006BA\\\u0003\u0013Aq!a0\u0001\t\u0003\t\t-A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005\r\u0007cBA\u001b\u0003\u000bL\u0014\u0011V\u0005\u0004g\u0006}\u0002\u0002CAe\u0001\u0011\u0005!!a3\u0002\u001b\rdW-\u00198j]\u001e\u001cF/\u0019;f)\u0011\ti-a5\u0011\u000b!\ty-!\t\n\u0007\u0005E\u0017B\u0001\u0004PaRLwN\u001c\u0005\b\u0003+\f9\r1\u0001:\u0003\t!\b\u000f\u0003\u0005\u0002Z\u0002!\tAAAn\u0003A\u0019X\r^\"mK\u0006t\u0017N\\4Ti\u0006$X\rF\u0003}\u0003;\fy\u000eC\u0004\u0002V\u0006]\u0007\u0019A\u001d\t\u0011\u0005\u0005\u0018q\u001ba\u0001\u0003C\tQa\u001d;bi\u0016Dq!!:\u0001\t\u0003\t9/A\rhe\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><G\u0003BAu\u0003c\u0004R\u0001CAh\u0003W\u00042!RAw\u0013\r\tyO\u0001\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0007\u0002CAz\u0003G\u0004\r!!>\u0002\tQLW.\u001a\t\u0005\u0003o\fY0\u0004\u0002\u0002z*\u0011\u0001cO\u0005\u0005\u0003{\fIP\u0001\u0003US6,\u0007b\u0002B\u0001\u0001\u0011\u0005!1A\u0001'a\u0006,8/Z\"mK\u0006t\u0017N\\4G_JtuN\\\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHC\u0001B\u0003!\u0019\u00119A!\u0003\u0003\u000e5\t\u0001/C\u0002\u0003\fA\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0006\u0011\t=\u0011\bR\u0005\u0004\u0005#I!A\u0002+va2,'\u0007C\u0004\u0003\u0016\u0001!\tAa\u0001\u0002\u001b\u0011,G.\u001a;bE2,Gj\\4t\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\tQ\"\u00192peR\u001cE.Z1oS:<Gc\u0001?\u0003\u001e!9!q\u0004B\f\u0001\u0004I\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005G\u0001A\u0011\u0001B\u0013\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$2\u0001 B\u0014\u0011\u001d\u0011yB!\tA\u0002eBqAa\u000b\u0001\t\u0003\u0011i#\u0001\bsKN,X.Z\"mK\u0006t\u0017N\\4\u0015\u0007q\u0014y\u0003\u0003\u0005\u00032\t%\u0002\u0019\u0001B\u001a\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b#\u0002B\u0004\u0005\u0013I\u0004b\u0002B\u001c\u0001\u0011%!\u0011H\u0001\u0012SN\u001cE.Z1oS:<\u0017J\\*uCR,GC\u0002B\u001e\u0005\u0003\u0012\u0019\u0005E\u0002\t\u0005{I1Aa\u0010\n\u0005\u001d\u0011un\u001c7fC:DqAa\b\u00036\u0001\u0007\u0011\b\u0003\u0005\u0003F\tU\u0002\u0019AA\u0011\u00035)\u0007\u0010]3di\u0016$7\u000b^1uK\"9!\u0011\n\u0001\u0005\n\t-\u0013aF5t\u00072,\u0017M\\5oO&s7\u000b^1uKB\u000bWo]3e)\u0011\u0011YD!\u0014\t\u000f\t}!q\ta\u0001s!9!\u0011\u000b\u0001\u0005\u0002\tM\u0013\u0001F2iK\u000e\\7\t\\3b]&tw-\u00112peR,G\rF\u0002}\u0005+BqAa\b\u0003P\u0001\u0007\u0011\bC\u0004\u0003Z\u0001!\tAa\u0017\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000fF\u0003}\u0005;\u0012\t\u0007C\u0004\u0003`\t]\u0003\u0019A\u0015\u0002\u000f\u0011\fG/\u0019#je\"A!1\rB,\u0001\u0004\u0011)'\u0001\u0004va\u0012\fG/\u001a\t\u0006\u0011\u0005='q\r\t\u0007\u0011\t=\u0011(!+\t\u000f\t-\u0004\u0001\"\u0001\u0003n\u0005\u0011\u0012\r\u001c;fe\u000eCWmY6q_&tG\u000fR5s)\u001da(q\u000eB9\u0005kBqAa\b\u0003j\u0001\u0007\u0011\bC\u0004\u0003t\t%\u0004\u0019A\u0015\u0002\u0019M|WO]2f\u0019><G)\u001b:\t\u000f\t]$\u0011\u000ea\u0001S\u0005QA-Z:u\u0019><G)\u001b:\t\u000f\tm\u0004\u0001\"\u0001\u0003~\u0005\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR\u0019APa \t\u0011\t\u0005%\u0011\u0010a\u0001\u0003g\t1\u0001Z5s\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000f\u000bq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u000fq\u0014IIa#\u0003\u000e\"9!q\fBB\u0001\u0004I\u0003b\u0002B\u0010\u0005\u0007\u0003\r!\u000f\u0005\t\u0005\u001f\u0013\u0019\t1\u0001\u0002*\u00061qN\u001a4tKRDqAa%\u0001\t\u0003\u0011)*\u0001\u0007e_:,7\t\\3b]&tw\rF\u0004}\u0005/\u0013IJa'\t\u000f\t}!\u0011\u0013a\u0001s!9!q\fBI\u0001\u0004I\u0003\u0002\u0003BO\u0005#\u0003\r!!+\u0002\u0013\u0015tGm\u00144gg\u0016$\bb\u0002BQ\u0001\u0011\u0005!1U\u0001\rI>tW\rR3mKRLgn\u001a\u000b\u0004y\n\u0015\u0006\u0002\u0003B\u0019\u0005?\u0003\rAa\r\t\u0011\u00055\u0002\u0001\"\u0001\u0003\u0005S#BAa+\u00030B)\u0011Q\u0007BWs%!\u0011QIA \u0011!\u0011\tLa*A\u0002\u0005M\u0012A\u00027pO\u0012K'\u000fC\u0004\u00036\u0002!\tAa.\u000215\f'o\u001b)beRLG/[8o+:\u001cG.Z1oC\ndW\rF\u0003}\u0005s\u0013Y\f\u0003\u0005\u00032\nM\u0006\u0019AA\u001a\u0011\u001d\u0011iLa-A\u0002e\n\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\t\u0005\u0007\u0001\"\u0003\u0003D\u00061\u0012n]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0003<\t\u0015'q\u0019\u0005\u0007\u0007\t}\u0006\u0019\u0001#\t\u000f\t}!q\u0018a\u0001s\u001dA!1\u001a\u0002\t\u0002\t\u0011i-A\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\u00042!\u0012Bh\r\u001d\t!\u0001#\u0001\u0003\u0005#\u001cBAa4\b\u001b!9aKa4\u0005\u0002\tUGC\u0001Bg\u0011!\u0011INa4\u0005\u0002\tm\u0017AE5t\u0007>l\u0007/Y2u\u0003:$G)\u001a7fi\u0016$BAa\u000f\u0003^\"11Aa6A\u0002\u0011C\u0001B!9\u0003P\u0012\u0005!1]\u0001\u0011G2,\u0017M\\1cY\u0016|eMZ:fiN$\"B!:\u0003h\n%(1\u001eBy!\u001dA!qBAU\u0003SCaa\u0001Bp\u0001\u0004!\u0005b\u0002B\u0010\u0005?\u0004\r!\u000f\u0005\t\u0005[\u0014y\u000e1\u0001\u0003p\u0006IA.Y:u\u00072,\u0017M\u001c\t\u0006[JL\u0014\u0011\u0016\u0005\t\u0005g\u0014y\u000e1\u0001\u0002*\u0006\u0019an\\<")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions;
    private final HashSet<String> uncleanableDirs;
    private final ReentrantLock kafka$log$LogCleanerManager$$lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    public HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions() {
        return this.kafka$log$LogCleanerManager$$uncleanablePartitions;
    }

    private HashSet<String> uncleanableDirs() {
        return this.uncleanableDirs;
    }

    public ReentrantLock kafka$log$LogCleanerManager$$lock() {
        return this.kafka$log$LogCleanerManager$$lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return (scala.collection.immutable.Map)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            scala.collection.immutable.Map map;
            try {
                map = checkpoint.read();
            }
            catch (KafkaStorageException e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                map = Predef$.MODULE$.Map().empty();
            }
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        return (Option)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().get((Object)tp));
    }

    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().put((Object)tp, (Object)state));
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicPartition topicPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicPartition = (TopicPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable deletableLogs = (Iterable)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$4)))).filterNot((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3(this, x0$5)));
            deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                Tuple2 tuple2 = x0$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                return option;
            });
            return var1_1;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$7)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                return option;
            });
            return var1_1;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning((Iterable<TopicPartition>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("The cleaning for partition ").append(topicPartition).append(" is aborted").toString());
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), () -> LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The cleaning for partition ").append(topicPartition).append(" is aborted and paused").toString());
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach(arg_0 -> LogCleanerManager.$anonfun$resumeCleaning$2(this, arg_0)));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogCleaningState state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState = state;
            boolean bl2 = logCleaningState instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block2: {
                OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
                if (checkpoint == null) break block2;
                try {
                    Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
                    checkpoint.write((Map<TopicPartition, Object>)existing);
                }
                catch (KafkaStorageException e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
        });
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block5: {
                block4: {
                    try {
                        Option option = this.checkpoints().get((Object)sourceLogDir).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.read().get((Object)topicPartition));
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            long offset = BoxesRunTime.unboxToLong((Object)some.value());
                            this.updateCheckpoints(sourceLogDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
                            this.updateCheckpoints(destLogDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offset))));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        throw new MatchError((Object)option);
                    }
                    catch (KafkaStorageException e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                }
                Set logUncleanablePartitions = (Set)this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)sourceLogDir.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
                if (!logUncleanablePartitions.contains((Object)topicPartition)) break block5;
                logUncleanablePartitions.remove((Object)topicPartition);
                this.markPartitionUncleanable(destLogDir.toString(), topicPartition);
            }
        });
    }

    public void handleLogDirFailure(String dir) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)this.checkpoints().filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir, x$5)))));
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                Map<TopicPartition, Object> existing;
                OffsetCheckpointFile checkpoint;
                if (!this.logs().get(topicPartition).config().compact() || (checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir)) == null || BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get((Object)topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                    return this.inProgress().remove((Object)topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        });
    }

    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
            LogCleaningState logCleaningState;
            boolean bl = false;
            Some some = null;
            Option option = this.inProgress().get(topicPartition);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                    return this.inProgress().remove(topicPartition);
                }
            }
            if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                this.pausedCleaningCond().signalAll();
                return BoxedUnit.UNIT;
            }
            if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
            throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
        }));
    }

    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            partitions$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions$1.elem).$plus$plus((GenTraversableOnce)this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        });
        return (scala.collection.immutable.Set)partitions.elem;
    }

    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Boolean bl;
            Option option = this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)logDir);
            if (option instanceof Some) {
                Some some = (Some)option;
                Set partitions = (Set)some.value();
                bl = BoxesRunTime.boxToBoolean((boolean)partitions.add((Object)partition));
            } else if (None$.MODULE$.equals(option)) {
                bl = this.kafka$log$LogCleanerManager$$uncleanablePartitions().put((Object)logDir, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})));
            } else {
                throw new MatchError((Object)option);
            }
            return bl;
        });
    }

    private boolean isUncleanablePartition(Log log, TopicPartition topicPartition) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)log.dir().getParent()).exists((Function1 & Serializable & scala.Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition)))));
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = !log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.config().compact() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$4) {
        block7: {
            block6: {
                var3_2 = false;
                var4_3 = null;
                var5_4 = $this.inProgress().get((Object)topicPartition$4);
                if (!None$.MODULE$.equals(var5_4)) break block6;
                var2_5 = $this.inProgress().put((Object)topicPartition$4, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var5_4 instanceof Some)) ** GOTO lbl-1000
            var3_2 = true;
            var4_3 = (Some)var5_4;
            var6_6 = (LogCleaningState)var4_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var6_6)) {
                var2_5 = $this.inProgress().put((Object)topicPartition$4, (Object)LogCleaningAborted$.MODULE$);
            } else if (var3_2 && (var7_7 = (LogCleaningState)var4_3.value()) instanceof LogCleaningPaused) {
                var8_8 = (LogCleaningPaused)var7_7;
                count = var8_8.pausedCount();
                var2_5 = $this.inProgress().put((Object)topicPartition$4, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var3_2) {
                    s = (LogCleaningState)var4_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$4).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var5_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$4)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Option $anonfun$resumeCleaning$2(LogCleanerManager $this, TopicPartition topicPartition) {
        var4_2 = $this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(var4_2)) {
            throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
        }
        if (!(var4_2 instanceof Some)) ** GOTO lbl21
        var5_3 = (Some)var4_2;
        state = (LogCleaningState)var5_3.value();
        var7_5 = false;
        var8_6 = null;
        var9_7 = state;
        if (!(var9_7 instanceof LogCleaningPaused)) ** GOTO lbl-1000
        var7_5 = true;
        var8_6 = (LogCleaningPaused)var9_7;
        count = var8_6.pausedCount();
        if (count == 1) {
            var3_9 = $this.inProgress().remove((Object)topicPartition);
        } else if (var7_5 && (count = var8_6.pausedCount()) > 1) {
            var3_9 = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(count - 1));
        } else {
            throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(var9_7).append(" state.").toString());
lbl21:
            // 1 sources

            throw new MatchError((Object)var4_2);
        }
        var2_11 = var3_9;
        return var2_11;
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$1, File x$5) {
        String string = x$5.getAbsolutePath();
        String string2 = dir$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.uncleanableDirs = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$lock = new ReentrantLock();
        this.pausedCleaningCond = this.kafka$log$LogCleanerManager$$lock().newCondition();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public int value() {
                return BoxesRunTime.unboxToInt(CoreUtils$.MODULE$.inLock(this.$outer.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$2.getAbsolutePath()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$2(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))));
            }

            public static final /* synthetic */ int $anonfun$value$2(Set x$1) {
                return x$1.size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleanerManager$$anon$1 ), $anonfun$value$2$adapted(scala.collection.mutable.Set ), $anonfun$value$3()}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$3;

            public long value() {
                return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inLock(this.$outer.kafka$log$LogCleanerManager$$lock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
                    long l;
                    Option option = $this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$3.getAbsolutePath());
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Set partitions = (Set)some.value();
                        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.$outer.allCleanerCheckpoints();
                        long now = Time.SYSTEM.milliseconds();
                        l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5(this, lastClean, now, tp)), Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    } else {
                        l = 0L;
                    }
                    return l;
                }));
            }

            public static final /* synthetic */ long $anonfun$value$5($anon$2 $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
                long uncleanableBytes;
                Log log = $this.$outer.logs().get(tp);
                Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.cleanableOffsets(log, tp, (scala.collection.immutable.Map<TopicPartition, Object>)lastClean$1, now$1);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long firstDirtyOffset = tuple2._1$mcJ$sp();
                long firstUncleanableDirtyOffset = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset2 = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset2 = sp3._2$mcJ$sp();
                Tuple2<Object, Object> tuple22 = LogCleaner$.MODULE$.calculateCleanableBytes(log, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                long l = uncleanableBytes = tuple22._2$mcJ$sp();
                long uncleanableBytes2 = l;
                return uncleanableBytes2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$3 = dir$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(kafka.log.LogCleanerManager$$anon$2 ), $anonfun$value$5$adapted(kafka.log.LogCleanerManager$$anon$2 scala.collection.immutable.Map long org.apache.kafka.common.TopicPartition )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

