/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc;

import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.livy.LivyClient;
import org.apache.livy.LivyClientFactory;
import org.apache.livy.rsc.ContextInfo;
import org.apache.livy.rsc.ContextLauncher;
import org.apache.livy.rsc.DriverProcessInfo;
import org.apache.livy.rsc.RSCClient;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.rpc.RpcServer;

public final class RSCClientFactory
implements LivyClientFactory {
    private final AtomicInteger refCount = new AtomicInteger();
    private RpcServer server = null;

    public LivyClient createClient(URI uri, Properties config) {
        if (!"rsc".equals(uri.getScheme())) {
            return null;
        }
        RSCConf lconf = new RSCConf(config);
        boolean needsServer = false;
        try {
            Promise<ContextInfo> info;
            Process driverProcess = null;
            if (uri.getUserInfo() != null && uri.getHost() != null && uri.getPort() > 0) {
                info = RSCClientFactory.createContextInfo(uri);
            } else {
                needsServer = true;
                this.ref(lconf);
                DriverProcessInfo processInfo = ContextLauncher.create(this, lconf);
                info = processInfo.getContextInfo();
                driverProcess = processInfo.getDriverProcess();
            }
            return new RSCClient(lconf, info, driverProcess);
        }
        catch (Exception e) {
            if (needsServer) {
                this.unref();
            }
            throw Utils.propagate(e);
        }
    }

    RpcServer getServer() {
        return this.server;
    }

    private synchronized void ref(RSCConf config) throws IOException {
        if (this.refCount.get() != 0) {
            this.refCount.incrementAndGet();
            return;
        }
        Utils.checkState(this.server == null, "Server already running but ref count is 0.", new Object[0]);
        if (this.server == null) {
            try {
                this.server = new RpcServer(config);
            }
            catch (InterruptedException ie) {
                throw Utils.propagate(ie);
            }
        }
        this.refCount.incrementAndGet();
    }

    synchronized void unref() {
        if (this.refCount.decrementAndGet() == 0) {
            this.server.close();
            this.server = null;
        }
    }

    private static Promise<ContextInfo> createContextInfo(URI uri) {
        String[] userInfo = uri.getUserInfo().split(":", 2);
        ImmediateEventExecutor executor = ImmediateEventExecutor.INSTANCE;
        Promise promise = executor.newPromise();
        promise.setSuccess((Object)new ContextInfo(uri.getHost(), uri.getPort(), userInfo[0], userInfo[1]));
        return promise;
    }
}

