/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.spatial.util.GeoUtils;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.SloppyMath;

final class LatLonPointDistanceQuery
extends Query {
    final String field;
    final double latitude;
    final double longitude;
    final double radiusMeters;

    public LatLonPointDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude((double)latitude);
        GeoUtils.checkLongitude((double)longitude);
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        GeoRect box2;
        GeoRect box1;
        GeoRect box = GeoUtils.circleToBBox((double)this.latitude, (double)this.longitude, (double)this.radiusMeters);
        if (box.crossesDateline()) {
            box1 = new GeoRect(box.minLat, box.maxLat, -180.0, box.maxLon);
            box2 = new GeoRect(box.minLat, box.maxLat, box.minLon, 180.0);
        } else {
            box1 = box;
            box2 = null;
        }
        return new ConstantScoreWeight(this){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                PointValues values = reader.getPointValues();
                if (values == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(LatLonPointDistanceQuery.this.field);
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.checkCompatible(fieldInfo);
                final DocIdSetBuilder result = new DocIdSetBuilder(reader.maxDoc());
                values.intersect(LatLonPointDistanceQuery.this.field, new PointValues.IntersectVisitor(){

                    public void visit(int docID) {
                        result.add(docID);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        double lon;
                        assert (packedValue.length == 8);
                        double lat = LatLonPoint.decodeLatitude(packedValue, 0);
                        if (SloppyMath.haversinMeters((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)lat, (double)(lon = LatLonPoint.decodeLongitude(packedValue, 4))) <= LatLonPointDistanceQuery.this.radiusMeters) {
                            this.visit(docID);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        double latMin = LatLonPoint.decodeLatitude(minPackedValue, 0);
                        double lonMin = LatLonPoint.decodeLongitude(minPackedValue, 4);
                        double latMax = LatLonPoint.decodeLatitude(maxPackedValue, 0);
                        double lonMax = LatLonPoint.decodeLongitude(maxPackedValue, 4);
                        if ((latMax < box1.minLat || lonMax < box1.minLon || latMin > box1.maxLat || lonMin > box1.maxLon) && (box2 == null || latMax < box2.minLat || lonMax < box2.minLon || latMin > box2.maxLat || lonMin > box2.maxLon)) {
                            return PointValues.Relation.CELL_OUTSIDE_QUERY;
                        }
                        if (lonMax - LatLonPointDistanceQuery.this.longitude < 90.0 && LatLonPointDistanceQuery.this.longitude - lonMin < 90.0 && SloppyMath.haversinMeters((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMin, (double)lonMin) <= LatLonPointDistanceQuery.this.radiusMeters && SloppyMath.haversinMeters((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMin, (double)lonMax) <= LatLonPointDistanceQuery.this.radiusMeters && SloppyMath.haversinMeters((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMax, (double)lonMin) <= LatLonPointDistanceQuery.this.radiusMeters && SloppyMath.haversinMeters((double)LatLonPointDistanceQuery.this.latitude, (double)LatLonPointDistanceQuery.this.longitude, (double)latMax, (double)lonMax) <= LatLonPointDistanceQuery.this.radiusMeters) {
                            return PointValues.Relation.CELL_INSIDE_QUERY;
                        }
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                });
                return new ConstantScoreScorer((Weight)this, this.score(), result.build().iterator());
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radiusMeters);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LatLonPointDistanceQuery other = (LatLonPointDistanceQuery)((Object)obj);
        if (!this.field.equals(other.field)) {
            return false;
        }
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        if (Double.doubleToLongBits(this.longitude) != Double.doubleToLongBits(other.longitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }
}

