/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;

public class DistanceToShapeValueSource
extends ValueSource {
    private final ValueSource shapeValueSource;
    private final Point queryPoint;
    private final double multiplier;
    private final DistanceCalculator distCalc;
    private final double nullValue;

    public DistanceToShapeValueSource(ValueSource shapeValueSource, Point queryPoint, double multiplier, SpatialContext ctx) {
        this.shapeValueSource = shapeValueSource;
        this.queryPoint = queryPoint;
        this.multiplier = multiplier;
        this.distCalc = ctx.getDistCalc();
        this.nullValue = ctx.isGeo() ? 180.0 * multiplier : Double.MAX_VALUE;
    }

    public String description() {
        return "distance(" + this.queryPoint + " to " + this.shapeValueSource.description() + ")*" + this.multiplier + ")";
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.shapeValueSource.createWeight(context, searcher);
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues shapeValues = this.shapeValueSource.getValues(context, readerContext);
        return new DoubleDocValues(this){

            public double doubleVal(int doc) {
                Shape shape = (Shape)shapeValues.objectVal(doc);
                if (shape == null || shape.isEmpty()) {
                    return DistanceToShapeValueSource.this.nullValue;
                }
                Point pt = shape.getCenter();
                return DistanceToShapeValueSource.this.distCalc.distance(DistanceToShapeValueSource.this.queryPoint, pt) * DistanceToShapeValueSource.this.multiplier;
            }

            public Explanation explain(int doc) {
                Explanation exp = super.explain(doc);
                exp.addDetail(shapeValues.explain(doc));
                return exp;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistanceToShapeValueSource that = (DistanceToShapeValueSource)((Object)o);
        if (!this.queryPoint.equals(that.queryPoint)) {
            return false;
        }
        if (Double.compare(that.multiplier, this.multiplier) != 0) {
            return false;
        }
        if (!this.shapeValueSource.equals((Object)that.shapeValueSource)) {
            return false;
        }
        return this.distCalc.equals(that.distCalc);
    }

    public int hashCode() {
        int result = this.shapeValueSource.hashCode();
        result = 31 * result + this.queryPoint.hashCode();
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

