/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class BaseTestRangeFilter
extends LuceneTestCase {
    public static final boolean F = false;
    public static final boolean T = true;
    static IndexReader signedIndexReader;
    static IndexReader unsignedIndexReader;
    static TestIndex signedIndexDir;
    static TestIndex unsignedIndexDir;
    static int minId;
    static int maxId;
    static final int intLength;

    public static String pad(int n) {
        StringBuilder b = new StringBuilder(40);
        String p = "0";
        if (n < 0) {
            p = "-";
            n = Integer.MAX_VALUE + n + 1;
        }
        b.append(p);
        String s = Integer.toString(n);
        for (int i = s.length(); i <= intLength; ++i) {
            b.append("0");
        }
        b.append(s);
        return b.toString();
    }

    @BeforeClass
    public static void beforeClassBaseTestRangeFilter() throws Exception {
        maxId = BaseTestRangeFilter.atLeast(500);
        signedIndexDir = new TestIndex(BaseTestRangeFilter.random(), Integer.MAX_VALUE, Integer.MIN_VALUE, true);
        unsignedIndexDir = new TestIndex(BaseTestRangeFilter.random(), Integer.MAX_VALUE, 0, false);
        signedIndexReader = BaseTestRangeFilter.build(BaseTestRangeFilter.random(), signedIndexDir);
        unsignedIndexReader = BaseTestRangeFilter.build(BaseTestRangeFilter.random(), unsignedIndexDir);
    }

    @AfterClass
    public static void afterClassBaseTestRangeFilter() throws Exception {
        signedIndexReader.close();
        unsignedIndexReader.close();
        BaseTestRangeFilter.signedIndexDir.index.close();
        BaseTestRangeFilter.unsignedIndexDir.index.close();
        signedIndexReader = null;
        unsignedIndexReader = null;
        signedIndexDir = null;
        unsignedIndexDir = null;
    }

    private static IndexReader build(Random random, TestIndex index) throws IOException {
        Document doc = new Document();
        Field idField = BaseTestRangeFilter.newStringField(random, "id", "", Field.Store.YES);
        SortedDocValuesField idDVField = new SortedDocValuesField("id", new BytesRef());
        IntField intIdField = new IntField("id_int", 0, Field.Store.YES);
        NumericDocValuesField intDVField = new NumericDocValuesField("id_int", 0L);
        FloatField floatIdField = new FloatField("id_float", 0.0f, Field.Store.YES);
        NumericDocValuesField floatDVField = new NumericDocValuesField("id_float", 0L);
        LongField longIdField = new LongField("id_long", 0L, Field.Store.YES);
        NumericDocValuesField longDVField = new NumericDocValuesField("id_long", 0L);
        DoubleField doubleIdField = new DoubleField("id_double", 0.0, Field.Store.YES);
        NumericDocValuesField doubleDVField = new NumericDocValuesField("id_double", 0L);
        Field randField = BaseTestRangeFilter.newStringField(random, "rand", "", Field.Store.YES);
        SortedDocValuesField randDVField = new SortedDocValuesField("rand", new BytesRef());
        Field bodyField = BaseTestRangeFilter.newStringField(random, "body", "", Field.Store.NO);
        SortedDocValuesField bodyDVField = new SortedDocValuesField("body", new BytesRef());
        doc.add((IndexableField)idField);
        doc.add((IndexableField)idDVField);
        doc.add((IndexableField)intIdField);
        doc.add((IndexableField)intDVField);
        doc.add((IndexableField)floatIdField);
        doc.add((IndexableField)floatDVField);
        doc.add((IndexableField)longIdField);
        doc.add((IndexableField)longDVField);
        doc.add((IndexableField)doubleIdField);
        doc.add((IndexableField)doubleDVField);
        doc.add((IndexableField)randField);
        doc.add((IndexableField)randDVField);
        doc.add((IndexableField)bodyField);
        doc.add((IndexableField)bodyDVField);
        RandomIndexWriter writer = new RandomIndexWriter(random, index.index, BaseTestRangeFilter.newIndexWriterConfig(random, new MockAnalyzer(random)).setOpenMode(IndexWriterConfig.OpenMode.CREATE).setMaxBufferedDocs(TestUtil.nextInt(random, 50, 1000)).setMergePolicy((MergePolicy)BaseTestRangeFilter.newLogMergePolicy()));
        TestUtil.reduceOpenFiles(writer.w);
        while (true) {
            int minCount = 0;
            int maxCount = 0;
            for (int d = minId; d <= maxId; ++d) {
                int r;
                idField.setStringValue(BaseTestRangeFilter.pad(d));
                idDVField.setBytesValue(new BytesRef((CharSequence)BaseTestRangeFilter.pad(d)));
                intIdField.setIntValue(d);
                intDVField.setLongValue((long)d);
                floatIdField.setFloatValue((float)d);
                floatDVField.setLongValue((long)Float.floatToRawIntBits(d));
                longIdField.setLongValue((long)d);
                longDVField.setLongValue((long)d);
                doubleIdField.setDoubleValue((double)d);
                doubleDVField.setLongValue(Double.doubleToRawLongBits(d));
                int n = r = index.allowNegativeRandomInts ? random.nextInt() : random.nextInt(Integer.MAX_VALUE);
                if (index.maxR < r) {
                    index.maxR = r;
                    maxCount = 1;
                } else if (index.maxR == r) {
                    ++maxCount;
                }
                if (r < index.minR) {
                    index.minR = r;
                    minCount = 1;
                } else if (r == index.minR) {
                    ++minCount;
                }
                randField.setStringValue(BaseTestRangeFilter.pad(r));
                randDVField.setBytesValue(new BytesRef((CharSequence)BaseTestRangeFilter.pad(r)));
                bodyField.setStringValue("body");
                bodyDVField.setBytesValue(new BytesRef((CharSequence)"body"));
                writer.addDocument(doc);
            }
            if (minCount == 1 && maxCount == 1) {
                DirectoryReader ir = writer.getReader();
                writer.close();
                return ir;
            }
            writer.deleteAll();
        }
    }

    @Test
    public void testPad() {
        int[] tests = new int[]{-9999999, -99560, -100, -3, -1, 0, 3, 9, 10, 1000, 999999999};
        for (int i = 0; i < tests.length - 1; ++i) {
            int a = tests[i];
            int b = tests[i + 1];
            String aa = BaseTestRangeFilter.pad(a);
            String bb = BaseTestRangeFilter.pad(b);
            String label = a + ":" + aa + " vs " + b + ":" + bb;
            BaseTestRangeFilter.assertEquals((String)("length of " + label), (long)aa.length(), (long)bb.length());
            BaseTestRangeFilter.assertTrue((String)("compare less than " + label), (aa.compareTo(bb) < 0 ? 1 : 0) != 0);
        }
    }

    static {
        minId = 0;
        intLength = Integer.toString(Integer.MAX_VALUE).length();
    }

    static class TestIndex {
        int maxR;
        int minR;
        boolean allowNegativeRandomInts;
        Directory index;

        TestIndex(Random random, int minR, int maxR, boolean allowNegativeRandomInts) {
            this.minR = minR;
            this.maxR = maxR;
            this.allowNegativeRandomInts = allowNegativeRandomInts;
            this.index = LuceneTestCase.newDirectory(random);
        }
    }
}

