/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.announcement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.announcement.AbstractAnnouncementMojo;
import org.apache.maven.plugin.changes.ChangesXML;
import org.apache.maven.plugin.changes.IssueAdapter;
import org.apache.maven.plugin.changes.ProjectUtils;
import org.apache.maven.plugin.changes.ReleaseUtils;
import org.apache.maven.plugin.github.GitHubDownloader;
import org.apache.maven.plugin.github.GitHubIssueManagementSystem;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.issues.IssueManagementSystem;
import org.apache.maven.plugin.issues.IssueUtils;
import org.apache.maven.plugin.jira.AbstractJiraDownloader;
import org.apache.maven.plugin.jira.AdaptiveJiraDownloader;
import org.apache.maven.plugin.jira.JIRAIssueManagmentSystem;
import org.apache.maven.plugin.trac.TracDownloader;
import org.apache.maven.plugin.trac.TracIssueManagmentSystem;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.model.Release;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;

@Mojo(name="announcement-generate", threadSafe=true)
public class AnnouncementMojo
extends AbstractAnnouncementMojo {
    private static final String CHANGES_XML = "changes.xml";
    private static final String JIRA = "JIRA";
    private static final String TRAC = "Trac";
    private static final String GIT_HUB = "GitHub";
    @Parameter(property="changes.announcementFile")
    private String announcementFile;
    @Parameter
    private Map announceParameters;
    @Parameter(property="project.artifactId", readonly=true)
    private String artifactId;
    @Parameter(property="changes.developmentTeam", defaultValue="${project.name} team", required=true)
    private String developmentTeam;
    @Parameter(property="changes.finalName", defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(property="project.groupId", readonly=true)
    private String groupId;
    @Parameter(defaultValue="${project.description}")
    private String introduction;
    @Parameter
    private List<String> issueManagementSystems;
    @Parameter
    private Map<String, String> issueTypes;
    @Parameter(defaultValue="${project.build.directory}/announcement", required=true)
    private File announcementDirectory;
    @Parameter
    private File outputDirectory;
    @Parameter(property="project.packaging", readonly=true)
    private String packaging;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="changes.template", defaultValue="announcement.vm", required=true)
    private String template;
    @Parameter(property="changes.templateDirectory", defaultValue="org/apache/maven/plugin/announcement", required=true)
    private String templateDirectory;
    @Parameter(property="changes.templateEncoding", defaultValue="${project.build.sourceEncoding}")
    private String templateEncoding;
    @Parameter(property="changes.useJql", defaultValue="false")
    private boolean useJql;
    @Parameter(property="project.url")
    private String url;
    @Parameter
    private String urlDownload;
    @Component(role=VelocityComponent.class, hint="maven-changes-plugin")
    private VelocityComponent velocity;
    @Parameter(property="changes.version", defaultValue="${project.version}", required=true)
    private String version;
    @Parameter(defaultValue="${basedir}/src/changes/changes.xml")
    private File xmlPath;
    @Parameter(defaultValue="")
    private String filter;
    @Parameter(property="generateJiraAnnouncement", defaultValue="false", required=true)
    private boolean generateJiraAnnouncement;
    @Parameter(property="changes.jiraMerge", defaultValue="false")
    private boolean jiraMerge;
    @Parameter(property="changes.jiraPassword", defaultValue="")
    private String jiraPassword;
    @Parameter(property="changes.jiraUser", defaultValue="")
    private String jiraUser;
    @Parameter(defaultValue="${project.build.directory}/jira-announcement.xml", required=true, readonly=true)
    private File jiraXML;
    @Parameter(property="changes.maxEntries", defaultValue="25", required=true)
    private int maxEntries;
    @Parameter(property="changes.resolutionIds", defaultValue="Fixed")
    private String resolutionIds;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="changes.statusIds", defaultValue="Closed")
    private String statusIds;
    @Parameter(property="changes.webUser", defaultValue="")
    private String webUser;
    @Parameter(property="changes.webPassword", defaultValue="")
    private String webPassword;
    @Parameter(property="changes.versionPrefix", defaultValue="")
    private String versionPrefix;
    @Parameter(property="changes.jiraConnectionTimeout", defaultValue="36000")
    private int jiraConnectionTimeout;
    @Parameter(property="changes.jiraReceiveTimout", defaultValue="32000")
    private int jiraReceiveTimout;
    @Parameter(property="changes.tracPassword", defaultValue="")
    private String tracPassword;
    @Parameter(defaultValue="order=id")
    private String tracQuery;
    @Parameter(property="changes.tracUser", defaultValue="")
    private String tracUser;
    @Parameter(defaultValue="http", property="changes.githubAPIScheme")
    private String githubAPIScheme;
    @Parameter(defaultValue="80", property="changes.githubAPIPort")
    private int githubAPIPort;
    @Parameter(defaultValue="github")
    private String githubAPIServerId;
    @Parameter(defaultValue="false")
    private boolean includeOpenIssues;
    private ReleaseUtils releaseUtils = new ReleaseUtils(this.getLog());
    private ChangesXML xml;

    public void execute() throws MojoExecutionException {
        if (this.outputDirectory != null) {
            throw new MojoExecutionException("You are using the old parameter 'outputDirectory'. You must use 'announcementDirectory' instead.");
        }
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the announcement generation in this project because it's not the Execution Root");
        } else {
            if (this.issueManagementSystems == null) {
                this.issueManagementSystems = new ArrayList<String>();
            }
            if (this.issueManagementSystems.isEmpty()) {
                if (this.jiraMerge) {
                    this.issueManagementSystems.add(CHANGES_XML);
                    this.issueManagementSystems.add(JIRA);
                } else if (this.generateJiraAnnouncement) {
                    this.issueManagementSystems.add(JIRA);
                } else {
                    this.issueManagementSystems.add(CHANGES_XML);
                }
            }
            List<Release> releases = null;
            if (this.issueManagementSystems.contains(CHANGES_XML)) {
                if (this.getXmlPath().exists()) {
                    ChangesXML changesXML = new ChangesXML(this.getXmlPath(), this.getLog());
                    List<Release> changesReleases = this.releaseUtils.convertReleaseList(changesXML.getReleaseList());
                    releases = this.releaseUtils.mergeReleases(null, changesReleases);
                    this.getLog().info((CharSequence)("Including issues from file " + this.getXmlPath() + " in announcement..."));
                } else {
                    this.getLog().warn((CharSequence)("changes.xml file " + this.getXmlPath().getAbsolutePath() + " does not exist."));
                }
            }
            if (this.issueManagementSystems.contains(JIRA)) {
                if (ProjectUtils.validateIfIssueManagementComplete(this.project, JIRA, "JIRA announcement", this.getLog())) {
                    List<Release> jiraReleases = this.getJiraReleases();
                    releases = this.releaseUtils.mergeReleases(releases, jiraReleases);
                    this.getLog().info((CharSequence)"Including issues from JIRA in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. See previous error messages.");
                }
            }
            if (this.issueManagementSystems.contains(TRAC)) {
                if (ProjectUtils.validateIfIssueManagementComplete(this.project, TRAC, "Trac announcement", this.getLog())) {
                    List<Release> tracReleases = this.getTracReleases();
                    releases = this.releaseUtils.mergeReleases(releases, tracReleases);
                    this.getLog().info((CharSequence)"Including issues from Trac in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. See previous error messages.");
                }
            }
            if (this.issueManagementSystems.contains(GIT_HUB)) {
                if (ProjectUtils.validateIfIssueManagementComplete(this.project, GIT_HUB, "GitHub announcement", this.getLog())) {
                    List<Release> gitHubReleases = this.getGitHubReleases();
                    releases = this.releaseUtils.mergeReleases(releases, gitHubReleases);
                    this.getLog().info((CharSequence)"Including issues from GitHub in announcement...");
                } else {
                    throw new MojoExecutionException("Something is wrong with the Issue Management section. See previous error messages.");
                }
            }
            if (releases == null || releases.isEmpty()) {
                throw new MojoExecutionException("No releases found in any of the configured issue management systems.");
            }
            this.doGenerate(releases);
        }
    }

    public void doGenerate(List<Release> releases) throws MojoExecutionException {
        String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.getVersion();
        this.getLog().debug((CharSequence)("Generating announcement for version [" + version + "]. Found these releases: " + ReleaseUtils.toString(releases)));
        this.doGenerate(releases, this.releaseUtils.getLatestRelease(releases, version));
    }

    protected void doGenerate(List<Release> releases, Release release) throws MojoExecutionException {
        try {
            ToolManager toolManager = new ToolManager(true);
            ToolContext context = toolManager.createContext();
            if (this.getIntroduction() == null || this.getIntroduction().equals("")) {
                this.setIntroduction(this.getUrl());
            }
            context.put("releases", releases);
            context.put("groupId", (Object)this.getGroupId());
            context.put("artifactId", (Object)this.getArtifactId());
            context.put("version", (Object)this.getVersion());
            context.put("packaging", (Object)this.getPackaging());
            context.put("url", (Object)this.getUrl());
            context.put("release", (Object)release);
            context.put("introduction", (Object)this.getIntroduction());
            context.put("developmentTeam", (Object)this.getDevelopmentTeam());
            context.put("finalName", (Object)this.getFinalName());
            context.put("urlDownload", (Object)this.getUrlDownload());
            context.put("project", (Object)this.project);
            if (this.announceParameters == null) {
                context.put("announceParameters", (Object)Collections.EMPTY_MAP);
            } else {
                context.put("announceParameters", (Object)this.announceParameters);
            }
            this.processTemplate((Context)context, this.announcementDirectory, this.template, this.announcementFile);
        }
        catch (ResourceNotFoundException rnfe) {
            throw new MojoExecutionException("Resource not found.", (Exception)((Object)rnfe));
        }
        catch (VelocityException ve) {
            throw new MojoExecutionException(ve.toString(), (Exception)((Object)ve));
        }
    }

    public void processTemplate(Context context, File outputDirectory, String template, String announcementFile) throws VelocityException, MojoExecutionException {
        if (StringUtils.isEmpty((String)announcementFile)) {
            announcementFile = template;
        }
        try {
            File f = new File(outputDirectory, announcementFile);
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            VelocityEngine engine = this.velocity.getEngine();
            engine.setApplicationAttribute((Object)"baseDirectory", (Object)this.basedir);
            if (StringUtils.isEmpty((String)this.templateEncoding)) {
                this.templateEncoding = ReaderFactory.FILE_ENCODING;
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + this.templateEncoding + ", i.e. build is platform dependent!"));
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.templateEncoding);
            Template velocityTemplate = engine.getTemplate(this.templateDirectory + "/" + template, this.templateEncoding);
            velocityTemplate.merge(context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            this.getLog().info((CharSequence)("Created template " + f));
        }
        catch (ResourceNotFoundException rnfe) {
            throw new ResourceNotFoundException("Template not found. ( " + this.templateDirectory + "/" + template + " )");
        }
        catch (VelocityException ve) {
            throw new VelocityException(ve.toString());
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                this.getLog().warn(e.getCause());
            }
            throw new MojoExecutionException(e.toString(), e.getCause());
        }
    }

    protected List<Release> getJiraReleases() throws MojoExecutionException {
        AdaptiveJiraDownloader jiraDownloader = new AdaptiveJiraDownloader();
        File jiraXMLFile = this.jiraXML;
        jiraDownloader.setLog(this.getLog());
        jiraDownloader.setOutput(jiraXMLFile);
        jiraDownloader.setStatusIds(this.statusIds);
        jiraDownloader.setResolutionIds(this.resolutionIds);
        jiraDownloader.setMavenProject(this.project);
        jiraDownloader.setSettings(this.settings);
        jiraDownloader.setNbEntries(this.maxEntries);
        jiraDownloader.setFilter(this.filter);
        jiraDownloader.setJiraUser(this.jiraUser);
        jiraDownloader.setJiraPassword(this.jiraPassword);
        jiraDownloader.setUseJql(this.useJql);
        jiraDownloader.setWebUser(this.webUser);
        jiraDownloader.setWebPassword(this.webPassword);
        jiraDownloader.setConnectionTimeout(this.jiraConnectionTimeout);
        jiraDownloader.setReceiveTimout(this.jiraReceiveTimout);
        try {
            ((AbstractJiraDownloader)jiraDownloader).doExecute();
            List<Issue> issueList = ((AbstractJiraDownloader)jiraDownloader).getIssueList();
            if (StringUtils.isNotEmpty((String)this.versionPrefix)) {
                int originalNumberOfIssues = issueList.size();
                issueList = IssueUtils.filterIssuesWithVersionPrefix(issueList, this.versionPrefix);
                this.getLog().debug((CharSequence)("Filtered out " + issueList.size() + " issues of " + originalNumberOfIssues + " that matched the versionPrefix '" + this.versionPrefix + "'."));
            }
            return this.getReleases(issueList, new JIRAIssueManagmentSystem());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from JIRA.", e);
        }
    }

    private List<Release> getReleases(List<Issue> issues, IssueManagementSystem ims) throws MojoExecutionException {
        if (this.issueTypes != null) {
            ims.applyConfiguration(this.issueTypes);
        }
        if (issues.isEmpty()) {
            return Collections.emptyList();
        }
        IssueAdapter adapter = new IssueAdapter(ims);
        return adapter.getReleases(issues);
    }

    protected List<Release> getTracReleases() throws MojoExecutionException {
        TracDownloader issueDownloader = new TracDownloader();
        issueDownloader.setProject(this.project);
        issueDownloader.setQuery(this.tracQuery);
        issueDownloader.setTracPassword(this.tracPassword);
        issueDownloader.setTracUser(this.tracUser);
        try {
            return this.getReleases(issueDownloader.getIssueList(), new TracIssueManagmentSystem());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from Trac.", e);
        }
    }

    protected List<Release> getGitHubReleases() throws MojoExecutionException {
        try {
            GitHubDownloader issueDownloader = new GitHubDownloader(this.project, this.githubAPIScheme, this.githubAPIPort, this.includeOpenIssues, true);
            issueDownloader.configureAuthentication(this.githubAPIServerId, this.settings, this.getLog());
            return this.getReleases(issueDownloader.getIssueList(), new GitHubIssueManagementSystem());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to extract issues from GitHub.", e);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getDevelopmentTeam() {
        return this.developmentTeam;
    }

    public void setDevelopmentTeam(String developmentTeam) {
        this.developmentTeam = developmentTeam;
    }

    public String getFinalName() {
        return this.finalName;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public void setIssueTypes(Map<String, String> issueTypes) {
        this.issueTypes = issueTypes;
    }

    public Map<String, String> getIssueTypes() {
        return this.issueTypes;
    }

    public File getAnnouncementDirectory() {
        return this.announcementDirectory;
    }

    public void setAnnouncementDirectory(File announcementDirectory) {
        this.announcementDirectory = announcementDirectory;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlDownload() {
        return this.urlDownload;
    }

    public void setUrlDownload(String urlDownload) {
        this.urlDownload = urlDownload;
    }

    public VelocityComponent getVelocity() {
        return this.velocity;
    }

    public void setVelocity(VelocityComponent velocity) {
        this.velocity = velocity;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public ChangesXML getXml() {
        return this.xml;
    }

    public void setXml(ChangesXML xml) {
        this.xml = xml;
    }

    public File getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(File xmlPath) {
        this.xmlPath = xmlPath;
    }
}

