/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.github;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.plugin.changes.AbstractChangesReport;
import org.apache.maven.plugin.changes.ProjectUtils;
import org.apache.maven.plugin.github.GitHubDownloader;
import org.apache.maven.plugin.issues.Issue;
import org.apache.maven.plugin.issues.IssueUtils;
import org.apache.maven.plugin.issues.IssuesReportGenerator;
import org.apache.maven.plugin.issues.IssuesReportHelper;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;

@Mojo(name="github-report", threadSafe=true)
public class GitHubMojo
extends AbstractChangesReport {
    private static Map<String, Integer> githubColumns = new HashMap<String, Integer>();
    @Parameter(defaultValue="Id,Type,Summary,Assignee,Reporter,Status,Created,Updated,Fix Version")
    private String columnNames;
    @Parameter(defaultValue="http")
    private String githubAPIScheme;
    @Parameter(defaultValue="80")
    private int githubAPIPort;
    @Parameter(defaultValue="github")
    private String githubAPIServerId;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(defaultValue="true")
    private boolean includeOpenIssues;
    @Parameter(defaultValue="true")
    private boolean onlyMilestoneIssues;
    @Parameter(defaultValue="false")
    private boolean onlyCurrentVersion;

    public String getOutputName() {
        return "github-report";
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public boolean canGenerateReport() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the GitHub Report in this project because it's not the Execution Root");
            return false;
        }
        return ProjectUtils.validateIfIssueManagementComplete(this.project, "GitHub", "GitHub Report", this.getLog());
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        List<Integer> columnIds = IssuesReportHelper.getColumnIds(this.columnNames, githubColumns);
        if (columnIds.size() == 0) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + this.columnNames + "' are valid.");
        }
        try {
            GitHubDownloader issueDownloader = new GitHubDownloader(this.project, this.githubAPIScheme, this.githubAPIPort, this.includeOpenIssues, this.onlyMilestoneIssues);
            issueDownloader.configureAuthentication(this.githubAPIServerId, this.settings, this.getLog());
            List<Issue> issueList = issueDownloader.getIssueList();
            if (this.onlyCurrentVersion) {
                issueList = IssueUtils.getIssuesForVersion(issueList, this.project.getVersion());
                this.getLog().info((CharSequence)"The GitHub Report will contain issues only for the current version.");
            }
            IssuesReportGenerator report = new IssuesReportGenerator(IssuesReportHelper.toIntArray(columnIds));
            if (issueList.isEmpty()) {
                report.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
                this.getLog().warn((CharSequence)"No issue was matched.");
            } else {
                report.doGenerateReport(this.getBundle(locale), this.getSink(), issueList);
            }
        }
        catch (MalformedURLException e) {
            throw new MavenReportException("The Github URL is incorrect.");
        }
        catch (Exception e) {
            throw new MavenReportException(e.getMessage(), e);
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("github-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    static {
        githubColumns.put("Assignee", 0);
        githubColumns.put("Created", 2);
        githubColumns.put("Fix Version", 3);
        githubColumns.put("Id", 4);
        githubColumns.put("Reporter", 7);
        githubColumns.put("Status", 9);
        githubColumns.put("Summary", 10);
        githubColumns.put("Type", 11);
        githubColumns.put("Updated", 12);
    }
}

