/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GpgSigner {
    public static final String SIGNATURE_EXTENSION = ".asc";
    private boolean useAgent;
    private boolean isInteractive = true;
    private String keyname;
    private File outputDir;
    private File buildDir;
    private File baseDir;

    public void setInteractive(boolean b) {
        this.isInteractive = b;
    }

    public void setUseAgent(boolean b) {
        this.useAgent = b;
    }

    public void setKeyName(String s) {
        this.keyname = s;
    }

    public void setOutputDirectory(File out) {
        this.outputDir = out;
    }

    public void setBuildDirectory(File out) {
        this.buildDir = out;
    }

    public void setBaseDirectory(File out) {
        this.baseDir = out;
    }

    public File generateSignatureForArtifact(File file, String pass) throws MojoExecutionException {
        File parent;
        File signature = new File(file + SIGNATURE_EXTENSION);
        boolean isInBuildDir = false;
        if (this.buildDir != null && this.buildDir.equals(parent = signature.getParentFile())) {
            isInBuildDir = true;
        }
        if (!isInBuildDir && this.outputDir != null) {
            String fileDirectory = "";
            File signatureDirectory = signature;
            while ((signatureDirectory = signatureDirectory.getParentFile()) != null && !signatureDirectory.equals(this.baseDir)) {
                fileDirectory = signatureDirectory.getName() + File.separatorChar + fileDirectory;
            }
            signatureDirectory = new File(this.outputDir, fileDirectory);
            if (!signatureDirectory.exists()) {
                signatureDirectory.mkdirs();
            }
            signature = new File(signatureDirectory, file.getName() + SIGNATURE_EXTENSION);
        }
        if (signature.exists()) {
            signature.delete();
        }
        Commandline cmd = new Commandline();
        cmd.setExecutable("gpg" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""));
        if (this.useAgent) {
            cmd.createArgument().setValue("--use-agent");
        } else {
            cmd.createArgument().setValue("--no-use-agent");
        }
        ByteArrayInputStream in = null;
        if (null != pass) {
            cmd.createArgument().setValue("--passphrase-fd");
            cmd.createArgument().setValue("0");
            in = new ByteArrayInputStream(pass.getBytes());
        }
        if (null != this.keyname) {
            cmd.createArgument().setValue("--local-user");
            cmd.createArgument().setValue(this.keyname);
        }
        cmd.createArgument().setValue("--armor");
        cmd.createArgument().setValue("--detach-sign");
        if (!this.isInteractive) {
            cmd.createArgument().setValue("--no-tty");
        }
        cmd.createArgument().setValue("--output");
        cmd.createArgument().setFile(signature);
        cmd.createArgument().setFile(file);
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (InputStream)in, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)new DefaultConsumer());
            if (exitCode != 0) {
                throw new MojoExecutionException("Exit code: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute gpg command", (Exception)((Object)e));
        }
        return signature;
    }

    private MavenProject findReactorProject(MavenProject prj) {
        if (prj.getParent() != null && prj.getParent().getBasedir() != null && prj.getParent().getBasedir().exists()) {
            return this.findReactorProject(prj.getParent());
        }
        return prj;
    }

    public String getPassphrase(MavenProject project) throws IOException {
        String pass = null;
        if (project != null && (pass = project.getProperties().getProperty("gpg.passphrase")) == null) {
            MavenProject prj2 = this.findReactorProject(project);
            pass = prj2.getProperties().getProperty("gpg.passphrase");
        }
        if (pass == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (System.in.available() != 0) {
                System.in.read();
            }
            System.out.print("GPG Passphrase:  ");
            MaskingThread thread = new MaskingThread();
            thread.start();
            pass = in.readLine();
            thread.stopMasking();
        }
        if (project != null) {
            this.findReactorProject(project).getProperties().setProperty("gpg.passphrase", pass);
        }
        return pass;
    }

    class MaskingThread
    extends Thread {
        private volatile boolean stop;

        MaskingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = false;
                while (!this.stop) {
                    System.out.print("\b*");
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

