/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.impl;

import java.util.List;
import junit.framework.Assert;
import org.apache.parquet.VersionParser;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReaderImpl;
import org.apache.parquet.column.impl.ColumnWriterV2;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.page.mem.MemPageReader;
import org.apache.parquet.column.page.mem.MemPageWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Test;

public class TestColumnReaderImpl {
    private int rows = 13001;

    @Test
    public void test() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary foo; }");
        ColumnDescriptor col = (ColumnDescriptor)schema.getColumns().get(0);
        MemPageWriter pageWriter = new MemPageWriter();
        ColumnWriterV2 columnWriterV2 = new ColumnWriterV2(col, (PageWriter)pageWriter, new ParquetProperties(1024, ParquetProperties.WriterVersion.PARQUET_2_0, true), 2048);
        for (int i = 0; i < this.rows; ++i) {
            columnWriterV2.write(Binary.fromString((String)("bar" + i % 10)), 0, 0);
            if ((i + 1) % 1000 != 0) continue;
            columnWriterV2.writePage((long)i);
        }
        columnWriterV2.writePage((long)this.rows);
        columnWriterV2.finalizeColumnChunk();
        List<DataPage> pages = pageWriter.getPages();
        int valueCount = 0;
        int rowCount = 0;
        for (DataPage dataPage : pages) {
            valueCount += dataPage.getValueCount();
            rowCount += ((DataPageV2)dataPage).getRowCount();
        }
        Assert.assertEquals((int)this.rows, (int)rowCount);
        Assert.assertEquals((int)this.rows, (int)valueCount);
        MemPageReader pageReader = new MemPageReader(this.rows, pages.iterator(), pageWriter.getDictionaryPage());
        ValidatingConverter converter = new ValidatingConverter();
        ColumnReaderImpl columnReader = new ColumnReaderImpl(col, (PageReader)pageReader, (PrimitiveConverter)converter, VersionParser.parse((String)"parquet-mr version 1.8.1 (build 4aba4dae7bb0d4edbcf7923ae1339f28fd3f7fcf)"));
        for (int i = 0; i < this.rows; ++i) {
            Assert.assertEquals((int)0, (int)columnReader.getCurrentRepetitionLevel());
            Assert.assertEquals((int)0, (int)columnReader.getCurrentDefinitionLevel());
            columnReader.writeCurrentValueToConverter();
            columnReader.consume();
        }
        Assert.assertEquals((int)this.rows, (int)converter.count);
    }

    @Test
    public void testOptional() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { optional binary foo; }");
        ColumnDescriptor col = (ColumnDescriptor)schema.getColumns().get(0);
        MemPageWriter pageWriter = new MemPageWriter();
        ColumnWriterV2 columnWriterV2 = new ColumnWriterV2(col, (PageWriter)pageWriter, new ParquetProperties(1024, ParquetProperties.WriterVersion.PARQUET_2_0, true), 2048);
        for (int i = 0; i < this.rows; ++i) {
            columnWriterV2.writeNull(0, 0);
            if ((i + 1) % 1000 != 0) continue;
            columnWriterV2.writePage((long)i);
        }
        columnWriterV2.writePage((long)this.rows);
        columnWriterV2.finalizeColumnChunk();
        List<DataPage> pages = pageWriter.getPages();
        int valueCount = 0;
        int rowCount = 0;
        for (DataPage dataPage : pages) {
            valueCount += dataPage.getValueCount();
            rowCount += ((DataPageV2)dataPage).getRowCount();
        }
        Assert.assertEquals((int)this.rows, (int)rowCount);
        Assert.assertEquals((int)this.rows, (int)valueCount);
        MemPageReader pageReader = new MemPageReader(this.rows, pages.iterator(), pageWriter.getDictionaryPage());
        ValidatingConverter converter = new ValidatingConverter();
        ColumnReaderImpl columnReader = new ColumnReaderImpl(col, (PageReader)pageReader, (PrimitiveConverter)converter, VersionParser.parse((String)"parquet-mr version 1.8.1 (build 4aba4dae7bb0d4edbcf7923ae1339f28fd3f7fcf)"));
        for (int i = 0; i < this.rows; ++i) {
            Assert.assertEquals((int)0, (int)columnReader.getCurrentRepetitionLevel());
            Assert.assertEquals((int)0, (int)columnReader.getCurrentDefinitionLevel());
            columnReader.consume();
        }
        Assert.assertEquals((int)0, (int)converter.count);
    }

    private static final class ValidatingConverter
    extends PrimitiveConverter {
        int count;

        private ValidatingConverter() {
        }

        public void addBinary(Binary value) {
            Assert.assertEquals((String)("bar" + this.count % 10), (String)value.toStringUsingUTF8());
            ++this.count;
        }
    }
}

