/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

public class ConverterConsumer
extends RecordConsumer {
    private final GroupConverter root;
    private final MessageType schema;
    private Deque<GroupConverter> path = new ArrayDeque<GroupConverter>();
    private Deque<Type> typePath = new ArrayDeque<Type>();
    private GroupConverter current;
    private PrimitiveConverter currentPrimitive;
    private Type currentType;

    public ConverterConsumer(GroupConverter recordConsumer, MessageType schema) {
        this.root = recordConsumer;
        this.schema = schema;
    }

    public void startMessage() {
        this.root.start();
        this.currentType = this.schema;
        this.current = this.root;
    }

    public void endMessage() {
        this.root.end();
    }

    public void startField(String field, int index) {
        this.path.push(this.current);
        this.typePath.push(this.currentType);
        this.currentType = this.currentType.asGroupType().getType(index);
        if (this.currentType.isPrimitive()) {
            this.currentPrimitive = this.current.getConverter(index).asPrimitiveConverter();
        } else {
            this.current = this.current.getConverter(index).asGroupConverter();
        }
    }

    public void endField(String field, int index) {
        this.currentType = this.typePath.pop();
        this.current = this.path.pop();
    }

    public void startGroup() {
        this.current.start();
    }

    public void endGroup() {
        this.current.end();
    }

    public void addInteger(int value) {
        this.currentPrimitive.addInt(value);
    }

    public void addLong(long value) {
        this.currentPrimitive.addLong(value);
    }

    public void addBoolean(boolean value) {
        this.currentPrimitive.addBoolean(value);
    }

    public void addBinary(Binary value) {
        this.currentPrimitive.addBinary(value);
    }

    public void addFloat(float value) {
        this.currentPrimitive.addFloat(value);
    }

    public void addDouble(double value) {
        this.currentPrimitive.addDouble(value);
    }
}

