/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io.api;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestBinary {
    private static final String testString = "test-123";
    private static final String UTF8 = "UTF-8";
    private static final BinaryFactory BYTE_ARRAY_BACKED_BF = new BinaryFactory(){

        @Override
        public BinaryFactory.BinaryAndOriginal get(byte[] bytes, boolean reused) throws Exception {
            byte[] orig = Arrays.copyOf(bytes, bytes.length);
            if (reused) {
                return new BinaryFactory.BinaryAndOriginal(Binary.fromReusedByteArray((byte[])orig), orig);
            }
            return new BinaryFactory.BinaryAndOriginal(Binary.fromConstantByteArray((byte[])orig), orig);
        }
    };
    private static final BinaryFactory BYTE_ARRAY_SLICE_BACKED_BF = new BinaryFactory(){

        @Override
        public BinaryFactory.BinaryAndOriginal get(byte[] bytes, boolean reused) throws Exception {
            byte[] orig = TestBinary.padded(bytes);
            Binary b = reused ? Binary.fromReusedByteArray((byte[])orig, (int)5, (int)bytes.length) : Binary.fromConstantByteArray((byte[])orig, (int)5, (int)bytes.length);
            Assert.assertArrayEquals((byte[])bytes, (byte[])b.getBytes());
            return new BinaryFactory.BinaryAndOriginal(b, orig);
        }
    };
    private static final BinaryFactory BUFFER_BF = new BinaryFactory(){

        @Override
        public BinaryFactory.BinaryAndOriginal get(byte[] bytes, boolean reused) throws Exception {
            byte[] orig = TestBinary.padded(bytes);
            ByteBuffer buff = ByteBuffer.wrap(orig, 5, bytes.length);
            Binary b = reused ? Binary.fromReusedByteBuffer((ByteBuffer)buff) : Binary.fromConstantByteBuffer((ByteBuffer)buff);
            buff.mark();
            Assert.assertArrayEquals((byte[])bytes, (byte[])b.getBytes());
            buff.reset();
            return new BinaryFactory.BinaryAndOriginal(b, orig);
        }
    };
    private static final BinaryFactory STRING_BF = new BinaryFactory(){

        @Override
        public BinaryFactory.BinaryAndOriginal get(byte[] bytes, boolean reused) throws Exception {
            Binary b = Binary.fromString((String)new String(bytes, TestBinary.UTF8));
            return new BinaryFactory.BinaryAndOriginal(b, b.getBytesUnsafe());
        }
    };

    private static void mutate(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(bytes[i] + 1);
        }
    }

    private static byte[] padded(byte[] bytes) {
        int i;
        byte[] padded = new byte[bytes.length + 10];
        for (i = 0; i < 5; ++i) {
            padded[i] = (byte)i;
        }
        System.arraycopy(bytes, 0, padded, 5, bytes.length);
        for (i = 0; i < 5; ++i) {
            padded[i + 5 + bytes.length] = (byte)i;
        }
        return padded;
    }

    @Test
    public void testByteArrayBackedBinary() throws Exception {
        this.testBinary(BYTE_ARRAY_BACKED_BF, true);
        this.testBinary(BYTE_ARRAY_BACKED_BF, false);
    }

    @Test
    public void testByteArraySliceBackedBinary() throws Exception {
        this.testBinary(BYTE_ARRAY_SLICE_BACKED_BF, true);
        this.testBinary(BYTE_ARRAY_SLICE_BACKED_BF, false);
    }

    @Test
    public void testByteBufferBackedBinary() throws Exception {
        this.testBinary(BUFFER_BF, true);
        this.testBinary(BUFFER_BF, false);
    }

    @Test
    public void testFromStringBinary() throws Exception {
        this.testBinary(STRING_BF, false);
    }

    private void testSlice(BinaryFactory bf, boolean reused) throws Exception {
        BinaryFactory.BinaryAndOriginal bao = bf.get(testString.getBytes(UTF8), reused);
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.slice(0, testString.length()).getBytesUnsafe());
        Assert.assertArrayEquals((byte[])"123".getBytes(UTF8), (byte[])bao.binary.slice(5, 3).getBytesUnsafe());
    }

    private void testConstantCopy(BinaryFactory bf) throws Exception {
        BinaryFactory.BinaryAndOriginal bao = bf.get(testString.getBytes(UTF8), false);
        Assert.assertEquals((Object)false, (Object)bao.binary.isBackingBytesReused());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.getBytes());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.getBytesUnsafe());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.copy().getBytesUnsafe());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.copy().getBytes());
        bao = bf.get(testString.getBytes(UTF8), false);
        Assert.assertEquals((Object)false, (Object)bao.binary.isBackingBytesReused());
        Binary copy = bao.binary.copy();
        Assert.assertSame((Object)copy, (Object)bao.binary);
        TestBinary.mutate(bao.original);
        byte[] expected = testString.getBytes(UTF8);
        TestBinary.mutate(expected);
        Assert.assertArrayEquals((byte[])expected, (byte[])copy.getBytes());
        Assert.assertArrayEquals((byte[])expected, (byte[])copy.getBytesUnsafe());
        Assert.assertArrayEquals((byte[])expected, (byte[])copy.copy().getBytesUnsafe());
        Assert.assertArrayEquals((byte[])expected, (byte[])copy.copy().getBytes());
    }

    private void testReusedCopy(BinaryFactory bf) throws Exception {
        BinaryFactory.BinaryAndOriginal bao = bf.get(testString.getBytes(UTF8), true);
        Assert.assertEquals((Object)true, (Object)bao.binary.isBackingBytesReused());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.getBytes());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.getBytesUnsafe());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.copy().getBytesUnsafe());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])bao.binary.copy().getBytes());
        bao = bf.get(testString.getBytes(UTF8), true);
        Assert.assertEquals((Object)true, (Object)bao.binary.isBackingBytesReused());
        Binary copy = bao.binary.copy();
        TestBinary.mutate(bao.original);
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])copy.getBytes());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])copy.getBytesUnsafe());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])copy.copy().getBytesUnsafe());
        Assert.assertArrayEquals((byte[])testString.getBytes(UTF8), (byte[])copy.copy().getBytes());
    }

    private void testBinary(BinaryFactory bf, boolean reused) throws Exception {
        this.testSlice(bf, reused);
        if (reused) {
            this.testReusedCopy(bf);
        } else {
            this.testConstantCopy(bf);
        }
    }

    static interface BinaryFactory {
        public BinaryAndOriginal get(byte[] var1, boolean var2) throws Exception;

        public static class BinaryAndOriginal {
            public Binary binary;
            public byte[] original;

            public BinaryAndOriginal(Binary binary, byte[] original) {
                this.binary = binary;
                this.original = original;
            }
        }
    }
}

