/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.dictionary;

import java.io.IOException;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.values.plain.PlainValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public abstract class PlainValuesDictionary
extends Dictionary {
    protected PlainValuesDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        if (dictionaryPage.getEncoding() != Encoding.PLAIN_DICTIONARY && dictionaryPage.getEncoding() != Encoding.PLAIN) {
            throw new ParquetDecodingException("Dictionary data encoding type not supported: " + (Object)((Object)dictionaryPage.getEncoding()));
        }
    }

    public static class PlainFloatDictionary
    extends PlainValuesDictionary {
        private float[] floatDictionaryContent = null;

        public PlainFloatDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            byte[] dictionaryBytes = dictionaryPage.getBytes().toByteArray();
            this.floatDictionaryContent = new float[dictionaryPage.getDictionarySize()];
            PlainValuesReader.FloatPlainValuesReader floatReader = new PlainValuesReader.FloatPlainValuesReader();
            floatReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryBytes, 0);
            for (int i = 0; i < this.floatDictionaryContent.length; ++i) {
                this.floatDictionaryContent[i] = floatReader.readFloat();
            }
        }

        @Override
        public float decodeToFloat(int id) {
            return this.floatDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainFloatDictionary {\n");
            for (int i = 0; i < this.floatDictionaryContent.length; ++i) {
                sb.append(i).append(" => ").append(this.floatDictionaryContent[i]).append("\n");
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.floatDictionaryContent.length - 1;
        }
    }

    public static class PlainIntegerDictionary
    extends PlainValuesDictionary {
        private int[] intDictionaryContent = null;

        public PlainIntegerDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            byte[] dictionaryBytes = dictionaryPage.getBytes().toByteArray();
            this.intDictionaryContent = new int[dictionaryPage.getDictionarySize()];
            PlainValuesReader.IntegerPlainValuesReader intReader = new PlainValuesReader.IntegerPlainValuesReader();
            intReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryBytes, 0);
            for (int i = 0; i < this.intDictionaryContent.length; ++i) {
                this.intDictionaryContent[i] = intReader.readInteger();
            }
        }

        @Override
        public int decodeToInt(int id) {
            return this.intDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainIntegerDictionary {\n");
            for (int i = 0; i < this.intDictionaryContent.length; ++i) {
                sb.append(i).append(" => ").append(this.intDictionaryContent[i]).append("\n");
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.intDictionaryContent.length - 1;
        }
    }

    public static class PlainDoubleDictionary
    extends PlainValuesDictionary {
        private double[] doubleDictionaryContent = null;

        public PlainDoubleDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            byte[] dictionaryBytes = dictionaryPage.getBytes().toByteArray();
            this.doubleDictionaryContent = new double[dictionaryPage.getDictionarySize()];
            PlainValuesReader.DoublePlainValuesReader doubleReader = new PlainValuesReader.DoublePlainValuesReader();
            doubleReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryBytes, 0);
            for (int i = 0; i < this.doubleDictionaryContent.length; ++i) {
                this.doubleDictionaryContent[i] = doubleReader.readDouble();
            }
        }

        @Override
        public double decodeToDouble(int id) {
            return this.doubleDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainDoubleDictionary {\n");
            for (int i = 0; i < this.doubleDictionaryContent.length; ++i) {
                sb.append(i).append(" => ").append(this.doubleDictionaryContent[i]).append("\n");
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.doubleDictionaryContent.length - 1;
        }
    }

    public static class PlainLongDictionary
    extends PlainValuesDictionary {
        private long[] longDictionaryContent = null;

        public PlainLongDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            byte[] dictionaryBytes = dictionaryPage.getBytes().toByteArray();
            this.longDictionaryContent = new long[dictionaryPage.getDictionarySize()];
            PlainValuesReader.LongPlainValuesReader longReader = new PlainValuesReader.LongPlainValuesReader();
            longReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryBytes, 0);
            for (int i = 0; i < this.longDictionaryContent.length; ++i) {
                this.longDictionaryContent[i] = longReader.readLong();
            }
        }

        @Override
        public long decodeToLong(int id) {
            return this.longDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainLongDictionary {\n");
            for (int i = 0; i < this.longDictionaryContent.length; ++i) {
                sb.append(i).append(" => ").append(this.longDictionaryContent[i]).append("\n");
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.longDictionaryContent.length - 1;
        }
    }

    public static class PlainBinaryDictionary
    extends PlainValuesDictionary {
        private Binary[] binaryDictionaryContent = null;

        public PlainBinaryDictionary(DictionaryPage dictionaryPage) throws IOException {
            this(dictionaryPage, null);
        }

        public PlainBinaryDictionary(DictionaryPage dictionaryPage, Integer length) throws IOException {
            super(dictionaryPage);
            byte[] dictionaryBytes = dictionaryPage.getBytes().toByteArray();
            this.binaryDictionaryContent = new Binary[dictionaryPage.getDictionarySize()];
            int offset = 0;
            if (length == null) {
                for (int i = 0; i < this.binaryDictionaryContent.length; ++i) {
                    int len = BytesUtils.readIntLittleEndian(dictionaryBytes, offset);
                    this.binaryDictionaryContent[i] = Binary.fromConstantByteArray(dictionaryBytes, offset += 4, len);
                    offset += len;
                }
            } else {
                Preconditions.checkArgument(length > 0, "Invalid byte array length: " + length);
                for (int i = 0; i < this.binaryDictionaryContent.length; ++i) {
                    this.binaryDictionaryContent[i] = Binary.fromConstantByteArray(dictionaryBytes, offset, length);
                    offset += length.intValue();
                }
            }
        }

        @Override
        public Binary decodeToBinary(int id) {
            return this.binaryDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainBinaryDictionary {\n");
            for (int i = 0; i < this.binaryDictionaryContent.length; ++i) {
                sb.append(i).append(" => ").append(this.binaryDictionaryContent[i]).append("\n");
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.binaryDictionaryContent.length - 1;
        }
    }
}

