/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.scrooge;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import com.twitter.scrooge.ThriftStruct;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.parquet.cascading.ParquetValueScheme;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import org.apache.parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import org.apache.parquet.hadoop.thrift.ThriftReadSupport;
import org.apache.parquet.scrooge.ScroogeReadSupport;
import org.apache.parquet.scrooge.ScroogeRecordConverter;
import org.apache.parquet.scrooge.ScroogeWriteSupport;

public class ParquetScroogeScheme<T extends ThriftStruct>
extends ParquetValueScheme<T> {
    private static final long serialVersionUID = -8332274507341448397L;

    public ParquetScroogeScheme(Class<T> klass) {
        this(new ParquetValueScheme.Config().withRecordClass(klass));
    }

    public ParquetScroogeScheme(FilterPredicate filterPredicate, Class<T> klass) {
        this(new ParquetValueScheme.Config().withFilterPredicate(filterPredicate).withRecordClass(klass));
    }

    public ParquetScroogeScheme(ParquetValueScheme.Config<T> config) {
        super(config);
    }

    public void sinkConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        DeprecatedParquetOutputFormat.setAsOutputFormat((JobConf)jobConf);
        ParquetOutputFormat.setWriteSupportClass((JobConf)jobConf, ScroogeWriteSupport.class);
        ScroogeWriteSupport.setScroogeClass((Configuration)jobConf, this.config.getKlass());
    }

    public void sourceConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        super.sourceConfInit(fp, tap, jobConf);
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((JobConf)jobConf, ScroogeReadSupport.class);
        ThriftReadSupport.setRecordConverterClass((JobConf)jobConf, ScroogeRecordConverter.class);
    }
}

