/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.scrooge;

import com.twitter.scrooge.ThriftStruct;
import com.twitter.scrooge.ThriftStructCodec;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.thrift.ThriftReader;
import org.apache.parquet.thrift.ThriftRecordConverter;
import org.apache.parquet.thrift.struct.ThriftType;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class ScroogeRecordConverter<T extends ThriftStruct>
extends ThriftRecordConverter<T> {
    public ScroogeRecordConverter(final Class<T> thriftClass, MessageType parquetSchema, ThriftType.StructType thriftType) {
        super(new ThriftReader<T>(){
            ThriftStructCodec<T> codec;
            {
                this.codec = ScroogeRecordConverter.getCodec(thriftClass);
            }

            public T readOneRecord(TProtocol protocol) throws TException {
                return this.codec.decode(protocol);
            }
        }, thriftClass.getSimpleName(), parquetSchema, thriftType);
    }

    private static ThriftStructCodec<?> getCodec(Class<?> klass) {
        try {
            Class<?> companionClass = Class.forName(klass.getName() + "$");
            Object companionObject = companionClass.getField("MODULE$").get(null);
            return (ThriftStructCodec)companionObject;
        }
        catch (Exception t) {
            if (t instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException("Unable to create ThriftStructCodec", t);
        }
    }
}

