/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.common;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;
import org.apache.sentry.core.common.ImplyMethodType;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.policy.common.Privilege;

public class CommonPrivilege
implements Privilege {
    private ImmutableList<KeyValue> parts;

    public CommonPrivilege(String privilegeStr) {
        privilegeStr = Strings.nullToEmpty((String)privilegeStr).trim();
        if (privilegeStr.isEmpty()) {
            throw new IllegalArgumentException("Privilege string cannot be null or empty.");
        }
        ArrayList parts = Lists.newArrayList();
        for (String authorizable : SentryConstants.AUTHORIZABLE_SPLITTER.trimResults().split((CharSequence)privilegeStr)) {
            if (authorizable.isEmpty()) {
                throw new IllegalArgumentException("Privilege '" + privilegeStr + "' has an empty section");
            }
            parts.add(new KeyValue(authorizable));
        }
        if (parts.isEmpty()) {
            throw new AssertionError((Object)("Should never occur: " + privilegeStr));
        }
        this.parts = ImmutableList.copyOf((Collection)parts);
    }

    @Override
    public boolean implies(Privilege privilege, Model model) {
        if (!(privilege instanceof CommonPrivilege)) {
            return false;
        }
        List<KeyValue> otherParts = ((CommonPrivilege)privilege).getParts();
        if (this.parts.equals(otherParts)) {
            return true;
        }
        int index = 0;
        for (KeyValue otherPart : otherParts) {
            if (this.parts.size() - 1 < index) {
                return true;
            }
            KeyValue part = (KeyValue)this.parts.get(index);
            String policyKey = part.getKey();
            if (!policyKey.equalsIgnoreCase(otherPart.getKey())) {
                if ("action".equalsIgnoreCase(policyKey)) continue;
                return false;
            }
            if ("action".equalsIgnoreCase(policyKey) ? !this.impliesAction(part.getValue(), otherPart.getValue(), model.getBitFieldActionFactory()) : !this.impliesResource((ImplyMethodType)model.getImplyMethodMap().get(policyKey.toLowerCase()), part.getValue(), otherPart.getValue())) {
                return false;
            }
            ++index;
        }
        while (index < this.parts.size()) {
            KeyValue part = (KeyValue)this.parts.get(index);
            if (!"*".equals(part.getValue())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public List<KeyValue> getAuthorizable() {
        ArrayList<KeyValue> authorizable = new ArrayList<KeyValue>();
        for (KeyValue part : this.parts) {
            if ("action".equalsIgnoreCase(part.getKey())) continue;
            KeyValue keyValue = new KeyValue(part.getKey().toLowerCase(), part.getValue().toLowerCase());
            authorizable.add(keyValue);
        }
        return authorizable;
    }

    private boolean impliesResource(ImplyMethodType implyMethodType, String policyValue, String requestValue) {
        if ("*".equals(policyValue) || "*".equals(requestValue) || "ALL".equalsIgnoreCase(policyValue) || "ALL".equalsIgnoreCase(requestValue) || "+".equals(requestValue)) {
            return true;
        }
        if (ImplyMethodType.URL == implyMethodType) {
            return PathUtils.impliesURI((String)policyValue, (String)requestValue);
        }
        if (ImplyMethodType.STRING_CASE_SENSITIVE == implyMethodType) {
            return policyValue.equals(requestValue);
        }
        return policyValue.equalsIgnoreCase(requestValue);
    }

    private boolean impliesAction(String policyValue, String requestValue, BitFieldActionFactory bitFieldActionFactory) {
        BitFieldAction currentAction = bitFieldActionFactory.getActionByName(policyValue);
        BitFieldAction requestAction = bitFieldActionFactory.getActionByName(requestValue);
        if (currentAction == null || requestAction == null) {
            return false;
        }
        return currentAction.implies(requestAction);
    }

    public String toString() {
        return SentryConstants.AUTHORIZABLE_JOINER.join(this.parts);
    }

    public List<KeyValue> getParts() {
        return this.parts;
    }

    public boolean equals(Object o) {
        if (o instanceof CommonPrivilege) {
            CommonPrivilege cp = (CommonPrivilege)o;
            return this.parts.equals(cp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

