/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.File;
import org.apache.spark.HttpServer;
import org.apache.spark.HttpServer$;
import org.apache.spark.Logging;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.tools.nsc.Settings;

public final class Main$
implements Logging {
    public static final Main$ MODULE$;
    private final SparkConf conf;
    private final String tmp;
    private final String rootDir;
    private final File outputDir;
    private final Settings s;
    private HttpServer classServer;
    private SparkContext sparkContext;
    private SQLContext sqlContext;
    private SparkILoop interp;
    private transient Logger org$apache$spark$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new Main$();
    }

    private HttpServer classServer$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if (!this.bitmap$0) {
                this.classServer = new HttpServer(this.conf(), this.outputDir(), new SecurityManager(this.conf()), HttpServer$.MODULE$.$lessinit$greater$default$4(), HttpServer$.MODULE$.$lessinit$greater$default$5());
                this.bitmap$0 = true;
            }
            return this.classServer;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public String tmp() {
        return this.tmp;
    }

    public String rootDir() {
        return this.rootDir;
    }

    public File outputDir() {
        return this.outputDir;
    }

    public Settings s() {
        return this.s;
    }

    public HttpServer classServer() {
        return this.bitmap$0 ? this.classServer : this.classServer$lzycompute();
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    public SparkILoop interp() {
        return this.interp;
    }

    public void interp_$eq(SparkILoop x$1) {
        this.interp = x$1;
    }

    public void main(String[] args) {
        String string = this.getMaster();
        String string2 = "yarn-client";
        Object object = !(string != null ? !string.equals(string2) : string2 != null) ? System.setProperty("SPARK_YARN_MODE", "true") : BoxedUnit.UNIT;
        this.classServer().start();
        this.interp().process(this.s());
        this.classServer().stop();
        Option$.MODULE$.apply((Object)this.sparkContext()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(SparkContext x$1) {
                x$1.stop();
            }
        });
    }

    public String[] getAddedJars() {
        Option envJars = package$.MODULE$.env().get((Object)"ADD_JARS");
        if (envJars.isDefined()) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ADD_JARS environment variable is deprecated, use --jar spark submit argument instead";
                }
            });
        }
        Option propJars = package$.MODULE$.props().get("spark.jars").flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String p) {
                String string = p;
                String string2 = "";
                return !(string != null ? !string.equals(string2) : string2 != null) ? None$.MODULE$ : new Some((Object)p);
            }
        });
        String jars = (String)propJars.orElse((Function0)new Serializable(envJars){
            public static final long serialVersionUID = 0L;
            private final Option envJars$1;

            public final Option<String> apply() {
                return this.envJars$1;
            }
            {
                this.envJars$1 = envJars$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return (String[])Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.resolveURIs(jars).split(",")).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
            }
        });
    }

    public SparkContext createSparkContext() {
        String execUri = System.getenv("SPARK_EXECUTOR_URI");
        String[] jars = this.getAddedJars();
        SparkConf conf = new SparkConf().setMaster(this.getMaster()).setJars(jars).set("spark.repl.class.uri", this.classServer().uri()).setIfMissing("spark.app.name", "Spark shell");
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Spark class server started at ").append((Object)Main$.MODULE$.classServer().uri()).toString();
            }
        });
        Object object = execUri == null ? BoxedUnit.UNIT : conf.set("spark.executor.uri", execUri);
        Object object2 = System.getenv("SPARK_HOME") == null ? BoxedUnit.UNIT : conf.setSparkHome(System.getenv("SPARK_HOME"));
        this.sparkContext_$eq(new SparkContext(conf));
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Created spark context..";
            }
        });
        return this.sparkContext();
    }

    public SQLContext createSQLContext() {
        Throwable throwable2;
        block2: {
            String name = "org.apache.spark.sql.hive.HiveContext";
            ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
            try {
                this.sqlContext_$eq((SQLContext)loader.loadClass(name).getConstructor(SparkContext.class).newInstance(this.sparkContext()));
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created sql context (with Hive support)..";
                    }
                });
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof ClassNotFoundException ? true : throwable3 instanceof NoClassDefFoundError;
                if (!bl) break block2;
                this.sqlContext_$eq(new SQLContext(this.sparkContext()));
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created sql context..";
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return this.sqlContext();
        }
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    private String getMaster() {
        void var3_3;
        Option envMaster = package$.MODULE$.env().get((Object)"MASTER");
        Option propMaster = package$.MODULE$.props().get("spark.master");
        String master = (String)propMaster.orElse((Function0)new Serializable(envMaster){
            public static final long serialVersionUID = 0L;
            private final Option envMaster$1;

            public final Option<String> apply() {
                return this.envMaster$1;
            }
            {
                this.envMaster$1 = envMaster$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "local[*]";
            }
        });
        return var3_3;
    }

    private Main$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.conf = new SparkConf();
        this.tmp = System.getProperty("java.io.tmpdir");
        this.rootDir = this.conf().get("spark.repl.classdir", this.tmp());
        this.outputDir = Utils$.MODULE$.createTempDir(this.rootDir(), Utils$.MODULE$.createTempDir$default$2());
        this.s = new Settings();
        this.s().processArguments(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Yrepl-class-based", "-Yrepl-outdir", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputDir().getAbsolutePath()})), "-classpath", Predef$.MODULE$.refArrayOps((Object[])this.getAddedJars()).mkString(File.pathSeparator)})), true);
        this.interp = new SparkILoop();
    }
}

