/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.Client$;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil$;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.base.Objects;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Client$
implements Logging {
    public static final Client$ MODULE$;
    private final String APP_JAR_NAME;
    private final String LOCAL_SCHEME;
    private final String SPARK_STAGING;
    private final FsPermission STAGING_DIR_PERMISSION;
    private final FsPermission APP_FILE_PERMISSION;
    private final String ENV_DIST_CLASSPATH;
    private final String LOCALIZED_CONF_DIR;
    private final String LOCALIZED_CONF_ARCHIVE;
    private final String SPARK_CONF_FILE;
    private final String LOCALIZED_PYTHON_DIR;
    private final String LOCALIZED_LIB_DIR;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Client$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public void main(String[] argStrings) {
        if (!scala.sys.package$.MODULE$.props().contains("SPARK_SUBMIT")) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "WARNING: This client is deprecated and will be removed in a future version of Spark. Use ./bin/spark-submit with \"--master yarn\"";
                }
            });
        }
        System.setProperty("SPARK_YARN_MODE", "true");
        SparkConf sparkConf = new SparkConf();
        ClientArguments args = new ClientArguments(argStrings);
        new Client(args, sparkConf).run();
    }

    public String APP_JAR_NAME() {
        return this.APP_JAR_NAME;
    }

    public String LOCAL_SCHEME() {
        return this.LOCAL_SCHEME;
    }

    public String SPARK_STAGING() {
        return this.SPARK_STAGING;
    }

    public FsPermission STAGING_DIR_PERMISSION() {
        return this.STAGING_DIR_PERMISSION;
    }

    public FsPermission APP_FILE_PERMISSION() {
        return this.APP_FILE_PERMISSION;
    }

    public String ENV_DIST_CLASSPATH() {
        return this.ENV_DIST_CLASSPATH;
    }

    public String LOCALIZED_CONF_DIR() {
        return this.LOCALIZED_CONF_DIR;
    }

    public String LOCALIZED_CONF_ARCHIVE() {
        return this.LOCALIZED_CONF_ARCHIVE;
    }

    public String SPARK_CONF_FILE() {
        return this.SPARK_CONF_FILE;
    }

    public String LOCALIZED_PYTHON_DIR() {
        return this.LOCALIZED_PYTHON_DIR;
    }

    public String LOCALIZED_LIB_DIR() {
        return this.LOCALIZED_LIB_DIR;
    }

    public String org$apache$spark$deploy$yarn$Client$$getAppStagingDir(ApplicationId appId) {
        return this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SPARK_STAGING(), appId.toString()}));
    }

    public void populateHadoopClasspath(Configuration conf, HashMap<String, String> env) {
        Iterable classPathElementsToAdd = (Iterable)Option$.MODULE$.option2Iterable(this.getYarnAppClasspath(conf)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.getMRAppClasspath(conf)), Iterable$.MODULE$.canBuildFrom());
        ((IterableLike)classPathElementsToAdd.flatten((Function1)Predef$.MODULE$.conforms())).foreach((Function1)new Serializable(env){
            public static final long serialVersionUID = 0L;
            private final HashMap env$3;

            public final void apply(String c) {
                YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$3, ApplicationConstants.Environment.CLASSPATH.name(), c.trim());
            }
            {
                this.env$3 = env$3;
            }
        });
    }

    private Option<Seq<String>> getYarnAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("yarn.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = this.getDefaultYarnApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    private Option<Seq<String>> getMRAppClasspath(Configuration conf) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)conf.getStrings("mapreduce.application.classpath"));
                    if (!(option instanceof Some)) break block2;
                    Some some2 = (Some)option;
                    String[] s = (String[])some2.x();
                    some = new Some((Object)Predef$.MODULE$.refArrayOps((Object[])s).toSeq());
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                some = this.getDefaultMRApplicationClasspath();
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    public Option<Seq<String>> getDefaultYarnApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<String> apply() {
                            Field field = YarnConfiguration.class.getField("DEFAULT_YARN_APPLICATION_CLASSPATH");
                            String[] value = (String[])field.get(null);
                            return Predef$.MODULE$.refArrayOps((Object[])value).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unable to obtain the default YARN Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    public static final long serialVersionUID = 0L;
                    private final Success x3$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default YARN application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$1.get()).mkString(",")}));
                    }
                    {
                        this.x3$1 = x3$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public Option<Seq<String>> getDefaultMRApplicationClasspath() {
        Try try_;
        block4: {
            Try triedDefault;
            block3: {
                block2: {
                    triedDefault = Try$.MODULE$.apply((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<String> apply() {
                            Field field = MRJobConfig.class.getField("DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH");
                            return Predef$.MODULE$.refArrayOps((Object[])StringUtils.getStrings((String)((String)field.get(null)))).toSeq();
                        }
                    }).recoverWith((PartialFunction)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            A1 A1 = x2;
                            Object object = A1 instanceof NoSuchFieldException ? new Success((Object)Seq$.MODULE$.empty()) : function1.apply(x2);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = throwable instanceof NoSuchFieldException;
                            return bl;
                        }
                    });
                    try_ = triedDefault;
                    if (!(try_ instanceof Failure)) break block2;
                    Failure failure = (Failure)try_;
                    this.logError((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unable to obtain the default MR Application classpath.";
                        }
                    }, failure.exception());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(try_ instanceof Success)) break block4;
                Success success = (Success)try_;
                this.logDebug((Function0<String>)new Serializable(success){
                    public static final long serialVersionUID = 0L;
                    private final Success x3$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using the default MR application classpath: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.x3$2.get()).mkString(",")}));
                    }
                    {
                        this.x3$2 = x3$2;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return triedDefault.toOption();
        }
        throw new MatchError((Object)try_);
    }

    public void populateClasspath(ClientArguments args, Configuration conf, SparkConf sparkConf, HashMap<String, String> env, Option<String> extraClassPath) {
        extraClassPath.foreach((Function1)new Serializable(sparkConf, env){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final HashMap env$2;

            public final void apply(String cp) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(Client$.MODULE$.getClusterPath(this.sparkConf$1, cp), (HashMap<String, String>)this.env$2);
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.env$2 = env$2;
            }
        });
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), env);
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(new StringBuilder().append((Object)YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD)).append((Object)"/").append((Object)this.LOCALIZED_CONF_DIR()).toString(), env);
        if (BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.USER_CLASS_PATH_FIRST()))) {
            Option<URI> mainJar = args == null ? this.getMainJarUri((Option<String>)((Option)sparkConf.get(package$.MODULE$.APP_JAR()))) : this.getMainJarUri((Option<String>)Option$.MODULE$.apply((Object)args.userJar()));
            mainJar.foreach((Function1)new Serializable(conf, sparkConf, env){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$1;
                private final SparkConf sparkConf$1;
                private final HashMap env$2;

                public final void apply(URI x$17) {
                    Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(this.sparkConf$1, this.conf$1, x$17, Client$.MODULE$.APP_JAR_NAME(), (HashMap<String, String>)this.env$2);
                }
                {
                    this.conf$1 = conf$1;
                    this.sparkConf$1 = sparkConf$1;
                    this.env$2 = env$2;
                }
            });
            Seq<URI> secondaryJars = args == null ? this.getSecondaryJarUris((Option<Seq<String>>)((Option)sparkConf.get(package$.MODULE$.SECONDARY_JARS()))) : this.getSecondaryJarUris((Option<Seq<String>>)Option$.MODULE$.apply(sparkConf.get(package$.MODULE$.JARS_TO_DISTRIBUTE())));
            secondaryJars.foreach((Function1)new Serializable(conf, sparkConf, env){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$1;
                private final SparkConf sparkConf$1;
                private final HashMap env$2;

                public final void apply(URI x) {
                    Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addFileToClasspath(this.sparkConf$1, this.conf$1, x, null, (HashMap<String, String>)this.env$2);
                }
                {
                    this.conf$1 = conf$1;
                    this.sparkConf$1 = sparkConf$1;
                    this.env$2 = env$2;
                }
            });
        }
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), this.LOCALIZED_LIB_DIR(), "*"})), env);
        if (!((Option)sparkConf.get(package$.MODULE$.SPARK_ARCHIVE())).isDefined()) {
            ((Option)sparkConf.get(package$.MODULE$.SPARK_JARS())).foreach((Function1)new Serializable(sparkConf, env){
                public static final long serialVersionUID = 0L;
                public final SparkConf sparkConf$1;
                public final HashMap env$2;

                public final void apply(Seq<String> jars) {
                    ((IterableLike)jars.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String uri) {
                            return Client$.MODULE$.isLocalUri(uri);
                        }
                    })).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.populateClasspath.4 $outer;

                        public final void apply(String jar) {
                            Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(Client$.MODULE$.getClusterPath(this.$outer.sparkConf$1, jar), (HashMap<String, String>)this.$outer.env$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.sparkConf$1 = sparkConf$1;
                    this.env$2 = env$2;
                }
            });
        }
        this.populateHadoopClasspath(conf, env);
        scala.sys.package$.MODULE$.env().get((Object)this.ENV_DIST_CLASSPATH()).foreach((Function1)new Serializable(sparkConf, env){
            public static final long serialVersionUID = 0L;
            private final SparkConf sparkConf$1;
            private final HashMap env$2;

            public final void apply(String cp) {
                Client$.MODULE$.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(Client$.MODULE$.getClusterPath(this.sparkConf$1, cp), (HashMap<String, String>)this.env$2);
            }
            {
                this.sparkConf$1 = sparkConf$1;
                this.env$2 = env$2;
            }
        });
    }

    public Option<String> populateClasspath$default$5() {
        return None$.MODULE$;
    }

    public URI[] getUserClasspath(SparkConf conf) {
        Option<URI> mainUri = this.getMainJarUri((Option<String>)((Option)conf.get(package$.MODULE$.APP_JAR())));
        Seq<URI> secondaryUris = this.getSecondaryJarUris((Option<Seq<String>>)((Option)conf.get(package$.MODULE$.SECONDARY_JARS())));
        return (URI[])((TraversableOnce)Option$.MODULE$.option2Iterable(mainUri).$plus$plus(secondaryUris, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(URI.class));
    }

    private Option<URI> getMainJarUri(Option<String> mainJar) {
        return mainJar.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<URI> apply(String path) {
                URI uri = Utils$.MODULE$.resolveURI(path);
                String string = uri.getScheme();
                String string2 = Client$.MODULE$.LOCAL_SCHEME();
                return !(string != null ? !string.equals(string2) : string2 != null) ? new Some((Object)uri) : None$.MODULE$;
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Some<URI> apply() {
                return new Some((Object)new URI(Client$.MODULE$.APP_JAR_NAME()));
            }
        });
    }

    private Seq<URI> getSecondaryJarUris(Option<Seq<String>> secondaryJars) {
        return (Seq)((TraversableLike)secondaryJars.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String x$18) {
                return new URI(x$18);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void org$apache$spark$deploy$yarn$Client$$addFileToClasspath(SparkConf conf, Configuration hadoopConf, URI uri, String fileName, HashMap<String, String> env) {
        if (uri != null) {
            String string = uri.getScheme();
            String string2 = this.LOCAL_SCHEME();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.getClusterPath(conf, uri.getPath()), env);
                return;
            }
        }
        if (fileName == null) {
            if (uri == null) return;
            Path localPath = this.org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(uri, hadoopConf);
            String linkName = (String)Option$.MODULE$.apply((Object)uri.getFragment()).getOrElse((Function0)new Serializable(localPath){
                public static final long serialVersionUID = 0L;
                private final Path localPath$2;

                public final String apply() {
                    return this.localPath$2.getName();
                }
                {
                    this.localPath$2 = localPath$2;
                }
            });
            this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), linkName})), env);
            return;
        }
        this.org$apache$spark$deploy$yarn$Client$$addClasspathEntry(this.buildPath((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{YarnSparkHadoopUtil$.MODULE$.expandEnvironment(ApplicationConstants.Environment.PWD), fileName})), env);
    }

    public void org$apache$spark$deploy$yarn$Client$$addClasspathEntry(String path, HashMap<String, String> env) {
        YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment(env, ApplicationConstants.Environment.CLASSPATH.name(), path);
    }

    public String getClusterPath(SparkConf conf, String path) {
        String localPath = (String)conf.get(package$.MODULE$.GATEWAY_ROOT_PATH());
        String clusterPath = (String)conf.get(package$.MODULE$.REPLACEMENT_ROOT_PATH());
        return localPath == null || clusterPath == null ? path : path.replace(localPath, clusterPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean org$apache$spark$deploy$yarn$Client$$compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) return false;
        String string = srcUri.getScheme();
        String string2 = dstUri.getScheme();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            String string3 = srcHost;
            String string4 = dstHost;
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                try {
                    srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                    dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    return false;
                }
            }
        }
        if (!Objects.equal((Object)srcHost, (Object)dstHost)) return false;
        if (srcUri.getPort() != dstUri.getPort()) return false;
        return true;
    }

    public Path org$apache$spark$deploy$yarn$Client$$getQualifiedLocalPath(URI localURI, Configuration hadoopConf) {
        URI qualifiedURI = localURI.getScheme() == null ? new URI(FileSystem.getLocal((Configuration)hadoopConf).makeQualified(new Path(localURI)).toString()) : localURI;
        return new Path(qualifiedURI);
    }

    public boolean isUserClassPathFirst(SparkConf conf, boolean isDriver) {
        return isDriver ? BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_USER_CLASS_PATH_FIRST())) : BoxesRunTime.unboxToBoolean((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_USER_CLASS_PATH_FIRST()));
    }

    public String buildPath(Seq<String> components) {
        return components.mkString("/");
    }

    public boolean isLocalUri(String uri) {
        return uri.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.LOCAL_SCHEME()})));
    }

    private Client$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.APP_JAR_NAME = "__app__.jar";
        this.LOCAL_SCHEME = "local";
        this.SPARK_STAGING = ".sparkStaging";
        this.STAGING_DIR_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("700", 8)));
        this.APP_FILE_PERMISSION = FsPermission.createImmutable((short)((short)Integer.parseInt("644", 8)));
        this.ENV_DIST_CLASSPATH = "SPARK_DIST_CLASSPATH";
        this.LOCALIZED_CONF_DIR = "__spark_conf__";
        this.LOCALIZED_CONF_ARCHIVE = new StringBuilder().append((Object)this.LOCALIZED_CONF_DIR()).append((Object)".zip").toString();
        this.SPARK_CONF_FILE = "__spark_conf__.properties";
        this.LOCALIZED_PYTHON_DIR = "__pyfiles__";
        this.LOCALIZED_LIB_DIR = "__spark_libs__";
    }
}

