/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo;

import com.google.common.base.Objects;
import org.apache.tajo.QueryId;
import org.apache.tajo.QueryIdFactory;
import org.apache.tajo.TajoIdProtos;

public class ExecutionBlockId
implements Comparable<ExecutionBlockId> {
    public static final String EB_ID_PREFIX = "eb";
    private QueryId queryId;
    private int id;

    public ExecutionBlockId(QueryId queryId, int id) {
        this.queryId = queryId;
        this.id = id;
    }

    public ExecutionBlockId(TajoIdProtos.ExecutionBlockIdProto proto) {
        this(new QueryId(proto.getQueryId()), proto.getId());
    }

    public String toString() {
        return "eb_" + this.toStringNoPrefix();
    }

    @Override
    public int compareTo(ExecutionBlockId executionBlockId) {
        int result = this.queryId.compareTo(executionBlockId.queryId);
        if (result == 0) {
            return this.id - executionBlockId.id;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExecutionBlockId)) {
            return false;
        }
        return this.compareTo((ExecutionBlockId)obj) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.queryId, this.id});
    }

    public TajoIdProtos.ExecutionBlockIdProto getProto() {
        return TajoIdProtos.ExecutionBlockIdProto.newBuilder().setQueryId(this.queryId.getProto()).setId(this.id).build();
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public int getId() {
        return this.id;
    }

    public String toStringNoPrefix() {
        return this.queryId.toStringNoPrefix() + "_" + QueryIdFactory.EB_ID_FORMAT.format(this.id);
    }
}

