/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.ConfigKey;
import org.apache.tajo.SessionVars;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;
import org.apache.tajo.util.KeyValueSet;

public class OverridableConf
extends KeyValueSet {
    private static final Log LOG = LogFactory.getLog(OverridableConf.class);
    private ConfigKey.ConfigType[] configTypes;
    protected TajoConf conf;

    public OverridableConf(TajoConf conf, ConfigKey.ConfigType ... configTypes) {
        this.conf = conf;
        this.configTypes = configTypes;
    }

    public OverridableConf(TajoConf conf, PrimitiveProtos.KeyValueSetProto proto, ConfigKey.ConfigType ... configTypes) {
        super(proto);
        this.conf = conf;
        this.configTypes = configTypes;
    }

    public void setConf(TajoConf conf) {
        this.conf = conf;
    }

    public TajoConf getConf() {
        return this.conf;
    }

    public void setBool(ConfigKey key, boolean val) {
        this.setBool(key.keyname(), val);
    }

    public boolean getBool(ConfigKey key, Boolean defaultVal) {
        this.assertRegisteredEnum(key);
        if (key.type() != ConfigKey.ConfigType.SESSION && key.type() != ConfigKey.ConfigType.SYSTEM) {
            return this.getBool(key.keyname(), defaultVal);
        }
        switch (key.type()) {
            case QUERY: {
                return this.getBool(key.keyname());
            }
            case SESSION: {
                return this.getBool(key.keyname(), (Boolean)this.conf.getBoolVar(((SessionVars)key).getConfVars()));
            }
            case SYSTEM: {
                return this.conf.getBoolVar((TajoConf.ConfVars)key);
            }
        }
        throw new IllegalStateException("key does not belong to Session and System config sets");
    }

    @Override
    public boolean getBool(ConfigKey key) {
        return this.getBool(key, null);
    }

    public void setInt(ConfigKey key, int val) {
        this.setInt(key.keyname(), val);
    }

    public int getInt(ConfigKey key, Integer defaultVal) {
        this.assertRegisteredEnum(key);
        if (key.type() != ConfigKey.ConfigType.SESSION && key.type() != ConfigKey.ConfigType.SYSTEM) {
            return this.getInt(key.keyname(), defaultVal);
        }
        switch (key.type()) {
            case SESSION: {
                return this.getInt(key.keyname(), (Integer)this.conf.getIntVar(((SessionVars)key).getConfVars()));
            }
            case SYSTEM: {
                return this.conf.getIntVar((TajoConf.ConfVars)key);
            }
        }
        throw new IllegalStateException("key does not belong to Session and System config sets");
    }

    @Override
    public int getInt(ConfigKey key) {
        return this.getInt(key, null);
    }

    public void setLong(ConfigKey key, long val) {
        this.setLong(key.keyname(), val);
    }

    public long getLong(ConfigKey key, Long defaultVal) {
        this.assertRegisteredEnum(key);
        if (key.type() != ConfigKey.ConfigType.SESSION && key.type() != ConfigKey.ConfigType.SYSTEM) {
            return this.getLong(key.keyname(), defaultVal);
        }
        switch (key.type()) {
            case SESSION: {
                return this.getLong(key.keyname(), (Long)this.conf.getLongVar(((SessionVars)key).getConfVars()));
            }
            case SYSTEM: {
                return this.conf.getLongVar((TajoConf.ConfVars)key);
            }
        }
        throw new IllegalStateException("key does not belong to Session and System config sets");
    }

    @Override
    public long getLong(ConfigKey key) {
        return this.getLong(key, null);
    }

    public void setFloat(ConfigKey key, float val) {
        this.setFloat(key.keyname(), val);
    }

    public float getFloat(ConfigKey key, Float defaultVal) {
        this.assertRegisteredEnum(key);
        if (key.type() != ConfigKey.ConfigType.SESSION && key.type() != ConfigKey.ConfigType.SYSTEM) {
            return this.getFloat(key.keyname(), defaultVal);
        }
        switch (key.type()) {
            case SESSION: {
                return this.getFloat(key.keyname(), Float.valueOf(this.conf.getFloatVar(((SessionVars)key).getConfVars())));
            }
            case SYSTEM: {
                return this.conf.getFloatVar((TajoConf.ConfVars)key);
            }
        }
        throw new IllegalStateException("key does not belong to Session and System config sets");
    }

    @Override
    public float getFloat(ConfigKey key) {
        return this.getFloat(key, null);
    }

    public void put(ConfigKey key, String val) {
        this.set(key.keyname(), val);
    }

    private void assertRegisteredEnum(ConfigKey key) {
        boolean registered = false;
        if (this.configTypes != null) {
            for (ConfigKey.ConfigType c : this.configTypes) {
                registered = key.type() == c;
            }
        }
        Preconditions.checkArgument((boolean)(registered |= key.type() == ConfigKey.ConfigType.SESSION || key.type() != ConfigKey.ConfigType.SYSTEM), (Object)(key.keyname() + " (" + (Object)((Object)key.type()) + ") is not allowed in " + this.getClass().getSimpleName()));
    }

    public String get(ConfigKey key, String defaultVal) {
        this.assertRegisteredEnum(key);
        if (key.type() != ConfigKey.ConfigType.SESSION && key.type() != ConfigKey.ConfigType.SYSTEM) {
            return this.get(key.keyname(), defaultVal);
        }
        switch (key.type()) {
            case SESSION: {
                return this.get(key.keyname(), this.conf.getVar(((SessionVars)key).getConfVars()));
            }
            case SYSTEM: {
                return this.conf.getVar((TajoConf.ConfVars)key);
            }
        }
        throw new IllegalStateException("key does not belong to Session and System config sets");
    }

    public String get(ConfigKey key) {
        return this.get(key, null);
    }

    public Class<?> getClass(ConfigKey key) {
        this.assertRegisteredEnum(key);
        String className = this.getTrimmed(key);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTrimmed(ConfigKey key) {
        String value = this.get(key);
        if (null == value) {
            return null;
        }
        return value.trim();
    }

    public boolean containsKey(ConfigKey key) {
        return this.containsKey(key.keyname());
    }

    public boolean equalKey(ConfigKey key, String another) {
        if (this.containsKey(key)) {
            return this.get(key).equals(another);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.conf == null ? 0 : ((Object)((Object)this.conf)).hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.configTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

