/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tajo.ExecutionBlockId;
import org.apache.tajo.QueryId;
import org.apache.tajo.TaskAttemptId;
import org.apache.tajo.TaskId;
import org.apache.tajo.util.TajoIdUtils;

public class QueryIdFactory {
    public static final QueryId NULL_QUERY_ID = QueryIdFactory.newQueryId(TajoIdUtils.MASTER_ID_FORMAT.format(0L), 0);
    public static final DecimalFormat ID_FORMAT = new DecimalFormat("0000");
    public static final DecimalFormat EB_ID_FORMAT = new DecimalFormat("000000");
    public static final DecimalFormat QU_ID_FORMAT = new DecimalFormat("000000");
    public static final DecimalFormat ATTEMPT_ID_FORMAT = new DecimalFormat("00");
    private static Map<String, AtomicInteger> queryNexIdMap = new HashMap<String, AtomicInteger>();
    private static AtomicInteger nextId = new AtomicInteger(0);

    public static synchronized QueryId newQueryId(String seedQueryId) {
        AtomicInteger queryNextId = queryNexIdMap.get(seedQueryId);
        if (queryNextId == null) {
            queryNextId = new AtomicInteger(0);
            queryNexIdMap.put(seedQueryId, queryNextId);
        }
        if (QueryIdFactory.isYarnId(seedQueryId)) {
            String[] tokens = seedQueryId.split("_");
            return new QueryId(tokens[1], Integer.parseInt(tokens[2]));
        }
        int seq = queryNextId.incrementAndGet();
        if (seq >= 10000) {
            queryNextId.set(0);
            seq = queryNextId.incrementAndGet();
        }
        return new QueryId(seedQueryId, seq);
    }

    public static synchronized QueryId newQueryId(long timestamp, int seq) {
        return new QueryId(String.valueOf(timestamp), seq);
    }

    public static synchronized QueryId newQueryId(String seedQueryId, int seq) {
        if (QueryIdFactory.isYarnId(seedQueryId)) {
            String[] tokens = seedQueryId.split("_");
            return new QueryId(tokens[1], Integer.parseInt(tokens[2]));
        }
        return new QueryId(seedQueryId, seq);
    }

    private static boolean isYarnId(String id) {
        return id.startsWith("application");
    }

    public static synchronized ExecutionBlockId newExecutionBlockId(QueryId queryId) {
        return new ExecutionBlockId(queryId, nextId.incrementAndGet());
    }

    public static synchronized ExecutionBlockId newExecutionBlockId(QueryId queryId, int id) {
        return new ExecutionBlockId(queryId, id);
    }

    public static synchronized TaskId newTaskId(ExecutionBlockId executionBlockId) {
        return new TaskId(executionBlockId, nextId.incrementAndGet());
    }

    public static synchronized TaskId newTaskId(ExecutionBlockId executionBlockId, int id) {
        return new TaskId(executionBlockId, id);
    }

    public static synchronized TaskAttemptId newTaskAttemptId(TaskId taskId, int attemptId) {
        return new TaskAttemptId(taskId, attemptId);
    }
}

