/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo;

import com.google.common.base.Objects;
import org.apache.tajo.QueryIdFactory;
import org.apache.tajo.TajoIdProtos;
import org.apache.tajo.TaskId;

public class TaskAttemptId
implements Comparable<TaskAttemptId> {
    public static final String QUA_ID_PREFIX = "ta";
    private TaskId taskId;
    private int id;
    private final int hashValue;

    public TaskId getTaskId() {
        return this.taskId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public TaskAttemptId(TaskId taskId, int id) {
        this.taskId = taskId;
        this.id = id;
        this.hashValue = Objects.hashCode((Object[])new Object[]{taskId, id});
    }

    public TaskAttemptId(TajoIdProtos.TaskAttemptIdProto proto) {
        this(new TaskId(proto.getTaskId()), proto.getId());
    }

    public TajoIdProtos.TaskAttemptIdProto getProto() {
        return TajoIdProtos.TaskAttemptIdProto.newBuilder().setTaskId(this.taskId.getProto()).setId(this.id).build();
    }

    @Override
    public int compareTo(TaskAttemptId taskAttemptId) {
        int result = this.taskId.compareTo(taskAttemptId.taskId);
        if (result == 0) {
            return this.id - taskAttemptId.id;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskAttemptId)) {
            return false;
        }
        return this.compareTo((TaskAttemptId)obj) == 0;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public String toString() {
        return "ta_" + this.toStringNoPrefix();
    }

    public String toStringNoPrefix() {
        return this.taskId.toStringNoPrefix() + "_" + QueryIdFactory.ATTEMPT_ID_FORMAT.format(this.id);
    }
}

