/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo;

import com.google.common.base.Objects;
import org.apache.tajo.ExecutionBlockId;
import org.apache.tajo.QueryIdFactory;
import org.apache.tajo.TajoIdProtos;

public class TaskId
implements Comparable<TaskId> {
    public static final String QU_ID_PREFIX = "t";
    private ExecutionBlockId executionBlockId;
    private int id;
    private final int hashValue;

    public TaskId(ExecutionBlockId executionBlockId, int id) {
        this.executionBlockId = executionBlockId;
        this.id = id;
        this.hashValue = Objects.hashCode((Object[])new Object[]{executionBlockId, id});
    }

    public TaskId(TajoIdProtos.TaskIdProto proto) {
        this(new ExecutionBlockId(proto.getExecutionBlockId()), proto.getId());
    }

    public ExecutionBlockId getExecutionBlockId() {
        return this.executionBlockId;
    }

    public int getId() {
        return this.id;
    }

    public TajoIdProtos.TaskIdProto getProto() {
        return TajoIdProtos.TaskIdProto.newBuilder().setExecutionBlockId(this.executionBlockId.getProto()).setId(this.id).build();
    }

    @Override
    public int compareTo(TaskId taskId) {
        int result = this.executionBlockId.compareTo(taskId.executionBlockId);
        if (result == 0) {
            return this.id - taskId.id;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaskId)) {
            return false;
        }
        return this.compareTo((TaskId)obj) == 0;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public String toString() {
        return "t_" + this.toStringNoPrefix();
    }

    public String toStringNoPrefix() {
        return this.executionBlockId.toStringNoPrefix() + "_" + QueryIdFactory.QU_ID_FORMAT.format(this.id);
    }
}

