/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.common.type;

import java.util.ArrayList;
import java.util.List;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.BooleanDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.Int2Datum;
import org.apache.tajo.datum.Int4Datum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TextDatum;

public class TajoTypeUtil {
    private static List<Datum[]> typeInfos = new ArrayList<Datum[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Datum[]> getTypeInfos() {
        List<Datum[]> list = typeInfos;
        synchronized (list) {
            if (typeInfos.isEmpty()) {
                for (TajoDataTypes.Type eachType : TajoDataTypes.Type.values()) {
                    if (!TajoTypeUtil.isUserDataType(eachType)) continue;
                    Datum[] datums = new Datum[18];
                    int index = 0;
                    datums[index++] = new TextDatum(eachType.name());
                    datums[index++] = new Int2Datum((short)TajoTypeUtil.getJavaSqlType(eachType));
                    datums[index++] = new Int4Datum(TajoTypeUtil.getPrecision(eachType));
                    datums[index++] = new TextDatum(TajoTypeUtil.getLiteralPrefix(eachType));
                    datums[index++] = new TextDatum(TajoTypeUtil.getLiteralPrefix(eachType));
                    datums[index++] = new TextDatum("");
                    datums[index++] = new Int2Datum(1);
                    datums[index++] = BooleanDatum.TRUE;
                    datums[index++] = new Int2Datum(TajoTypeUtil.getSearchable(eachType));
                    datums[index++] = BooleanDatum.FALSE;
                    datums[index++] = BooleanDatum.FALSE;
                    datums[index++] = BooleanDatum.FALSE;
                    datums[index++] = new TextDatum(eachType.name());
                    datums[index++] = new Int2Datum(0);
                    datums[index++] = new Int2Datum(0);
                    datums[index++] = NullDatum.get();
                    datums[index++] = NullDatum.get();
                    datums[index++] = new Int4Datum(TajoTypeUtil.getNumPrecRadix(eachType));
                    typeInfos.add(datums);
                }
            }
            return typeInfos;
        }
    }

    public static boolean isUserDataType(TajoDataTypes.Type type) {
        switch (type) {
            case INT1: 
            case INT2: 
            case INT4: 
            case INT8: 
            case FLOAT4: 
            case FLOAT8: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case NUMERIC: 
            case VARCHAR: 
            case TEXT: {
                return true;
            }
        }
        return false;
    }

    public static int getJavaSqlType(TajoDataTypes.Type type) {
        switch (type) {
            case INT1: {
                return -6;
            }
            case INT2: {
                return 5;
            }
            case INT4: {
                return 4;
            }
            case INT8: {
                return -5;
            }
            case FLOAT4: {
                return 6;
            }
            case FLOAT8: {
                return 8;
            }
            case VARCHAR: 
            case TEXT: {
                return 12;
            }
            case DATE: {
                return 91;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: {
                return 93;
            }
            case NUMERIC: {
                return 3;
            }
        }
        return 12;
    }

    public static int getPrecision(TajoDataTypes.Type type) {
        switch (type) {
            case INT1: {
                return 3;
            }
            case INT2: {
                return 5;
            }
            case INT4: {
                return 10;
            }
            case INT8: {
                return 19;
            }
            case FLOAT4: {
                return 7;
            }
            case FLOAT8: {
                return 15;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static String getLiteralPrefix(TajoDataTypes.Type type) {
        switch (type) {
            case VARCHAR: 
            case TEXT: {
                return "'";
            }
        }
        return "";
    }

    public static short getSearchable(TajoDataTypes.Type type) {
        switch (type) {
            case INT1: 
            case INT2: 
            case INT4: 
            case INT8: 
            case FLOAT4: 
            case FLOAT8: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case NUMERIC: {
                return 2;
            }
            case VARCHAR: 
            case TEXT: {
                return 3;
            }
        }
        return 2;
    }

    public static int getNumPrecRadix(TajoDataTypes.Type type) {
        switch (type) {
            case INT1: 
            case INT2: 
            case INT4: 
            case INT8: {
                return 10;
            }
            case FLOAT4: 
            case FLOAT8: {
                return 2;
            }
        }
        return 0;
    }

    public static boolean isSigned(TajoDataTypes.Type type) {
        switch (type) {
            case INT1: 
            case INT2: 
            case INT4: 
            case INT8: 
            case FLOAT4: 
            case FLOAT8: {
                return true;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case VARCHAR: 
            case TEXT: {
                return false;
            }
        }
        return true;
    }
}

