/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.gson.annotations.Expose;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.util.NumberUtil;

public class BitDatum
extends Datum {
    private static final int size = 1;
    @Expose
    final byte val;

    public BitDatum(byte val) {
        super(TajoDataTypes.Type.BIT);
        this.val = val;
    }

    public BitDatum(byte[] bytes) {
        this(bytes[0]);
    }

    @Override
    public char asChar() {
        return (char)this.val;
    }

    @Override
    public int asInt4() {
        return this.val;
    }

    @Override
    public long asInt8() {
        return this.val;
    }

    @Override
    public byte asByte() {
        return this.val;
    }

    @Override
    public byte[] asByteArray() {
        byte[] bytes = new byte[]{this.val};
        return bytes;
    }

    @Override
    public float asFloat4() {
        return this.val;
    }

    @Override
    public double asFloat8() {
        return this.val;
    }

    @Override
    public String asChars() {
        return "0x" + this.val;
    }

    @Override
    public byte[] asTextBytes() {
        return NumberUtil.toAsciiBytes(this.asInt4());
    }

    @Override
    public int size() {
        return 1;
    }

    public int hashCode() {
        return this.val;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitDatum) {
            BitDatum other = (BitDatum)obj;
            return this.val == other.val;
        }
        return false;
    }

    @Override
    public Datum equalsTo(Datum datum) {
        switch (datum.type()) {
            case BIT: {
                return DatumFactory.createBool(this.val == ((BitDatum)datum).val);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        switch (datum.type()) {
            case BIT: {
                if (this.val < datum.asByte()) {
                    return -1;
                }
                if (this.val > datum.asByte()) {
                    return 1;
                }
                return 0;
            }
            case NULL_TYPE: {
                return -1;
            }
        }
        throw new InvalidOperationException(datum.type());
    }
}

