/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.exception.InvalidOperationException;

public class BlobDatum
extends Datum {
    @Expose
    private final byte[] val;
    private ByteBuffer bb = null;

    public BlobDatum(byte[] val) {
        super(TajoDataTypes.Type.BLOB);
        this.val = val;
        this.bb = ByteBuffer.wrap(val);
        this.bb.flip();
    }

    public BlobDatum(byte[] val, int offset, int length) {
        super(TajoDataTypes.Type.BLOB);
        byte[] b = new byte[length];
        System.arraycopy(val, offset, b, 0, length);
        this.val = b;
        this.bb = ByteBuffer.wrap(b);
        this.bb.flip();
    }

    public BlobDatum(ByteBuffer val) {
        super(TajoDataTypes.Type.BLOB);
        this.val = val.array();
        this.bb = val.duplicate();
        this.bb.flip();
    }

    public void initFromBytes() {
        if (this.bb == null) {
            this.bb = ByteBuffer.wrap(this.val);
        }
    }

    @Override
    public int asInt4() {
        this.initFromBytes();
        this.bb.rewind();
        return this.bb.getInt();
    }

    @Override
    public long asInt8() {
        this.initFromBytes();
        this.bb.rewind();
        return this.bb.getLong();
    }

    @Override
    public byte asByte() {
        this.initFromBytes();
        this.bb.rewind();
        return this.bb.get();
    }

    @Override
    public byte[] asByteArray() {
        this.initFromBytes();
        this.bb.rewind();
        return this.bb.array();
    }

    @Override
    public float asFloat4() {
        this.initFromBytes();
        this.bb.rewind();
        return this.bb.getFloat();
    }

    @Override
    public double asFloat8() {
        this.initFromBytes();
        this.bb.rewind();
        return this.bb.getDouble();
    }

    @Override
    public String asChars() {
        this.initFromBytes();
        this.bb.rewind();
        return new String(this.bb.array(), Charset.defaultCharset());
    }

    @Override
    public int size() {
        return this.val.length;
    }

    public int hashCode() {
        this.initFromBytes();
        this.bb.rewind();
        return this.bb.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlobDatum) {
            BlobDatum other = (BlobDatum)obj;
            this.initFromBytes();
            other.initFromBytes();
            return Arrays.equals(this.val, other.val);
        }
        return false;
    }

    @Override
    public Datum equalsTo(Datum datum) {
        switch (datum.type()) {
            case BLOB: {
                return DatumFactory.createBool(Arrays.equals(this.val, ((BlobDatum)datum).val));
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        switch (datum.type()) {
            case BLOB: {
                this.initFromBytes();
                ((BlobDatum)datum).initFromBytes();
                return this.bb.compareTo(((BlobDatum)datum).bb);
            }
            case NULL_TYPE: {
                return -1;
            }
        }
        throw new InvalidOperationException(datum.type());
    }
}

