/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.primitives.Booleans;
import com.google.gson.annotations.Expose;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.exception.InvalidOperationException;

public class BooleanDatum
extends Datum {
    @Expose
    private final boolean val;
    public static final String TRUE_STRING = "t";
    public static final String FALSE_STRING = "f";
    public static final BooleanDatum TRUE = new BooleanDatum(true);
    public static final BooleanDatum FALSE = new BooleanDatum(false);
    public static final byte UNKNOWN_INT = 0;
    public static final byte TRUE_INT = 1;
    public static final byte FALSE_INT = 2;
    public static final byte[] TRUE_BYTES = new byte[]{1};
    public static final byte[] FALSE_BYTES = new byte[]{2};
    public static final Datum[] THREE_VALUES = new Datum[]{NullDatum.get(), TRUE, FALSE};
    public static final Datum[][] AND_LOGIC = new Datum[][]{{NullDatum.get(), NullDatum.get(), FALSE}, {NullDatum.get(), TRUE, FALSE}, {FALSE, FALSE, FALSE}};
    public static final Datum[][] OR_LOGIC = new Datum[][]{{NullDatum.get(), TRUE, NullDatum.get()}, {TRUE, TRUE, TRUE}, {NullDatum.get(), TRUE, FALSE}};

    private BooleanDatum(boolean val) {
        super(TajoDataTypes.Type.BOOLEAN);
        this.val = val;
    }

    protected BooleanDatum(byte byteVal) {
        super(TajoDataTypes.Type.BOOLEAN);
        this.val = byteVal == 1;
    }

    protected BooleanDatum(int byteVal) {
        super(TajoDataTypes.Type.BOOLEAN);
        this.val = byteVal == 1;
    }

    protected BooleanDatum(byte[] bytes) {
        this(bytes[0]);
    }

    @Override
    public boolean asBool() {
        return this.val;
    }

    @Override
    public char asChar() {
        return this.val ? (char)'t' : 'f';
    }

    @Override
    public short asInt2() {
        return (short)(this.val ? 1 : 2);
    }

    @Override
    public int asInt4() {
        return this.val ? 1 : 2;
    }

    @Override
    public long asInt8() {
        return this.val ? 1L : 2L;
    }

    @Override
    public byte asByte() {
        return this.val ? (byte)1 : 2;
    }

    @Override
    public byte[] asByteArray() {
        return this.val ? TRUE_BYTES : FALSE_BYTES;
    }

    @Override
    public float asFloat4() {
        return this.val ? 1.0f : 2.0f;
    }

    @Override
    public double asFloat8() {
        return this.val ? 1.0 : 2.0;
    }

    @Override
    public String asChars() {
        return this.val ? TRUE_STRING : FALSE_STRING;
    }

    @Override
    public Datum and(Datum datum) {
        return AND_LOGIC[this.asInt4()][datum.asInt4()];
    }

    @Override
    public Datum or(Datum datum) {
        return OR_LOGIC[this.asInt4()][datum.asInt4()];
    }

    @Override
    public int size() {
        return 1;
    }

    public int hashCode() {
        return this.val ? 7907 : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanDatum) {
            BooleanDatum other = (BooleanDatum)obj;
            return this.val == other.val;
        }
        return false;
    }

    @Override
    public BooleanDatum equalsTo(Datum datum) {
        switch (datum.type()) {
            case BOOLEAN: {
                return DatumFactory.createBool(this.val == ((BooleanDatum)datum).val);
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        switch (datum.type()) {
            case BOOLEAN: {
                return Booleans.compare((boolean)this.val, (boolean)datum.asBool());
            }
        }
        throw new InvalidOperationException(datum.type());
    }
}

