/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.primitives.UnsignedBytes;
import com.google.gson.annotations.Expose;
import java.util.Arrays;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.exception.InvalidOperationException;

public class CharDatum
extends Datum {
    @Expose
    private final int size;
    @Expose
    private final byte[] bytes;
    private String chars = null;

    public CharDatum(byte val) {
        super(TajoDataTypes.Type.CHAR);
        this.size = 1;
        this.bytes = new byte[this.size];
        this.bytes[0] = val;
    }

    public CharDatum(char val) {
        this((byte)val);
    }

    public CharDatum(byte[] bytes) {
        super(TajoDataTypes.Type.CHAR);
        this.bytes = bytes;
        this.size = bytes.length;
    }

    public CharDatum(String val) {
        this(val.getBytes());
    }

    private String getString() {
        if (this.chars == null) {
            this.chars = new String(this.bytes);
        }
        return this.chars;
    }

    @Override
    public char asChar() {
        return this.getString().charAt(0);
    }

    @Override
    public short asInt2() {
        return Short.valueOf(this.getString());
    }

    @Override
    public int asInt4() {
        return Integer.parseInt(this.getString());
    }

    @Override
    public long asInt8() {
        return Long.parseLong(this.getString());
    }

    @Override
    public byte[] asByteArray() {
        return this.bytes;
    }

    @Override
    public float asFloat4() {
        return Float.valueOf(this.getString()).floatValue();
    }

    @Override
    public double asFloat8() {
        return Double.valueOf(this.getString());
    }

    @Override
    public byte asByte() {
        return this.bytes[0];
    }

    @Override
    public String asChars() {
        return this.getString();
    }

    @Override
    public int size() {
        return this.size;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharDatum) {
            CharDatum other = (CharDatum)obj;
            return this.size == other.size && Arrays.equals(this.bytes, other.bytes);
        }
        return false;
    }

    @Override
    public Datum equalsTo(Datum datum) {
        switch (datum.type()) {
            case CHAR: 
            case VARCHAR: 
            case TEXT: {
                return DatumFactory.createBool(TextDatum.COMPARATOR.compare(this.bytes, datum.asTextBytes()) == 0);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        switch (datum.type()) {
            case CHAR: 
            case TEXT: {
                return UnsignedBytes.lexicographicalComparator().compare(this.bytes, datum.asByteArray());
            }
            case NULL_TYPE: {
                return -1;
            }
        }
        throw new InvalidOperationException(datum.type());
    }
}

