/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.DateDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.NumericDatum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.exception.InvalidValueForCastException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.util.MurmurHash;
import org.apache.tajo.util.NumberUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public class Float4Datum
extends NumericDatum {
    private static final int size = 4;
    @Expose
    final float val;

    public Float4Datum(float val) {
        super(TajoDataTypes.Type.FLOAT4);
        this.val = val;
    }

    public Float4Datum(byte[] bytes) {
        super(TajoDataTypes.Type.FLOAT4);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        this.val = bb.getFloat();
    }

    @Override
    public boolean asBool() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.FLOAT4, TajoDataTypes.Type.BOOLEAN));
    }

    @Override
    public char asChar() {
        return this.asChars().charAt(0);
    }

    @Override
    public short asInt2() {
        return (short)this.val;
    }

    @Override
    public int asInt4() {
        return (int)this.val;
    }

    @Override
    public long asInt8() {
        return (long)this.val;
    }

    @Override
    public byte asByte() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.FLOAT4, TajoDataTypes.Type.BIT));
    }

    @Override
    public byte[] asByteArray() {
        ByteBuffer bb = ByteBuffer.allocate(4);
        bb.putFloat(this.val);
        return bb.array();
    }

    @Override
    public float asFloat4() {
        return this.val;
    }

    @Override
    public double asFloat8() {
        return this.val;
    }

    @Override
    public String asChars() {
        return "" + this.val;
    }

    @Override
    public byte[] asTextBytes() {
        return NumberUtil.toAsciiBytes(this.val);
    }

    @Override
    public int size() {
        return 4;
    }

    public int hashCode() {
        return MurmurHash.hash(Float.valueOf(this.val));
    }

    public boolean equals(Object obj) {
        if (obj instanceof Float4Datum) {
            Float4Datum other = (Float4Datum)obj;
            return this.val == other.val;
        }
        return false;
    }

    @Override
    public Datum equalsTo(Datum datum) {
        switch (datum.type()) {
            case INT2: {
                return DatumFactory.createBool(this.val == (float)datum.asInt2());
            }
            case INT4: {
                return DatumFactory.createBool(this.val == (float)datum.asInt4());
            }
            case INT8: {
                return DatumFactory.createBool(this.val == (float)datum.asInt8());
            }
            case FLOAT4: {
                return DatumFactory.createBool(this.val == datum.asFloat4());
            }
            case FLOAT8: {
                return DatumFactory.createBool((double)this.val == datum.asFloat8());
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        switch (datum.type()) {
            case INT2: {
                short another = datum.asInt2();
                if (this.val < (float)another) {
                    return -1;
                }
                if (this.val > (float)another) {
                    return 1;
                }
                return 0;
            }
            case INT4: {
                int another = datum.asInt4();
                if (this.val < (float)another) {
                    return -1;
                }
                if (this.val > (float)another) {
                    return 1;
                }
                return 0;
            }
            case INT8: {
                long another = datum.asInt8();
                if (this.val < (float)another) {
                    return -1;
                }
                if (this.val > (float)another) {
                    return 1;
                }
                return 0;
            }
            case FLOAT4: {
                float another = datum.asFloat4();
                if (this.val < another) {
                    return -1;
                }
                if (this.val > another) {
                    return 1;
                }
                return 0;
            }
            case FLOAT8: {
                double another = datum.asFloat8();
                if ((double)this.val < another) {
                    return -1;
                }
                if ((double)this.val > another) {
                    return 1;
                }
                return 0;
            }
            case NULL_TYPE: {
                return -1;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum plus(Datum datum) {
        switch (datum.type()) {
            case INT2: {
                return DatumFactory.createFloat4(this.val + (float)datum.asInt2());
            }
            case INT4: {
                return DatumFactory.createFloat4(this.val + (float)datum.asInt4());
            }
            case INT8: {
                return DatumFactory.createFloat4(this.val + (float)datum.asInt8());
            }
            case FLOAT4: {
                return DatumFactory.createFloat4(this.val + datum.asFloat4());
            }
            case FLOAT8: {
                return DatumFactory.createFloat8((double)this.val + datum.asFloat8());
            }
            case DATE: {
                TimeMeta tm = datum.asTimeMeta();
                tm.plusDays(this.asInt4());
                return new DateDatum(tm);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum minus(Datum datum) {
        switch (datum.type()) {
            case INT2: {
                return DatumFactory.createFloat4(this.val - (float)datum.asInt2());
            }
            case INT4: {
                return DatumFactory.createFloat4(this.val - (float)datum.asInt4());
            }
            case INT8: {
                return DatumFactory.createFloat4(this.val - (float)datum.asInt8());
            }
            case FLOAT4: {
                return DatumFactory.createFloat4(this.val - datum.asFloat4());
            }
            case FLOAT8: {
                return DatumFactory.createFloat8((double)this.val - datum.asFloat8());
            }
            case DATE: {
                TimeMeta tm = datum.asTimeMeta();
                tm.plusDays(0 - this.asInt4());
                return new DateDatum(tm);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum multiply(Datum datum) {
        switch (datum.type()) {
            case INT2: {
                return DatumFactory.createFloat4(this.val * (float)datum.asInt2());
            }
            case INT4: {
                return DatumFactory.createFloat4(this.val * (float)datum.asInt4());
            }
            case INT8: {
                return DatumFactory.createFloat4(this.val * (float)datum.asInt8());
            }
            case FLOAT4: {
                return DatumFactory.createFloat4(this.val * datum.asFloat4());
            }
            case FLOAT8: {
                return DatumFactory.createFloat8((double)this.val * datum.asFloat8());
            }
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)datum;
                return new IntervalDatum((int)((float)interval.getMonths() * this.val), (long)((float)interval.getMilliSeconds() * this.val));
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum divide(Datum datum) {
        switch (datum.type()) {
            case INT2: {
                short paramValueI2 = datum.asInt2();
                if (!this.validateDivideZero(paramValueI2)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val / (float)paramValueI2);
            }
            case INT4: {
                int paramValueI4 = datum.asInt4();
                if (!this.validateDivideZero(paramValueI4)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val / (float)paramValueI4);
            }
            case INT8: {
                long paramValueI8 = datum.asInt8();
                if (!this.validateDivideZero(paramValueI8)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val / (float)paramValueI8);
            }
            case FLOAT4: {
                float paramValueF4 = datum.asFloat4();
                if (!this.validateDivideZero(paramValueF4)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val / paramValueF4);
            }
            case FLOAT8: {
                double paramValueF8 = datum.asFloat8();
                if (!this.validateDivideZero(paramValueF8)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat8((double)this.val / paramValueF8);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum modular(Datum datum) {
        switch (datum.type()) {
            case INT2: {
                short paramValueI2 = datum.asInt2();
                if (!this.validateDivideZero(paramValueI2)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val % (float)paramValueI2);
            }
            case INT4: {
                int paramValueI4 = datum.asInt4();
                if (!this.validateDivideZero(paramValueI4)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val % (float)paramValueI4);
            }
            case INT8: {
                long paramValueI8 = datum.asInt8();
                if (!this.validateDivideZero(paramValueI8)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val % (float)paramValueI8);
            }
            case FLOAT4: {
                float paramValueF4 = datum.asFloat4();
                if (!this.validateDivideZero(paramValueF4)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat4(this.val % paramValueF4);
            }
            case FLOAT8: {
                double paramValueF8 = datum.asFloat8();
                if (!this.validateDivideZero(paramValueF8)) {
                    return NullDatum.get();
                }
                return DatumFactory.createFloat8((double)this.val % paramValueF8);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public NumericDatum inverseSign() {
        return new Float4Datum(-this.val);
    }
}

