/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.primitives.UnsignedBytes;
import com.google.gson.annotations.Expose;
import java.nio.charset.Charset;
import java.util.Comparator;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.exception.InvalidValueForCastException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.util.MurmurHash;
import org.apache.tajo.util.StringUtils;

public class TextDatum
extends Datum {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    @Expose
    private final byte[] bytes;
    public static final int UNICODE_CHAR_BITS_NUM = 65535;
    public static final TextDatum EMPTY_TEXT = new TextDatum("");
    public static final Comparator<byte[]> COMPARATOR = UnsignedBytes.lexicographicalComparator();

    public TextDatum(byte[] bytes) {
        super(TajoDataTypes.Type.TEXT);
        this.bytes = bytes;
    }

    public TextDatum(String string) {
        this(string.getBytes(DEFAULT_CHARSET));
    }

    @Override
    public boolean asBool() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.TEXT, TajoDataTypes.Type.BOOLEAN));
    }

    @Override
    public byte asByte() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.TEXT, TajoDataTypes.Type.BIT));
    }

    @Override
    public short asInt2() {
        return Short.valueOf(new String(this.bytes));
    }

    @Override
    public int asInt4() {
        return Integer.parseInt(new String(this.bytes));
    }

    @Override
    public long asInt8() {
        return Long.parseLong(new String(this.bytes));
    }

    @Override
    public float asFloat4() {
        return Float.valueOf(new String(this.bytes)).floatValue();
    }

    @Override
    public double asFloat8() {
        return Double.valueOf(new String(this.bytes));
    }

    @Override
    public byte[] asByteArray() {
        return this.bytes;
    }

    @Override
    public String asChars() {
        return new String(this.bytes, DEFAULT_CHARSET);
    }

    @Override
    public char[] asUnicodeChars() {
        return StringUtils.convertBytesToChars(this.bytes, DEFAULT_CHARSET);
    }

    @Override
    public byte[] asTextBytes() {
        return this.bytes;
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public int compareTo(Datum datum) {
        switch (datum.type()) {
            case TEXT: 
            case CHAR: 
            case BLOB: {
                return COMPARATOR.compare(this.bytes, datum.asByteArray());
            }
            case NULL_TYPE: {
                return -1;
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextDatum) {
            TextDatum o = (TextDatum)obj;
            return COMPARATOR.compare(this.bytes, o.bytes) == 0;
        }
        return false;
    }

    @Override
    public Datum equalsTo(Datum datum) {
        switch (datum.type()) {
            case TEXT: 
            case CHAR: 
            case BLOB: {
                return DatumFactory.createBool(COMPARATOR.compare(this.bytes, datum.asByteArray()) == 0);
            }
            case NULL_TYPE: {
                return datum;
            }
        }
        throw new InvalidOperationException("Cannot equivalent check: " + (Object)((Object)this.type()) + " and " + (Object)((Object)datum.type()));
    }

    public int hashCode() {
        return MurmurHash.hash(this.bytes);
    }

    @Override
    public String toString() {
        return this.asChars();
    }
}

