/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.primitives.Longs;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.DateDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.exception.InvalidValueForCastException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.util.Bytes;
import org.apache.tajo.util.datetime.DateTimeConstants;
import org.apache.tajo.util.datetime.DateTimeUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public class TimeDatum
extends Datum {
    public static final int SIZE = 8;
    private final long time;

    public TimeDatum(long time) {
        super(TajoDataTypes.Type.TIME);
        this.time = time;
    }

    @Override
    public TimeMeta asTimeMeta() {
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.date2j(this.time, tm);
        return tm;
    }

    public int getHourOfDay() {
        TimeMeta tm = this.asTimeMeta();
        return tm.hours;
    }

    public int getMinuteOfHour() {
        TimeMeta tm = this.asTimeMeta();
        return tm.minutes;
    }

    public int getSecondOfMinute() {
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.date2j(this.time, tm);
        return tm.secs;
    }

    public int getMillisOfSecond() {
        TimeMeta tm = this.asTimeMeta();
        return tm.fsecs / 1000;
    }

    @Override
    public String toString() {
        return this.asChars();
    }

    @Override
    public int asInt4() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.TIME, TajoDataTypes.Type.INT4));
    }

    @Override
    public long asInt8() {
        return this.time;
    }

    @Override
    public float asFloat4() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.TIME, TajoDataTypes.Type.FLOAT4));
    }

    @Override
    public double asFloat8() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.TIME, TajoDataTypes.Type.FLOAT8));
    }

    @Override
    public String asChars() {
        TimeMeta tm = this.asTimeMeta();
        return DateTimeUtil.encodeTime(tm, DateTimeConstants.DateStyle.ISO_DATES);
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public byte[] asByteArray() {
        return Bytes.toBytes(this.asInt8());
    }

    @Override
    public Datum plus(Datum datum) {
        switch (datum.type()) {
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)datum;
                TimeMeta tm = this.asTimeMeta();
                tm.plusInterval(interval.months, interval.milliseconds);
                return new TimeDatum(DateTimeUtil.toTime(tm));
            }
            case DATE: {
                DateDatum dateDatum = (DateDatum)datum;
                TimeMeta dateTm = dateDatum.asTimeMeta();
                dateTm.plusTime(this.time);
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(dateTm));
            }
            case TIMESTAMP: {
                TimestampDatum timestampDatum = (TimestampDatum)datum;
                TimeMeta tm = timestampDatum.asTimeMeta();
                tm.plusTime(this.time);
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
            }
        }
        throw new InvalidOperationException("operator does not exist: " + (Object)((Object)this.type()) + " + " + (Object)((Object)datum.type()));
    }

    @Override
    public Datum minus(Datum datum) {
        switch (datum.type()) {
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)datum;
                TimeMeta tm = this.asTimeMeta();
                tm.plusInterval(-interval.months, -interval.milliseconds);
                return new TimeDatum(DateTimeUtil.toTime(tm));
            }
            case TIME: {
                return new IntervalDatum((this.time - ((TimeDatum)datum).time) / 1000L);
            }
        }
        throw new InvalidOperationException("operator does not exist: " + (Object)((Object)this.type()) + " - " + (Object)((Object)datum.type()));
    }

    @Override
    public Datum equalsTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.TIME) {
            return DatumFactory.createBool(this.time == ((TimeDatum)datum).time);
        }
        if (datum.isNull()) {
            return datum;
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.TIME) {
            TimeDatum another = (TimeDatum)datum;
            return Longs.compare((long)this.time, (long)another.time);
        }
        if (datum.isNull()) {
            return -1;
        }
        throw new InvalidOperationException(datum.type());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeDatum) {
            TimeDatum another = (TimeDatum)obj;
            return this.time == another.time;
        }
        return false;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.time);
    }
}

