/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.exception;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.util.StringUtils;
import org.apache.tajo.TajoConstants;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.AmbiguousColumnException;
import org.apache.tajo.exception.AmbiguousFunctionException;
import org.apache.tajo.exception.AmbiguousTableException;
import org.apache.tajo.exception.CannotDropCurrentDatabaseException;
import org.apache.tajo.exception.DataTypeMismatchException;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.DividedByZeroException;
import org.apache.tajo.exception.DuplicateColumnException;
import org.apache.tajo.exception.DuplicateDatabaseException;
import org.apache.tajo.exception.DuplicateIndexException;
import org.apache.tajo.exception.DuplicatePartitionException;
import org.apache.tajo.exception.DuplicateTableException;
import org.apache.tajo.exception.DuplicateTablespaceException;
import org.apache.tajo.exception.InsufficientPrivilegeException;
import org.apache.tajo.exception.InvalidDataTypeException;
import org.apache.tajo.exception.InvalidInputsForCrossJoin;
import org.apache.tajo.exception.InvalidSessionException;
import org.apache.tajo.exception.InvalidSessionVariableException;
import org.apache.tajo.exception.InvalidTablePropertyException;
import org.apache.tajo.exception.InvalidURLException;
import org.apache.tajo.exception.InvalidValueForCastException;
import org.apache.tajo.exception.MissingTablePropertyException;
import org.apache.tajo.exception.NoSuchSessionVariableException;
import org.apache.tajo.exception.NotImplementedException;
import org.apache.tajo.exception.QueryNotFoundException;
import org.apache.tajo.exception.ReturnStateUtil;
import org.apache.tajo.exception.SQLSyntaxError;
import org.apache.tajo.exception.TajoError;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.TooLargeInputForCrossJoinException;
import org.apache.tajo.exception.UnavailableTableLocationException;
import org.apache.tajo.exception.UndefinedColumnException;
import org.apache.tajo.exception.UndefinedDatabaseException;
import org.apache.tajo.exception.UndefinedFunctionException;
import org.apache.tajo.exception.UndefinedIndexException;
import org.apache.tajo.exception.UndefinedOperatorException;
import org.apache.tajo.exception.UndefinedPartitionException;
import org.apache.tajo.exception.UndefinedPartitionKeyException;
import org.apache.tajo.exception.UndefinedTableException;
import org.apache.tajo.exception.UndefinedTablespaceException;
import org.apache.tajo.exception.UndefinedTablespaceHandlerException;
import org.apache.tajo.exception.UnknownDataFormatException;
import org.apache.tajo.exception.UnsupportedCatalogStore;
import org.apache.tajo.exception.UnsupportedDataTypeException;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;

public class ExceptionUtil {
    static Map<Errors.ResultCode, Class<? extends DefaultTajoException>> EXCEPTIONS = Maps.newHashMap();

    private static void ADD_EXCEPTION(Errors.ResultCode code, Class<? extends DefaultTajoException> cls) {
        EXCEPTIONS.put(code, cls);
    }

    public static <T extends TajoException> void throwsIfThisError(PrimitiveProtos.ReturnState state, Class<T> clazz) throws T {
        TajoException exception;
        if (ReturnStateUtil.isError(state) && (exception = ExceptionUtil.toTajoException(state)).getClass().equals(clazz)) {
            throw exception;
        }
    }

    public static void throwIfError(PrimitiveProtos.ReturnState state) throws TajoException {
        if (ReturnStateUtil.isError(state)) {
            throw ExceptionUtil.toTajoException(state);
        }
    }

    public static DefaultTajoException toTajoExceptionCommon(PrimitiveProtos.ReturnState state) {
        if (state.getReturnCode() == Errors.ResultCode.INTERNAL_ERROR) {
            return new TajoInternalError(state);
        }
        if (EXCEPTIONS.containsKey((Object)state.getReturnCode())) {
            DefaultTajoException exception;
            try {
                Class<? extends DefaultTajoException> clazz = EXCEPTIONS.get((Object)state.getReturnCode());
                Constructor<? extends DefaultTajoException> c = clazz.getConstructor(PrimitiveProtos.ReturnState.class);
                exception = c.newInstance(state);
            }
            catch (Throwable t) {
                throw new TajoInternalError(t);
            }
            if (exception instanceof TajoException) {
                return (TajoException)exception;
            }
            if (exception instanceof TajoRuntimeException) {
                return (TajoRuntimeException)exception;
            }
            return (TajoError)exception;
        }
        throw new TajoInternalError("Cannot restore the exception for [" + state.getReturnCode().name() + "] '" + state.getMessage() + "'");
    }

    public static TajoException toTajoException(PrimitiveProtos.ReturnState state) throws TajoRuntimeException, TajoError {
        DefaultTajoException e = ExceptionUtil.toTajoExceptionCommon(state);
        if (e instanceof TajoException) {
            return (TajoException)e;
        }
        if (e instanceof TajoRuntimeException) {
            throw (TajoRuntimeException)e;
        }
        throw (TajoError)e;
    }

    public static boolean isExceptionWithResultCode(Throwable t) {
        return t instanceof DefaultTajoException;
    }

    public static boolean isManagedException(Throwable t) {
        return t instanceof TajoException || t instanceof TajoRuntimeException;
    }

    private static void printStackTrace(Log log, Throwable t) {
        log.error((Object)("\nStack Trace:\n" + StringUtils.stringifyException((Throwable)t)));
    }

    public static void printStackTraceIfError(Log log, Throwable t) {
        if (!TajoConstants.IS_TEST_MODE || TajoConstants.IS_DEBUG_MODE || !ExceptionUtil.isManagedException(t)) {
            ExceptionUtil.printStackTrace(log, t);
        }
    }

    public static UnsupportedException makeNotSupported(String feature) {
        return new UnsupportedException(feature);
    }

    public static String getExceptionLine() {
        StackTraceElement stack = Thread.currentThread().getStackTrace()[3];
        return "Line " + stack.getLineNumber() + " in " + stack.getFileName();
    }

    public static String getExceptionPoint() {
        StackTraceElement stack = Thread.currentThread().getStackTrace()[3];
        return stack.getClassName() + "::" + stack.getMethodName();
    }

    static {
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INTERNAL_ERROR, TajoInternalError.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.FEATURE_NOT_SUPPORTED, UnsupportedException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.NOT_IMPLEMENTED, NotImplementedException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.QUERY_NOT_FOUND, QueryNotFoundException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INVALID_SESSION, InvalidSessionException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.NO_SUCH_SESSION_VARIABLE, NoSuchSessionVariableException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INVALID_SESSION_VARIABLE, InvalidSessionVariableException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DIVISION_BY_ZERO, DividedByZeroException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INVALID_URL, InvalidURLException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INVALID_VALUE_FOR_CAST, InvalidValueForCastException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.SYNTAX_ERROR_OR_ACCESS_RULE_VIOLATION, SQLSyntaxError.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.SYNTAX_ERROR, SQLSyntaxError.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INSUFFICIENT_PRIVILEGE, InsufficientPrivilegeException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.CANNOT_DROP_CURRENT_DATABASE, CannotDropCurrentDatabaseException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_TABLESPACE, UndefinedTablespaceException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_DATABASE, UndefinedDatabaseException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_TABLE, UndefinedTableException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_COLUMN, UndefinedColumnException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_FUNCTION, UndefinedFunctionException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_PARTITION, UndefinedPartitionException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_PARTITION_KEY, UndefinedPartitionKeyException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_OPERATOR, UndefinedOperatorException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_INDEX_NAME, UndefinedIndexException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNDEFINED_TABLESPACE_HANDLER, UndefinedTablespaceHandlerException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DUPLICATE_TABLESPACE, DuplicateTablespaceException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DUPLICATE_DATABASE, DuplicateDatabaseException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DUPLICATE_TABLE, DuplicateTableException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DUPLICATE_COLUMN, DuplicateColumnException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DUPLICATE_INDEX, DuplicateIndexException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DUPLICATE_PARTITION, DuplicatePartitionException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.AMBIGUOUS_TABLE, AmbiguousTableException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.AMBIGUOUS_COLUMN, AmbiguousColumnException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.AMBIGUOUS_FUNCTION, AmbiguousFunctionException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.DATATYPE_MISMATCH, DataTypeMismatchException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNAVAILABLE_TABLE_LOCATION, UnavailableTableLocationException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNKNOWN_DATAFORMAT, UnknownDataFormatException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.UNSUPPORTED_DATATYPE, UnsupportedDataTypeException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INVALID_DATATYPE, InvalidDataTypeException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INVALID_TABLE_PROPERTY, InvalidTablePropertyException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.MISSING_TABLE_PROPERTY, MissingTablePropertyException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.TOO_LARGE_INPUT_FOR_CROSS_JOIN, TooLargeInputForCrossJoinException.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.INVALID_INPUTS_FOR_CROSS_JOIN, InvalidInputsForCrossJoin.class);
        ExceptionUtil.ADD_EXCEPTION(Errors.ResultCode.CAT_UNSUPPORTED_CATALOG_STORE, UnsupportedCatalogStore.class);
    }
}

