/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.exception;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.apache.tajo.QueryId;
import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.ErrorMessages;
import org.apache.tajo.exception.ErrorUtil;
import org.apache.tajo.exception.ExceptionUtil;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;
import org.apache.tajo.util.StringUtils;

public class ReturnStateUtil {
    public static final PrimitiveProtos.ReturnState OK;

    public static boolean ensureOk(PrimitiveProtos.ReturnState state) {
        if (ReturnStateUtil.isError(state)) {
            throw new TajoRuntimeException(state);
        }
        return true;
    }

    public static PrimitiveProtos.StringListResponse returnStringList(Collection<String> values) {
        return PrimitiveProtos.StringListResponse.newBuilder().setState(OK).addAllValues(values).build();
    }

    public static PrimitiveProtos.StringListResponse returnFailedStringList(Throwable t) {
        return PrimitiveProtos.StringListResponse.newBuilder().setState(ReturnStateUtil.returnError(t)).build();
    }

    public static PrimitiveProtos.ReturnState returnError(Errors.ResultCode code, String ... args) {
        Preconditions.checkNotNull((Object)args);
        PrimitiveProtos.ReturnState.Builder builder = PrimitiveProtos.ReturnState.newBuilder();
        builder.setReturnCode(code);
        builder.setMessage(ErrorMessages.getMessage(code, args));
        return builder.build();
    }

    public static PrimitiveProtos.ReturnState returnError(Throwable t) {
        PrimitiveProtos.ReturnState.Builder builder = PrimitiveProtos.ReturnState.newBuilder();
        if (ExceptionUtil.isExceptionWithResultCode(t)) {
            DefaultTajoException tajoException = (DefaultTajoException)((Object)t);
            builder.setReturnCode(tajoException.getErrorCode());
            builder.setMessage(tajoException.getMessage());
        } else {
            builder.setReturnCode(Errors.ResultCode.INTERNAL_ERROR);
            builder.setMessage(ErrorMessages.getInternalErrorMessage(t));
        }
        builder.setStackTrace(ErrorUtil.convertStacktrace(t));
        return builder.build();
    }

    public static PrimitiveProtos.ReturnState returnError(Errors.SerializedException e) {
        PrimitiveProtos.ReturnState.Builder builder = PrimitiveProtos.ReturnState.newBuilder();
        builder.setReturnCode(e.getReturnCode());
        builder.setMessage(e.getMessage());
        if (e.hasStackTrace()) {
            builder.setStackTrace(e.getStackTrace());
        }
        return builder.build();
    }

    public static boolean isSuccess(PrimitiveProtos.ReturnState state) {
        return ErrorUtil.isOk(state.getReturnCode());
    }

    public static boolean isError(PrimitiveProtos.ReturnState state) {
        return ErrorUtil.isFailed(state.getReturnCode());
    }

    public static boolean isThisError(PrimitiveProtos.ReturnState state, Errors.ResultCode code) {
        return state.getReturnCode() == code;
    }

    public static PrimitiveProtos.ReturnState errFeatureNotSupported(String feature) {
        return ReturnStateUtil.returnError(Errors.ResultCode.FEATURE_NOT_SUPPORTED, feature);
    }

    public static PrimitiveProtos.ReturnState errInvalidRpcCall(String message) {
        return ReturnStateUtil.returnError(Errors.ResultCode.INVALID_RPC_CALL, message);
    }

    public static PrimitiveProtos.ReturnState errNoSuchQueryId(QueryId queryId) {
        return ReturnStateUtil.returnError(Errors.ResultCode.QUERY_NOT_FOUND, queryId.toString());
    }

    public static PrimitiveProtos.ReturnState errNoData(QueryId queryId) {
        return ReturnStateUtil.returnError(Errors.ResultCode.NO_DATA, queryId.toString());
    }

    public static PrimitiveProtos.ReturnState errIncompleteQuery(QueryId queryId) {
        return ReturnStateUtil.returnError(Errors.ResultCode.INCOMPLETE_QUERY, queryId.toString());
    }

    public static PrimitiveProtos.ReturnState errInvalidSession(String sessionId) {
        return ReturnStateUtil.returnError(Errors.ResultCode.INVALID_SESSION, sessionId);
    }

    public static PrimitiveProtos.ReturnState errNoSessionVar(String varName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.QUERY_NOT_FOUND, varName);
    }

    public static PrimitiveProtos.ReturnState errInsufficientPrivilege(String message) {
        return ReturnStateUtil.returnError(Errors.ResultCode.INSUFFICIENT_PRIVILEGE, message);
    }

    public static PrimitiveProtos.ReturnState errUndefinedTablespace(String spaceName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_TABLESPACE, spaceName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedDatabase(String dbName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_DATABASE, dbName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedTable(String tbName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_TABLE, tbName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedPartition(String partitionName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_PARTITION, partitionName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedPartitionMethod(String tbName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_PARTITION_METHOD, tbName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedIndex(String tbName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_INDEX_FOR_TABLE, tbName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedIndex(String tbName, List<String> columnNameList) {
        String columnNames = StringUtils.join(columnNameList, ",");
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_INDEX_FOR_COLUMNS, columnNames, tbName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedIndexName(String indexName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_INDEX_NAME, indexName);
    }

    public static PrimitiveProtos.ReturnState errUndefinedFunction(String funcName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.UNDEFINED_FUNCTION, funcName);
    }

    public static PrimitiveProtos.ReturnState errDuplicateDatabase(String dbName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.DUPLICATE_DATABASE, dbName);
    }

    public static PrimitiveProtos.ReturnState errDuplicateTable(String tbName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.DUPLICATE_TABLE, tbName);
    }

    public static PrimitiveProtos.ReturnState errDuplicateIndex(String indexName) {
        return ReturnStateUtil.returnError(Errors.ResultCode.DUPLICATE_INDEX, indexName);
    }

    public static PrimitiveProtos.ReturnState errDuplicateFunction(String signature) {
        return ReturnStateUtil.returnError(Errors.ResultCode.DUPLICATE_FUNCTION, signature);
    }

    public static PrimitiveProtos.ReturnState errFeatureNotImplemented(String feature) {
        return ReturnStateUtil.returnError(Errors.ResultCode.NOT_IMPLEMENTED, feature);
    }

    static {
        PrimitiveProtos.ReturnState.Builder builder = PrimitiveProtos.ReturnState.newBuilder();
        builder.setReturnCode(Errors.ResultCode.OK);
        OK = builder.build();
    }
}

