/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.json.DatumAdapter;
import org.apache.tajo.json.GsonHelper;
import org.apache.tajo.json.GsonObject;
import org.apache.tajo.json.GsonSerDerAdapter;
import org.apache.tajo.util.TUtil;

public class CommonGsonHelper {
    private static Gson gson;
    private static Gson gsonPretty;

    private CommonGsonHelper() {
    }

    private static Map<Type, GsonSerDerAdapter> registerAdapters() {
        Map<Type, GsonSerDerAdapter> adapters = TUtil.newHashMap();
        adapters.put((Type)((Object)Datum.class), new DatumAdapter());
        return adapters;
    }

    public static Gson getInstance() {
        if (gson == null) {
            GsonHelper helper = new GsonHelper(CommonGsonHelper.registerAdapters());
            gson = helper.getGson();
        }
        return gson;
    }

    public static Gson getPrettyInstance() {
        if (gsonPretty == null) {
            GsonBuilder prettyBuilder = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation();
            GsonHelper.registerAdapters(prettyBuilder, CommonGsonHelper.registerAdapters());
            gsonPretty = prettyBuilder.create();
        }
        return gsonPretty;
    }

    public static String toJson(GsonObject object, Class<? extends GsonObject> clazz) {
        return CommonGsonHelper.getInstance().toJson((Object)object, clazz);
    }

    public static <T extends GsonObject> T fromJson(String json, Class<T> clazz) {
        return (T)((GsonObject)CommonGsonHelper.getInstance().fromJson(json, clazz));
    }

    public static JsonElement getOrDie(JsonObject object, String memberName) throws JsonParseException {
        JsonElement element;
        if (object.has(memberName) && !JsonNull.INSTANCE.equals((Object)(element = object.get(memberName)))) {
            return element;
        }
        throw new JsonParseException("Field '" + memberName + "' not found in JSON object '" + object + "'");
    }
}

