/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.AnyDatum;
import org.apache.tajo.datum.DateDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.TimeDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.json.CommonGsonHelper;
import org.apache.tajo.json.GsonSerDerAdapter;

public class DatumAdapter
implements GsonSerDerAdapter<Datum> {
    public Datum deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String typeName = CommonGsonHelper.getOrDie(jsonObject, "type").getAsString();
        TajoDataTypes.Type type = TajoDataTypes.Type.valueOf(typeName);
        switch (type) {
            case DATE: {
                return new DateDatum(CommonGsonHelper.getOrDie(jsonObject, "value").getAsInt());
            }
            case TIME: {
                return new TimeDatum(CommonGsonHelper.getOrDie(jsonObject, "value").getAsLong());
            }
            case TIMESTAMP: {
                return new TimestampDatum(CommonGsonHelper.getOrDie(jsonObject, "value").getAsLong());
            }
            case INTERVAL: {
                String[] values = CommonGsonHelper.getOrDie(jsonObject, "value").getAsString().split(",");
                return new IntervalDatum(Integer.parseInt(values[0]), Long.parseLong(values[1]));
            }
            case ANY: {
                return new AnyDatum(this.deserialize(CommonGsonHelper.getOrDie(jsonObject, "actual"), typeOfT, context));
            }
        }
        return (Datum)context.deserialize(CommonGsonHelper.getOrDie(jsonObject, "body"), DatumFactory.getDatumClass(TajoDataTypes.Type.valueOf(typeName)));
    }

    public JsonElement serialize(Datum src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        jsonObj.addProperty("type", src.type().name());
        switch (src.type()) {
            case DATE: {
                jsonObj.addProperty("value", (Number)src.asInt4());
                break;
            }
            case TIME: {
                jsonObj.addProperty("value", (Number)src.asInt8());
                break;
            }
            case TIMESTAMP: {
                jsonObj.addProperty("value", (Number)src.asInt8());
                break;
            }
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)src;
                jsonObj.addProperty("value", interval.getMonths() + "," + interval.getMilliSeconds());
                break;
            }
            case ANY: {
                jsonObj.add("actual", this.serialize(((AnyDatum)src).getActual(), typeOfSrc, context));
                break;
            }
            default: {
                jsonObj.add("body", context.serialize((Object)src));
            }
        }
        return jsonObj;
    }
}

