/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.tajo.json.GsonSerDerAdapter;

public class GsonHelper {
    private final GsonBuilder builder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation();
    private final Gson gson;

    public GsonHelper(Map<Type, GsonSerDerAdapter> adapters) {
        GsonHelper.registerAdapters(this.builder, adapters);
        this.gson = this.builder.create();
    }

    public static void registerAdapters(GsonBuilder builder, Map<Type, GsonSerDerAdapter> adapters) {
        for (Map.Entry<Type, GsonSerDerAdapter> entry : adapters.entrySet()) {
            try {
                builder.registerTypeAdapter(entry.getKey(), (Object)entry.getValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Gson getGson() {
        return this.gson;
    }
}

