/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rule;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.tajo.rule.SelfDiagnosisRule;
import org.apache.tajo.rule.SelfDiagnosisRuleDefinition;
import org.apache.tajo.rule.SelfDiagnosisRuleProvider;
import org.apache.tajo.rule.SelfDiagnosisRuleSession;
import org.apache.tajo.rule.SelfDiagnosisRuleVisibility;
import org.apache.tajo.util.TUtil;

public class SelfDiagnosisRuleEngine {
    private final Map<String, Map<String, RuleWrapper>> wrapperMap = TUtil.newHashMap();
    private static volatile SelfDiagnosisRuleEngine instance;

    private SelfDiagnosisRuleEngine() {
        this.loadPredefinedRules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SelfDiagnosisRuleEngine getInstance() {
        if (instance != null) return instance;
        Class<SelfDiagnosisRuleEngine> clazz = SelfDiagnosisRuleEngine.class;
        synchronized (SelfDiagnosisRuleEngine.class) {
            if (instance != null) return instance;
            instance = new SelfDiagnosisRuleEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void reset() {
        if (this.wrapperMap != null) {
            this.wrapperMap.clear();
        }
        this.loadPredefinedRules();
    }

    public SelfDiagnosisRuleSession newRuleSession() {
        return new SelfDiagnosisRuleSession(this);
    }

    protected Map<String, Map<String, RuleWrapper>> getRules() {
        return this.wrapperMap;
    }

    private void loadRuleData(List<SelfDiagnosisRule> ruleList) {
        for (SelfDiagnosisRule rule : ruleList) {
            RuleWrapper wrapper = new RuleWrapper(rule);
            if (!wrapper.isEnabled()) continue;
            Map<String, RuleWrapper> categoryMap = this.wrapperMap.get(wrapper.getCategoryName());
            if (categoryMap == null) {
                categoryMap = TUtil.newHashMap();
                this.wrapperMap.put(wrapper.getCategoryName(), categoryMap);
            }
            categoryMap.put(wrapper.getRuleName(), wrapper);
        }
    }

    protected void loadPredefinedRules() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ServiceLoader<SelfDiagnosisRuleProvider> serviceLoader = ServiceLoader.load(SelfDiagnosisRuleProvider.class, cl);
        Iterator<SelfDiagnosisRuleProvider> iterator = serviceLoader.iterator();
        this.wrapperMap.clear();
        while (iterator.hasNext()) {
            SelfDiagnosisRuleProvider ruleProvider = iterator.next();
            this.loadRuleData(ruleProvider.getDefinedRules());
        }
    }

    static class RuleWrapper
    implements Comparable<RuleWrapper> {
        private final String categoryName;
        private final String ruleName;
        private final int priority;
        private final boolean enabled;
        private final Class<?>[] acceptedCallers;
        private final SelfDiagnosisRule rule;

        public RuleWrapper(SelfDiagnosisRule rule) {
            this.rule = rule;
            SelfDiagnosisRuleDefinition ruleDefinition = rule.getClass().getAnnotation(SelfDiagnosisRuleDefinition.class);
            if (ruleDefinition == null) {
                throw new IllegalArgumentException(rule.getClass().getName() + " is not a valid runtime rule.");
            }
            this.categoryName = ruleDefinition.category();
            this.ruleName = ruleDefinition.name();
            this.priority = ruleDefinition.priority();
            this.enabled = ruleDefinition.enabled();
            SelfDiagnosisRuleVisibility.LimitedPrivate limitedPrivateScope = rule.getClass().getAnnotation(SelfDiagnosisRuleVisibility.LimitedPrivate.class);
            this.acceptedCallers = limitedPrivateScope != null ? Arrays.copyOf(limitedPrivateScope.acceptedCallers(), limitedPrivateScope.acceptedCallers().length) : new Class[0];
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public Class<?>[] getAcceptedCallers() {
            return this.acceptedCallers;
        }

        public SelfDiagnosisRule getRule() {
            return this.rule;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        public int compareTo(RuleWrapper o) {
            if (this.getPriority() < 0 && o.getPriority() < 0) {
                return 0;
            }
            if (this.getPriority() < 0) {
                return 1;
            }
            if (o.getPriority() < 0) {
                return -1;
            }
            return (int)Math.signum(this.getPriority() - o.getPriority());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.acceptedCallers);
            result = 31 * result + (this.categoryName == null ? 0 : this.categoryName.hashCode());
            result = 31 * result + (this.enabled ? 1231 : 1237);
            result = 31 * result + this.priority;
            result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
            result = 31 * result + (this.ruleName == null ? 0 : this.ruleName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RuleWrapper other = (RuleWrapper)obj;
            if (!Arrays.equals(this.acceptedCallers, other.acceptedCallers)) {
                return false;
            }
            if (this.categoryName == null ? other.categoryName != null : !this.categoryName.equals(other.categoryName)) {
                return false;
            }
            if (this.enabled != other.enabled) {
                return false;
            }
            if (this.priority != other.priority) {
                return false;
            }
            if (this.rule == null ? other.rule != null : !this.rule.equals(other.rule)) {
                return false;
            }
            return !(this.ruleName == null ? other.ruleName != null : !this.ruleName.equals(other.ruleName));
        }
    }
}

