/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tajo.rule.EvaluationContext;
import org.apache.tajo.rule.EvaluationFailedException;
import org.apache.tajo.rule.EvaluationResult;
import org.apache.tajo.rule.SelfDiagnosisRuleEngine;
import org.apache.tajo.util.TUtil;

public class SelfDiagnosisRuleSession {
    private final SelfDiagnosisRuleEngine ruleEngine;
    private final Set<String> categoryPredicate;
    private final Set<String> rulePredicate;

    protected SelfDiagnosisRuleSession(SelfDiagnosisRuleEngine engine) {
        this.ruleEngine = engine;
        this.categoryPredicate = TUtil.newHashSet();
        this.rulePredicate = TUtil.newHashSet();
    }

    public SelfDiagnosisRuleSession withCategoryNames(String ... categories) {
        this.categoryPredicate.addAll(Arrays.asList(categories));
        return this;
    }

    public SelfDiagnosisRuleSession withRuleNames(String ... rules) {
        this.rulePredicate.addAll(Arrays.asList(rules));
        return this;
    }

    public SelfDiagnosisRuleSession reset() {
        this.categoryPredicate.clear();
        this.rulePredicate.clear();
        return this;
    }

    public void fireRules(EvaluationContext context) throws EvaluationFailedException {
        List<SelfDiagnosisRuleEngine.RuleWrapper> candidateRules = this.getCandidateRules();
        for (SelfDiagnosisRuleEngine.RuleWrapper wrapper : candidateRules) {
            EvaluationResult result = wrapper.getRule().evaluate(context);
            if (result.getReturnCode() != EvaluationResult.EvaluationResultCode.ERROR) continue;
            throw new EvaluationFailedException(result.getMessage(), result.getThrowable());
        }
    }

    protected List<SelfDiagnosisRuleEngine.RuleWrapper> getCandidateRules() {
        Map<String, Map<String, SelfDiagnosisRuleEngine.RuleWrapper>> wrapperMap = null;
        List<SelfDiagnosisRuleEngine.RuleWrapper> candidateRules = TUtil.newList();
        wrapperMap = this.ruleEngine.getRules();
        Class<?> callerClazz = this.getCallerClassName();
        for (Map.Entry<String, Map<String, SelfDiagnosisRuleEngine.RuleWrapper>> entry : wrapperMap.entrySet()) {
            String categoryName = entry.getKey();
            if (this.categoryPredicate.size() > 0 && !this.categoryPredicate.contains(categoryName)) continue;
            Map<String, SelfDiagnosisRuleEngine.RuleWrapper> ruleMap = entry.getValue();
            for (Map.Entry<String, SelfDiagnosisRuleEngine.RuleWrapper> wrapperEntry : ruleMap.entrySet()) {
                if (this.rulePredicate.size() > 0 && !this.rulePredicate.contains(wrapperEntry.getKey())) continue;
                SelfDiagnosisRuleEngine.RuleWrapper ruleWrapper = wrapperEntry.getValue();
                if (callerClazz != null && ruleWrapper.getAcceptedCallers().length > 0 && !this.hasCallerClazz(callerClazz, ruleWrapper.getAcceptedCallers())) continue;
                candidateRules.add(ruleWrapper);
            }
        }
        Collections.sort(candidateRules);
        return candidateRules;
    }

    protected boolean hasCallerClazz(Class<?> callerClazz, Class<?>[] acceptedCallers) {
        boolean result = false;
        String callerClazzName = callerClazz.getName();
        for (Class<?> acceptedCaller : acceptedCallers) {
            if (!callerClazzName.equals(acceptedCaller.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    protected Class<?> getCallerClassName() {
        return new RuleSessionSecurityManager().getCallerClassName();
    }

    static class RuleSessionSecurityManager
    extends SecurityManager {
        RuleSessionSecurityManager() {
        }

        public Class<?> getCallerClassName() {
            int clazzIdx;
            Class<?>[] clazzArray = this.getClassContext();
            for (clazzIdx = 2; clazzIdx < clazzArray.length && clazzArray[clazzIdx].getName().equals(SelfDiagnosisRuleSession.class.getName()); ++clazzIdx) {
            }
            return clazzIdx < clazzArray.length ? clazzArray[clazzIdx] : null;
        }
    }
}

