/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.apache.tajo.conf.TajoConf;
import org.apache.tajo.service.ServiceTracker;
import org.apache.tajo.service.ServiceTrackerException;
import org.apache.tajo.service.TajoMasterInfo;
import org.apache.tajo.util.TUtil;

public class BaseServiceTracker
implements ServiceTracker {
    private final TajoConf conf;
    private TajoMasterInfo tajoMasterInfo;
    private List<TajoMasterInfo> tajoMasterInfos;

    public BaseServiceTracker(TajoConf conf) {
        this.conf = conf;
        this.tajoMasterInfo = new TajoMasterInfo();
        this.tajoMasterInfo.setActive(true);
        this.tajoMasterInfo.setAvailable(true);
        this.tajoMasterInfo.setTajoMasterAddress(conf.getSocketAddrVar(TajoConf.ConfVars.TAJO_MASTER_UMBILICAL_RPC_ADDRESS));
        this.tajoMasterInfo.setTajoClientAddress(conf.getSocketAddrVar(TajoConf.ConfVars.TAJO_MASTER_CLIENT_RPC_ADDRESS));
        this.tajoMasterInfo.setWorkerResourceTrackerAddr(conf.getSocketAddrVar(TajoConf.ConfVars.RESOURCE_TRACKER_RPC_ADDRESS));
        this.tajoMasterInfo.setCatalogAddress(conf.getSocketAddrVar(TajoConf.ConfVars.CATALOG_ADDRESS));
        this.tajoMasterInfo.setWebServerAddress(conf.getSocketAddrVar(TajoConf.ConfVars.TAJO_MASTER_INFO_ADDRESS));
        this.tajoMasterInfos = TUtil.newList(this.tajoMasterInfo);
    }

    @Override
    public boolean isHighAvailable() {
        return false;
    }

    @Override
    public InetSocketAddress getUmbilicalAddress() {
        return this.tajoMasterInfo.getTajoMasterAddress();
    }

    @Override
    public InetSocketAddress getClientServiceAddress() {
        return this.tajoMasterInfo.getTajoClientAddress();
    }

    @Override
    public InetSocketAddress getResourceTrackerAddress() {
        return this.tajoMasterInfo.getWorkerResourceTrackerAddr();
    }

    @Override
    public InetSocketAddress getCatalogAddress() {
        return this.tajoMasterInfo.getCatalogAddress();
    }

    @Override
    public InetSocketAddress getMasterHttpInfo() throws ServiceTrackerException {
        return this.tajoMasterInfo.getWebServerAddress();
    }

    @Override
    public int getState(String masterName, TajoConf conf) throws ServiceTrackerException {
        String masterAddress = this.getMasterAddress();
        if (masterAddress.equals(masterName)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int formatHA(TajoConf conf) throws ServiceTrackerException {
        throw new ServiceTrackerException("Cannot format HA directories on non-HA mode");
    }

    @Override
    public List<String> getMasters(TajoConf conf) throws ServiceTrackerException {
        List<String> list = TUtil.newList();
        list.add(this.getMasterAddress());
        return list;
    }

    @Override
    public void register() throws IOException {
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean isActiveMaster() {
        return true;
    }

    @Override
    public List<TajoMasterInfo> getMasters() throws IOException {
        return this.tajoMasterInfos;
    }

    private String getMasterAddress() {
        String masterAddress = this.tajoMasterInfo.getTajoMasterAddress().getAddress().getHostAddress() + ":" + this.tajoMasterInfo.getTajoMasterAddress().getPort();
        return masterAddress;
    }
}

