/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.tajo.service.ServiceTracker;

public abstract class HAServiceTracker
implements ServiceTracker {
    private static final Log LOG = LogFactory.getLog(HAServiceTracker.class);
    static SocketFactory socketFactory = SocketFactory.getDefault();

    @Override
    public boolean isHighAvailable() {
        return true;
    }

    public static boolean checkConnection(String address) {
        return HAServiceTracker.checkConnection(address, ":");
    }

    public static boolean checkConnection(String address, String delimiter) {
        String[] hostAddress = address.split(delimiter);
        InetSocketAddress socketAddress = new InetSocketAddress(hostAddress[0], Integer.parseInt(hostAddress[1]));
        return HAServiceTracker.checkConnection(socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnection(InetSocketAddress address) {
        boolean isAlive = true;
        Socket socket = null;
        try {
            int connectionTimeout = 10;
            socket = socketFactory.createSocket();
            NetUtils.connect((Socket)socket, (SocketAddress)address, (int)connectionTimeout);
        }
        catch (Exception e) {
            isAlive = false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return isAlive;
    }
}

