/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.internal.PlatformDependent;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tajo.TajoConstants;
import org.apache.tajo.conf.TajoConf;

public class BufferPool {
    public static final String ALLOW_CACHE = "tajo.storage.buffer.thread-local.cache";
    private static final ByteBufAllocator ALLOCATOR;

    private BufferPool() {
    }

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        if (numCores == 0) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        return new PooledByteBufAllocator(allowDirectBufs && PlatformDependent.directBufferPreferred(), Math.min(BufferPool.getPrivateStaticField("DEFAULT_NUM_HEAP_ARENA"), numCores), Math.min(BufferPool.getPrivateStaticField("DEFAULT_NUM_DIRECT_ARENA"), allowDirectBufs ? numCores : 0), BufferPool.getPrivateStaticField("DEFAULT_PAGE_SIZE"), BufferPool.getPrivateStaticField("DEFAULT_MAX_ORDER"), allowCache ? BufferPool.getPrivateStaticField("DEFAULT_TINY_CACHE_SIZE") : 0, allowCache ? BufferPool.getPrivateStaticField("DEFAULT_SMALL_CACHE_SIZE") : 0, allowCache ? BufferPool.getPrivateStaticField("DEFAULT_NORMAL_CACHE_SIZE") : 0);
    }

    private static int getPrivateStaticField(String name) {
        try {
            Field f = PooledByteBufAllocator.DEFAULT.getClass().getDeclaredField(name);
            f.setAccessible(true);
            return f.getInt(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static long maxDirectMemory() {
        return PlatformDependent.maxDirectMemory();
    }

    public static ByteBuf directBuffer(int size) {
        return BufferPool.directBuffer(size, ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuf directBuffer(int size, ByteOrder order) {
        ByteBuf byteBuf = ALLOCATOR.directBuffer(size);
        if (byteBuf.order() != order) {
            byteBuf.order(order);
        }
        return byteBuf;
    }

    public static ByteBuf directBuffer(int size, int max) {
        return BufferPool.directBuffer(size, max, ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuf directBuffer(int size, int max, ByteOrder order) {
        ByteBuf byteBuf = ALLOCATOR.directBuffer(size, max);
        if (byteBuf.order() != order) {
            byteBuf.order(order);
        }
        return byteBuf;
    }

    public static ByteBuf heapBuffer(int size, int max) {
        return Unpooled.buffer((int)size, (int)max).order(ByteOrder.LITTLE_ENDIAN);
    }

    @InterfaceStability.Unstable
    public static void forceRelease(ByteBuf buf) {
        buf.release(buf.refCnt());
    }

    public static ByteBuf ensureWritable(ByteBuf buf, int minWritableBytes) {
        return buf.ensureWritable(minWritableBytes).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static void free(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)byteBuffer);
    }

    public static BufferPoolMXBean getDirectBufferPool() {
        for (BufferPoolMXBean pool : BufferPool.getBufferPools()) {
            if (!pool.getName().equals("direct")) continue;
            return pool;
        }
        return null;
    }

    public static BufferPoolMXBean getMappedBufferPool() {
        for (BufferPoolMXBean pool : BufferPool.getBufferPools()) {
            if (!pool.getName().equals("mapped")) continue;
            return pool;
        }
        return null;
    }

    private static List<BufferPoolMXBean> getBufferPools() {
        return ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    }

    static {
        if (TajoConstants.IS_TEST_MODE) {
            ALLOCATOR = UnpooledByteBufAllocator.DEFAULT;
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
        } else {
            TajoConf tajoConf = new TajoConf();
            ALLOCATOR = BufferPool.createPooledByteBufAllocator(true, tajoConf.getBoolean(ALLOW_CACHE, true), 0);
        }
    }
}

