/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.storage;

import com.google.gson.annotations.Expose;
import java.net.InetAddress;
import java.util.Arrays;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.Inet4Datum;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.exception.NotImplementedException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.util.datetime.TimeMeta;

public class VTuple
implements Tuple,
Cloneable {
    @Expose
    public Datum[] values;
    @Expose
    private long offset;

    public VTuple(int size) {
        this.values = new Datum[size];
    }

    public VTuple(Tuple tuple) {
        this.values = (Datum[])tuple.getValues().clone();
    }

    public VTuple(Datum[] datum) {
        this(datum.length);
        this.values = Arrays.copyOf(datum, datum.length);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean contains(int fieldId) {
        return this.values[fieldId] != null;
    }

    @Override
    public boolean isBlank(int fieldid) {
        return this.values[fieldid] == null;
    }

    @Override
    public boolean isBlankOrNull(int fieldid) {
        return this.values[fieldid] == null || this.values[fieldid].isNull();
    }

    @Override
    public void put(int fieldId, Tuple tuple) {
        this.put(fieldId, tuple.asDatum(fieldId));
    }

    @Override
    public void clear() {
        this.clearOffset();
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = null;
        }
    }

    @Override
    public void put(int fieldId, Datum value) {
        this.values[fieldId] = value;
    }

    @Override
    public Datum asDatum(int fieldId) {
        return this.values[fieldId] == null ? null : this.values[fieldId];
    }

    @Override
    public TajoDataTypes.Type type(int fieldId) {
        return this.values[fieldId].type();
    }

    @Override
    public int size(int fieldId) {
        return this.values[fieldId].size();
    }

    @Override
    public void put(Datum[] values) {
        this.clearOffset();
        System.arraycopy(values, 0, this.values, 0, values.length);
    }

    public Datum get(int fieldId) {
        return this.values[fieldId];
    }

    @Override
    public void clearOffset() {
        this.offset = -1L;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public boolean getBool(int fieldId) {
        return this.values[fieldId].asBool();
    }

    @Override
    public byte getByte(int fieldId) {
        return this.values[fieldId].asByte();
    }

    @Override
    public char getChar(int fieldId) {
        return this.values[fieldId].asChar();
    }

    @Override
    public byte[] getBytes(int fieldId) {
        return this.values[fieldId].asByteArray();
    }

    @Override
    public byte[] getTextBytes(int fieldId) {
        return this.values[fieldId].asTextBytes();
    }

    @Override
    public short getInt2(int fieldId) {
        return this.values[fieldId].asInt2();
    }

    @Override
    public int getInt4(int fieldId) {
        return this.values[fieldId].asInt4();
    }

    @Override
    public long getInt8(int fieldId) {
        return this.values[fieldId].asInt8();
    }

    @Override
    public float getFloat4(int fieldId) {
        return this.values[fieldId].asFloat4();
    }

    @Override
    public double getFloat8(int fieldId) {
        return this.values[fieldId].asFloat8();
    }

    public Inet4Datum getIPv4(int fieldId) {
        return (Inet4Datum)this.values[fieldId];
    }

    public byte[] getIPv4Bytes(int fieldId) {
        return this.values[fieldId].asByteArray();
    }

    public InetAddress getIPv6(int fieldId) {
        throw new TajoRuntimeException(new NotImplementedException());
    }

    public byte[] getIPv6Bytes(int fieldId) {
        throw new TajoRuntimeException(new NotImplementedException());
    }

    @Override
    public String getText(int fieldId) {
        return this.values[fieldId].asChars();
    }

    @Override
    public TimeMeta getTimeDate(int fieldId) {
        return this.values[fieldId].asTimeMeta();
    }

    @Override
    public ProtobufDatum getProtobufDatum(int fieldId) {
        return (ProtobufDatum)this.values[fieldId];
    }

    @Override
    public IntervalDatum getInterval(int fieldId) {
        return (IntervalDatum)this.values[fieldId];
    }

    @Override
    public char[] getUnicodeChars(int fieldId) {
        return this.values[fieldId].asUnicodeChars();
    }

    @Override
    public VTuple clone() throws CloneNotSupportedException {
        VTuple tuple = (VTuple)super.clone();
        tuple.values = new Datum[this.values.length];
        System.arraycopy(this.values, 0, tuple.values, 0, this.values.length);
        return tuple;
    }

    public String toString() {
        return VTuple.toDisplayString(this.getValues());
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public Datum[] getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tuple) {
            Tuple other = (Tuple)obj;
            return Arrays.equals(this.getValues(), other.getValues());
        }
        return false;
    }

    public static String toDisplayString(Datum[] values) {
        StringBuilder str = new StringBuilder();
        str.append('(');
        for (Datum datum : values) {
            if (str.length() > 1) {
                str.append(',');
            }
            str.append(datum);
        }
        str.append(')');
        return str.toString();
    }
}

